/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.app.engine;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.ServiceLoader;
import javax.sql.DataSource;
import org.apache.ibatis.session.Configuration;
import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;
import org.flowable.app.api.AppEngineConfigurationApi;
import org.flowable.app.api.AppManagementService;
import org.flowable.app.api.AppRepositoryService;
import org.flowable.app.api.repository.AppResourceConverter;
import org.flowable.app.engine.AppEngine;
import org.flowable.app.engine.impl.AppEngineImpl;
import org.flowable.app.engine.impl.AppManagementServiceImpl;
import org.flowable.app.engine.impl.AppRepositoryServiceImpl;
import org.flowable.app.engine.impl.cfg.StandaloneInMemAppEngineConfiguration;
import org.flowable.app.engine.impl.db.AppDbSchemaManager;
import org.flowable.app.engine.impl.db.EntityDependencyOrder;
import org.flowable.app.engine.impl.deployer.AppDeployer;
import org.flowable.app.engine.impl.deployer.AppDeploymentManager;
import org.flowable.app.engine.impl.deployer.AppResourceConverterImpl;
import org.flowable.app.engine.impl.el.AppExpressionManager;
import org.flowable.app.engine.impl.interceptor.AppCommandInvoker;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppDefinitionEntityManagerImpl;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppDeploymentEntityManagerImpl;
import org.flowable.app.engine.impl.persistence.entity.AppResourceEntityManager;
import org.flowable.app.engine.impl.persistence.entity.AppResourceEntityManagerImpl;
import org.flowable.app.engine.impl.persistence.entity.data.AppDefinitionDataManager;
import org.flowable.app.engine.impl.persistence.entity.data.AppDeploymentDataManager;
import org.flowable.app.engine.impl.persistence.entity.data.AppResourceDataManager;
import org.flowable.app.engine.impl.persistence.entity.data.TableDataManager;
import org.flowable.app.engine.impl.persistence.entity.data.impl.MybatisAppDefinitionDataManager;
import org.flowable.app.engine.impl.persistence.entity.data.impl.MybatisAppDeploymentDataManager;
import org.flowable.app.engine.impl.persistence.entity.data.impl.MybatisResourceDataManager;
import org.flowable.app.engine.impl.persistence.entity.data.impl.TableDataManagerImpl;
import org.flowable.app.engine.impl.persistence.entity.deploy.AppDefinitionCacheEntry;
import org.flowable.common.engine.impl.AbstractEngineConfiguration;
import org.flowable.common.engine.impl.AbstractServiceConfiguration;
import org.flowable.common.engine.impl.EngineConfigurator;
import org.flowable.common.engine.impl.EngineDeployer;
import org.flowable.common.engine.impl.HasExpressionManagerEngineConfiguration;
import org.flowable.common.engine.impl.calendar.BusinessCalendar;
import org.flowable.common.engine.impl.calendar.BusinessCalendarManager;
import org.flowable.common.engine.impl.calendar.CycleBusinessCalendar;
import org.flowable.common.engine.impl.calendar.DueDateBusinessCalendar;
import org.flowable.common.engine.impl.calendar.DurationBusinessCalendar;
import org.flowable.common.engine.impl.calendar.MapBusinessCalendarManager;
import org.flowable.common.engine.impl.cfg.BeansConfigurationHelper;
import org.flowable.common.engine.impl.db.DbSchemaManager;
import org.flowable.common.engine.impl.el.ExpressionManager;
import org.flowable.common.engine.impl.interceptor.CommandInterceptor;
import org.flowable.common.engine.impl.persistence.deploy.DefaultDeploymentCache;
import org.flowable.common.engine.impl.persistence.deploy.DeploymentCache;
import org.flowable.common.engine.impl.runtime.ClockReader;
import org.flowable.common.engine.impl.util.ReflectUtil;
import org.flowable.identitylink.service.IdentityLinkServiceConfiguration;
import org.flowable.identitylink.service.impl.db.IdentityLinkDbSchemaManager;
import org.flowable.idm.api.IdmIdentityService;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.configurator.IdmEngineConfigurator;
import org.flowable.variable.api.types.VariableType;
import org.flowable.variable.api.types.VariableTypes;
import org.flowable.variable.service.VariableServiceConfiguration;
import org.flowable.variable.service.impl.db.IbatisVariableTypeHandler;
import org.flowable.variable.service.impl.db.VariableDbSchemaManager;
import org.flowable.variable.service.impl.types.BooleanType;
import org.flowable.variable.service.impl.types.ByteArrayType;
import org.flowable.variable.service.impl.types.DateType;
import org.flowable.variable.service.impl.types.DefaultVariableTypes;
import org.flowable.variable.service.impl.types.DoubleType;
import org.flowable.variable.service.impl.types.IntegerType;
import org.flowable.variable.service.impl.types.JodaDateTimeType;
import org.flowable.variable.service.impl.types.JodaDateType;
import org.flowable.variable.service.impl.types.JsonType;
import org.flowable.variable.service.impl.types.LongJsonType;
import org.flowable.variable.service.impl.types.LongStringType;
import org.flowable.variable.service.impl.types.LongType;
import org.flowable.variable.service.impl.types.NullType;
import org.flowable.variable.service.impl.types.SerializableType;
import org.flowable.variable.service.impl.types.ShortType;
import org.flowable.variable.service.impl.types.StringType;
import org.flowable.variable.service.impl.types.UUIDType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AppEngineConfiguration
extends AbstractEngineConfiguration
implements AppEngineConfigurationApi,
HasExpressionManagerEngineConfiguration {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AppEngineConfiguration.class);
    public static final String DEFAULT_MYBATIS_MAPPING_FILE = "org/flowable/app/db/mapping/mappings.xml";
    public static final String LIQUIBASE_CHANGELOG_PREFIX = "ACT_APP_";
    protected String cmmnEngineName = "default";
    protected AppManagementService appManagementService = new AppManagementServiceImpl(this);
    protected AppRepositoryService appRepositoryService = new AppRepositoryServiceImpl(this);
    protected TableDataManager tableDataManager;
    protected AppDeploymentDataManager deploymentDataManager;
    protected AppResourceDataManager resourceDataManager;
    protected AppDefinitionDataManager appDefinitionDataManager;
    protected AppDeploymentEntityManager appDeploymentEntityManager;
    protected AppResourceEntityManager appResourceEntityManager;
    protected AppDefinitionEntityManager appDefinitionEntityManager;
    protected boolean disableIdmEngine;
    protected boolean executeServiceDbSchemaManagers = true;
    protected AppDeployer appDeployer;
    protected AppDeploymentManager deploymentManager;
    protected AppResourceConverter appResourceConverter;
    protected int appDefinitionCacheLimit = -1;
    protected DeploymentCache<AppDefinitionCacheEntry> appDefinitionCache;
    protected ExpressionManager expressionManager;
    protected DbSchemaManager identityLinkDbSchemaManager;
    protected DbSchemaManager variableDbSchemaManager;
    protected boolean enableConfiguratorServiceLoader = true;
    protected List<EngineConfigurator> configurators;
    protected List<EngineConfigurator> allConfigurators;
    protected EngineConfigurator idmEngineConfigurator;
    protected IdentityLinkServiceConfiguration identityLinkServiceConfiguration;
    protected VariableTypes variableTypes;
    protected List<VariableType> customPreVariableTypes;
    protected List<VariableType> customPostVariableTypes;
    protected VariableServiceConfiguration variableServiceConfiguration;
    protected boolean serializableVariableTypeTrackDeserializedObjects = true;
    protected ObjectMapper objectMapper = new ObjectMapper();
    protected BusinessCalendarManager businessCalendarManager;

    public static AppEngineConfiguration createAppEngineConfigurationFromResourceDefault() {
        return AppEngineConfiguration.createAppEngineConfigurationFromResource("flowable.app.cfg.xml", "appEngineConfiguration");
    }

    public static AppEngineConfiguration createAppEngineConfigurationFromResource(String resource) {
        return AppEngineConfiguration.createAppEngineConfigurationFromResource(resource, "appEngineConfiguration");
    }

    public static AppEngineConfiguration createAppEngineConfigurationFromResource(String resource, String beanName) {
        return (AppEngineConfiguration)BeansConfigurationHelper.parseEngineConfigurationFromResource((String)resource, (String)beanName);
    }

    public static AppEngineConfiguration createAppEngineConfigurationFromInputStream(InputStream inputStream) {
        return AppEngineConfiguration.createAppEngineConfigurationFromInputStream(inputStream, "appEngineConfiguration");
    }

    public static AppEngineConfiguration createAppEngineConfigurationFromInputStream(InputStream inputStream, String beanName) {
        return (AppEngineConfiguration)BeansConfigurationHelper.parseEngineConfigurationFromInputStream((InputStream)inputStream, (String)beanName);
    }

    public static AppEngineConfiguration createStandaloneAppEngineConfiguration() {
        return new AppEngineConfiguration();
    }

    public static AppEngineConfiguration createStandaloneInMemAppEngineConfiguration() {
        return new StandaloneInMemAppEngineConfiguration();
    }

    public AppEngine buildAppEngine() {
        this.init();
        return new AppEngineImpl(this);
    }

    protected void init() {
        this.initConfigurators();
        this.configuratorsBeforeInit();
        this.initCommandContextFactory();
        this.initTransactionContextFactory();
        this.initCommandExecutors();
        this.initIdGenerator();
        this.initExpressionManager();
        if (this.usingRelationalDatabase) {
            this.initDataSource();
            this.initDbSchemaManager();
        }
        this.initVariableTypes();
        this.initBeans();
        this.initTransactionFactory();
        if (this.usingRelationalDatabase) {
            this.initSqlSessionFactory();
        }
        this.initSessionFactories();
        this.initServices();
        this.initDataManagers();
        this.initEntityManagers();
        this.initDeployers();
        this.initAppDefinitionCache();
        this.initAppResourceConverter();
        this.initDeploymentManager();
        this.initClock();
        this.initIdentityLinkServiceConfiguration();
        this.initVariableServiceConfiguration();
        this.configuratorsAfterInit();
        this.initBusinessCalendarManager();
    }

    public void initDbSchemaManager() {
        super.initDbSchemaManager();
        this.initAppDbSchemaManager();
        if (this.executeServiceDbSchemaManagers) {
            this.initIdentityLinkDbSchemaManager();
            this.initVariableDbSchemaManager();
        }
    }

    protected void initAppDbSchemaManager() {
        if (this.dbSchemaManager == null) {
            this.dbSchemaManager = new AppDbSchemaManager();
        }
    }

    protected void initVariableDbSchemaManager() {
        if (this.variableDbSchemaManager == null) {
            this.variableDbSchemaManager = new VariableDbSchemaManager();
        }
    }

    protected void initIdentityLinkDbSchemaManager() {
        if (this.identityLinkDbSchemaManager == null) {
            this.identityLinkDbSchemaManager = new IdentityLinkDbSchemaManager();
        }
    }

    public void initMybatisTypeHandlers(Configuration configuration) {
        configuration.getTypeHandlerRegistry().register(VariableType.class, JdbcType.VARCHAR, (TypeHandler)new IbatisVariableTypeHandler(this.variableTypes));
    }

    public void initExpressionManager() {
        if (this.expressionManager == null) {
            this.expressionManager = new AppExpressionManager(this.beans);
        }
    }

    public void initCommandInvoker() {
        if (this.commandInvoker == null) {
            this.commandInvoker = new AppCommandInvoker();
        }
    }

    protected void initServices() {
        this.initService(this.appManagementService);
        this.initService(this.appRepositoryService);
    }

    public void initDataManagers() {
        if (this.tableDataManager == null) {
            this.tableDataManager = new TableDataManagerImpl();
        }
        if (this.deploymentDataManager == null) {
            this.deploymentDataManager = new MybatisAppDeploymentDataManager(this);
        }
        if (this.resourceDataManager == null) {
            this.resourceDataManager = new MybatisResourceDataManager(this);
        }
        if (this.appDefinitionDataManager == null) {
            this.appDefinitionDataManager = new MybatisAppDefinitionDataManager(this);
        }
    }

    public void initEntityManagers() {
        if (this.appDeploymentEntityManager == null) {
            this.appDeploymentEntityManager = new AppDeploymentEntityManagerImpl(this, this.deploymentDataManager);
        }
        if (this.appResourceEntityManager == null) {
            this.appResourceEntityManager = new AppResourceEntityManagerImpl(this, this.resourceDataManager);
        }
        if (this.appDefinitionEntityManager == null) {
            this.appDefinitionEntityManager = new AppDefinitionEntityManagerImpl(this, this.appDefinitionDataManager);
        }
    }

    protected void initDeployers() {
        if (this.appDeployer == null) {
            this.deployers = new ArrayList();
            if (this.customPreDeployers != null) {
                this.deployers.addAll(this.customPreDeployers);
            }
            this.deployers.addAll(this.getDefaultDeployers());
            if (this.customPostDeployers != null) {
                this.deployers.addAll(this.customPostDeployers);
            }
        }
    }

    public Collection<? extends EngineDeployer> getDefaultDeployers() {
        ArrayList<AppDeployer> defaultDeployers = new ArrayList<AppDeployer>();
        if (this.appDeployer == null) {
            this.appDeployer = new AppDeployer();
        }
        defaultDeployers.add(this.appDeployer);
        return defaultDeployers;
    }

    protected void initAppDefinitionCache() {
        if (this.appDefinitionCache == null) {
            this.appDefinitionCache = this.appDefinitionCacheLimit <= 0 ? new DefaultDeploymentCache() : new DefaultDeploymentCache(this.appDefinitionCacheLimit);
        }
    }

    protected void initAppResourceConverter() {
        if (this.appResourceConverter == null) {
            this.appResourceConverter = new AppResourceConverterImpl(this.objectMapper);
        }
    }

    protected void initDeploymentManager() {
        if (this.deploymentManager == null) {
            this.deploymentManager = new AppDeploymentManager();
            this.deploymentManager.setAppEngineConfiguration(this);
            this.deploymentManager.setAppDefinitionCache(this.appDefinitionCache);
            this.deploymentManager.setDeployers(this.deployers);
            this.deploymentManager.setAppDefinitionEntityManager(this.appDefinitionEntityManager);
            this.deploymentManager.setDeploymentEntityManager(this.appDeploymentEntityManager);
        }
    }

    public String getEngineCfgKey() {
        return "cfg.appEngine";
    }

    public CommandInterceptor createTransactionInterceptor() {
        return null;
    }

    public InputStream getMyBatisXmlConfigurationStream() {
        return this.getResourceAsStream(DEFAULT_MYBATIS_MAPPING_FILE);
    }

    protected void initDbSqlSessionFactoryEntitySettings() {
        this.defaultInitDbSqlSessionFactoryEntitySettings(EntityDependencyOrder.INSERT_ORDER, EntityDependencyOrder.DELETE_ORDER);
    }

    public void initConfigurators() {
        this.allConfigurators = new ArrayList<EngineConfigurator>();
        if (!this.disableIdmEngine) {
            if (this.idmEngineConfigurator != null) {
                this.allConfigurators.add(this.idmEngineConfigurator);
            } else {
                this.allConfigurators.add((EngineConfigurator)new IdmEngineConfigurator());
            }
        }
        if (this.configurators != null) {
            this.allConfigurators.addAll(this.configurators);
        }
        if (this.enableConfiguratorServiceLoader) {
            ClassLoader classLoader = this.getClassLoader();
            if (classLoader == null) {
                classLoader = ReflectUtil.getClassLoader();
            }
            ServiceLoader<EngineConfigurator> configuratorServiceLoader = ServiceLoader.load(EngineConfigurator.class, classLoader);
            int nrOfServiceLoadedConfigurators = 0;
            for (EngineConfigurator configurator : configuratorServiceLoader) {
                this.allConfigurators.add(configurator);
                ++nrOfServiceLoadedConfigurators;
            }
            if (nrOfServiceLoadedConfigurators > 0) {
                LOGGER.info("Found {} auto-discoverable Process Engine Configurator{}", (Object)nrOfServiceLoadedConfigurators++, (Object)(nrOfServiceLoadedConfigurators > 1 ? "s" : ""));
            }
            if (!this.allConfigurators.isEmpty()) {
                Collections.sort(this.allConfigurators, new Comparator<EngineConfigurator>(){

                    @Override
                    public int compare(EngineConfigurator configurator1, EngineConfigurator configurator2) {
                        int priority2;
                        int priority1 = configurator1.getPriority();
                        if (priority1 < (priority2 = configurator2.getPriority())) {
                            return -1;
                        }
                        if (priority1 > priority2) {
                            return 1;
                        }
                        return 0;
                    }
                });
                LOGGER.info("Found {} Engine Configurators in total:", (Object)this.allConfigurators.size());
                for (EngineConfigurator configurator : this.allConfigurators) {
                    LOGGER.info("{} (priority:{})", configurator.getClass(), (Object)configurator.getPriority());
                }
            }
        }
    }

    public void configuratorsBeforeInit() {
        for (EngineConfigurator configurator : this.allConfigurators) {
            LOGGER.info("Executing beforeInit() of {} (priority:{})", configurator.getClass(), (Object)configurator.getPriority());
            configurator.beforeInit((AbstractEngineConfiguration)this);
        }
    }

    public void configuratorsAfterInit() {
        for (EngineConfigurator configurator : this.allConfigurators) {
            LOGGER.info("Executing configure() of {} (priority:{})", configurator.getClass(), (Object)configurator.getPriority());
            configurator.configure((AbstractEngineConfiguration)this);
        }
    }

    public void initVariableTypes() {
        if (this.variableTypes == null) {
            this.variableTypes = new DefaultVariableTypes();
            if (this.customPreVariableTypes != null) {
                for (VariableType customVariableType : this.customPreVariableTypes) {
                    this.variableTypes.addType(customVariableType);
                }
            }
            this.variableTypes.addType((VariableType)new NullType());
            this.variableTypes.addType((VariableType)new StringType(this.getMaxLengthString()));
            this.variableTypes.addType((VariableType)new LongStringType(this.getMaxLengthString() + 1));
            this.variableTypes.addType((VariableType)new BooleanType());
            this.variableTypes.addType((VariableType)new ShortType());
            this.variableTypes.addType((VariableType)new IntegerType());
            this.variableTypes.addType((VariableType)new LongType());
            this.variableTypes.addType((VariableType)new DateType());
            this.variableTypes.addType((VariableType)new JodaDateType());
            this.variableTypes.addType((VariableType)new JodaDateTimeType());
            this.variableTypes.addType((VariableType)new DoubleType());
            this.variableTypes.addType((VariableType)new UUIDType());
            this.variableTypes.addType((VariableType)new JsonType(this.getMaxLengthString(), this.objectMapper));
            this.variableTypes.addType((VariableType)new LongJsonType(this.getMaxLengthString() + 1, this.objectMapper));
            this.variableTypes.addType((VariableType)new ByteArrayType());
            this.variableTypes.addType((VariableType)new SerializableType(this.serializableVariableTypeTrackDeserializedObjects));
            if (this.customPostVariableTypes != null) {
                for (VariableType customVariableType : this.customPostVariableTypes) {
                    this.variableTypes.addType(customVariableType);
                }
            }
        }
    }

    public void initVariableServiceConfiguration() {
        this.variableServiceConfiguration = new VariableServiceConfiguration();
        this.variableServiceConfiguration.setClock(this.clock);
        this.variableServiceConfiguration.setObjectMapper(this.objectMapper);
        this.variableServiceConfiguration.setEventDispatcher(this.eventDispatcher);
        this.variableServiceConfiguration.setVariableTypes(this.variableTypes);
        this.variableServiceConfiguration.setMaxLengthString(this.getMaxLengthString());
        this.variableServiceConfiguration.setSerializableVariableTypeTrackDeserializedObjects(this.isSerializableVariableTypeTrackDeserializedObjects());
        this.variableServiceConfiguration.init();
        this.addServiceConfiguration("cfg.variableService", (AbstractServiceConfiguration)this.variableServiceConfiguration);
    }

    public void initIdentityLinkServiceConfiguration() {
        this.identityLinkServiceConfiguration = new IdentityLinkServiceConfiguration();
        this.identityLinkServiceConfiguration.setClock(this.clock);
        this.identityLinkServiceConfiguration.setObjectMapper(this.objectMapper);
        this.identityLinkServiceConfiguration.setEventDispatcher(this.eventDispatcher);
        this.identityLinkServiceConfiguration.init();
        this.addServiceConfiguration("cfg.identityLinkService", (AbstractServiceConfiguration)this.identityLinkServiceConfiguration);
    }

    public void initBusinessCalendarManager() {
        if (this.businessCalendarManager == null) {
            MapBusinessCalendarManager mapBusinessCalendarManager = new MapBusinessCalendarManager();
            mapBusinessCalendarManager.addBusinessCalendar(DurationBusinessCalendar.NAME, (BusinessCalendar)new DurationBusinessCalendar((ClockReader)this.clock));
            mapBusinessCalendarManager.addBusinessCalendar("dueDate", (BusinessCalendar)new DueDateBusinessCalendar((ClockReader)this.clock));
            mapBusinessCalendarManager.addBusinessCalendar(CycleBusinessCalendar.NAME, (BusinessCalendar)new CycleBusinessCalendar((ClockReader)this.clock));
            this.businessCalendarManager = mapBusinessCalendarManager;
        }
    }

    public String getEngineName() {
        return this.cmmnEngineName;
    }

    public String getCmmnEngineName() {
        return this.cmmnEngineName;
    }

    public AppEngineConfiguration setCmmnEngineName(String cmmnEngineName) {
        this.cmmnEngineName = cmmnEngineName;
        return this;
    }

    public AppManagementService getAppManagementService() {
        return this.appManagementService;
    }

    public AppEngineConfiguration setAppManagementService(AppManagementService appManagementService) {
        this.appManagementService = appManagementService;
        return this;
    }

    public AppRepositoryService getAppRepositoryService() {
        return this.appRepositoryService;
    }

    public AppEngineConfiguration setAppRepositoryService(AppRepositoryService appRepositoryService) {
        this.appRepositoryService = appRepositoryService;
        return this;
    }

    public IdmIdentityService getIdmIdentityService() {
        return ((IdmEngineConfiguration)this.engineConfigurations.get("cfg.idmEngine")).getIdmIdentityService();
    }

    public TableDataManager getTableDataManager() {
        return this.tableDataManager;
    }

    public AppEngineConfiguration setTableDataManager(TableDataManager tableDataManager) {
        this.tableDataManager = tableDataManager;
        return this;
    }

    public AppDeploymentDataManager getDeploymentDataManager() {
        return this.deploymentDataManager;
    }

    public AppEngineConfiguration setDeploymentDataManager(AppDeploymentDataManager deploymentDataManager) {
        this.deploymentDataManager = deploymentDataManager;
        return this;
    }

    public AppResourceDataManager getResourceDataManager() {
        return this.resourceDataManager;
    }

    public AppEngineConfiguration setResourceDataManager(AppResourceDataManager resourceDataManager) {
        this.resourceDataManager = resourceDataManager;
        return this;
    }

    public AppDefinitionDataManager getAppDefinitionDataManager() {
        return this.appDefinitionDataManager;
    }

    public AppEngineConfiguration setAppDefinitionDataManager(AppDefinitionDataManager appDefinitionDataManager) {
        this.appDefinitionDataManager = appDefinitionDataManager;
        return this;
    }

    public AppDeploymentEntityManager getAppDeploymentEntityManager() {
        return this.appDeploymentEntityManager;
    }

    public AppEngineConfiguration setAppDeploymentEntityManager(AppDeploymentEntityManager appDeploymentEntityManager) {
        this.appDeploymentEntityManager = appDeploymentEntityManager;
        return this;
    }

    public AppResourceEntityManager getAppResourceEntityManager() {
        return this.appResourceEntityManager;
    }

    public AppEngineConfiguration setAppResourceEntityManager(AppResourceEntityManager appResourceEntityManager) {
        this.appResourceEntityManager = appResourceEntityManager;
        return this;
    }

    public AppDefinitionEntityManager getAppDefinitionEntityManager() {
        return this.appDefinitionEntityManager;
    }

    public AppEngineConfiguration setAppDefinitionEntityManager(AppDefinitionEntityManager appDefinitionEntityManager) {
        this.appDefinitionEntityManager = appDefinitionEntityManager;
        return this;
    }

    public AppDeployer getAppDeployer() {
        return this.appDeployer;
    }

    public AppEngineConfiguration setAppDeployer(AppDeployer appDeployer) {
        this.appDeployer = appDeployer;
        return this;
    }

    public AppResourceConverter getAppResourceConverter() {
        return this.appResourceConverter;
    }

    public AppEngineConfiguration setAppResourceConverter(AppResourceConverter appResourceConverter) {
        this.appResourceConverter = appResourceConverter;
        return this;
    }

    public AppDeploymentManager getDeploymentManager() {
        return this.deploymentManager;
    }

    public AppEngineConfiguration setDeploymentManager(AppDeploymentManager deploymentManager) {
        this.deploymentManager = deploymentManager;
        return this;
    }

    public int getAppDefinitionCacheLimit() {
        return this.appDefinitionCacheLimit;
    }

    public AppEngineConfiguration setAppDefinitionCacheLimit(int appDefinitionCacheLimit) {
        this.appDefinitionCacheLimit = appDefinitionCacheLimit;
        return this;
    }

    public DeploymentCache<AppDefinitionCacheEntry> getAppDefinitionCache() {
        return this.appDefinitionCache;
    }

    public AppEngineConfiguration setAppDefinitionCache(DeploymentCache<AppDefinitionCacheEntry> appDefinitionCache) {
        this.appDefinitionCache = appDefinitionCache;
        return this;
    }

    public AppEngineConfiguration setDataSource(DataSource dataSource) {
        this.dataSource = dataSource;
        return this;
    }

    public boolean isExecuteServiceDbSchemaManagers() {
        return this.executeServiceDbSchemaManagers;
    }

    public void setExecuteServiceDbSchemaManagers(boolean executeServiceDbSchemaManagers) {
        this.executeServiceDbSchemaManagers = executeServiceDbSchemaManagers;
    }

    public ExpressionManager getExpressionManager() {
        return this.expressionManager;
    }

    public AppEngineConfiguration setExpressionManager(ExpressionManager expressionManager) {
        this.expressionManager = expressionManager;
        return this;
    }

    public DbSchemaManager getIdentityLinkDbSchemaManager() {
        return this.identityLinkDbSchemaManager;
    }

    public AppEngineConfiguration setIdentityLinkDbSchemaManager(DbSchemaManager identityLinkDbSchemaManager) {
        this.identityLinkDbSchemaManager = identityLinkDbSchemaManager;
        return this;
    }

    public DbSchemaManager getVariableDbSchemaManager() {
        return this.variableDbSchemaManager;
    }

    public AppEngineConfiguration setVariableDbSchemaManager(DbSchemaManager variableDbSchemaManager) {
        this.variableDbSchemaManager = variableDbSchemaManager;
        return this;
    }

    public VariableTypes getVariableTypes() {
        return this.variableTypes;
    }

    public AppEngineConfiguration setVariableTypes(VariableTypes variableTypes) {
        this.variableTypes = variableTypes;
        return this;
    }

    public List<VariableType> getCustomPreVariableTypes() {
        return this.customPreVariableTypes;
    }

    public AppEngineConfiguration setCustomPreVariableTypes(List<VariableType> customPreVariableTypes) {
        this.customPreVariableTypes = customPreVariableTypes;
        return this;
    }

    public List<VariableType> getCustomPostVariableTypes() {
        return this.customPostVariableTypes;
    }

    public AppEngineConfiguration setCustomPostVariableTypes(List<VariableType> customPostVariableTypes) {
        this.customPostVariableTypes = customPostVariableTypes;
        return this;
    }

    public IdentityLinkServiceConfiguration getIdentityLinkServiceConfiguration() {
        return this.identityLinkServiceConfiguration;
    }

    public AppEngineConfiguration setIdentityLinkServiceConfiguration(IdentityLinkServiceConfiguration identityLinkServiceConfiguration) {
        this.identityLinkServiceConfiguration = identityLinkServiceConfiguration;
        return this;
    }

    public VariableServiceConfiguration getVariableServiceConfiguration() {
        return this.variableServiceConfiguration;
    }

    public AppEngineConfiguration setVariableServiceConfiguration(VariableServiceConfiguration variableServiceConfiguration) {
        this.variableServiceConfiguration = variableServiceConfiguration;
        return this;
    }

    public boolean isSerializableVariableTypeTrackDeserializedObjects() {
        return this.serializableVariableTypeTrackDeserializedObjects;
    }

    public AppEngineConfiguration setSerializableVariableTypeTrackDeserializedObjects(boolean serializableVariableTypeTrackDeserializedObjects) {
        this.serializableVariableTypeTrackDeserializedObjects = serializableVariableTypeTrackDeserializedObjects;
        return this;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public AppEngineConfiguration setObjectMapper(ObjectMapper objectMapper) {
        this.objectMapper = objectMapper;
        return this;
    }

    public boolean isDisableIdmEngine() {
        return this.disableIdmEngine;
    }

    public AppEngineConfiguration setDisableIdmEngine(boolean disableIdmEngine) {
        this.disableIdmEngine = disableIdmEngine;
        return this;
    }

    public boolean isEnableConfiguratorServiceLoader() {
        return this.enableConfiguratorServiceLoader;
    }

    public AppEngineConfiguration setEnableConfiguratorServiceLoader(boolean enableConfiguratorServiceLoader) {
        this.enableConfiguratorServiceLoader = enableConfiguratorServiceLoader;
        return this;
    }

    public List<EngineConfigurator> getConfigurators() {
        return this.configurators;
    }

    public AppEngineConfiguration addConfigurator(EngineConfigurator configurator) {
        if (this.configurators == null) {
            this.configurators = new ArrayList<EngineConfigurator>();
        }
        this.configurators.add(configurator);
        return this;
    }

    public AppEngineConfiguration setConfigurators(List<EngineConfigurator> configurators) {
        this.configurators = configurators;
        return this;
    }

    public EngineConfigurator getIdmEngineConfigurator() {
        return this.idmEngineConfigurator;
    }

    public AppEngineConfiguration setIdmEngineConfigurator(EngineConfigurator idmEngineConfigurator) {
        this.idmEngineConfigurator = idmEngineConfigurator;
        return this;
    }

    public BusinessCalendarManager getBusinessCalendarManager() {
        return this.businessCalendarManager;
    }

    public AppEngineConfiguration setBusinessCalendarManager(BusinessCalendarManager businessCalendarManager) {
        this.businessCalendarManager = businessCalendarManager;
        return this;
    }
}

