/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xcontent.support.filtering;

import com.fasterxml.jackson.core.filter.TokenFilter;
import java.util.ArrayList;
import java.util.Set;
import org.elasticsearch.xcontent.support.filtering.FilterPath;

public class FilterPathBasedFilter
extends TokenFilter {
    private static final TokenFilter MATCHING = new TokenFilter(){

        public String toString() {
            return "MATCHING";
        }
    };
    private static final TokenFilter NO_MATCHING = new TokenFilter(){

        public String toString() {
            return "NO_MATCHING";
        }
    };
    private final FilterPath[] filters;
    private final boolean inclusive;
    private final boolean matchFieldNamesWithDots;

    public FilterPathBasedFilter(FilterPath[] filters, boolean inclusive, boolean matchFieldNamesWithDots) {
        if (filters == null || filters.length == 0) {
            throw new IllegalArgumentException("filters cannot be null or empty");
        }
        this.inclusive = inclusive;
        this.filters = filters;
        this.matchFieldNamesWithDots = matchFieldNamesWithDots;
    }

    public FilterPathBasedFilter(Set<String> filters, boolean inclusive) {
        this(FilterPath.compile(filters), inclusive, false);
    }

    private TokenFilter evaluate(String name, FilterPath[] filterPaths) {
        if (filterPaths != null) {
            ArrayList<FilterPath> nextFilters = new ArrayList<FilterPath>();
            for (FilterPath filter : filterPaths) {
                boolean matches = filter.matches(name, nextFilters, this.matchFieldNamesWithDots);
                if (!matches) continue;
                return MATCHING;
            }
            if (!nextFilters.isEmpty()) {
                return new FilterPathBasedFilter(nextFilters.toArray(new FilterPath[nextFilters.size()]), this.inclusive, this.matchFieldNamesWithDots);
            }
        }
        return NO_MATCHING;
    }

    public TokenFilter includeProperty(String name) {
        TokenFilter filter = this.evaluate(name, this.filters);
        if (filter == MATCHING) {
            return this.inclusive ? TokenFilter.INCLUDE_ALL : null;
        }
        if (filter == NO_MATCHING) {
            return this.inclusive ? null : TokenFilter.INCLUDE_ALL;
        }
        return filter;
    }

    protected boolean _includeScalar() {
        return !this.inclusive;
    }
}

