/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.geo.geometry;

import org.elasticsearch.geo.geometry.GeometryVisitor;
import org.elasticsearch.geo.geometry.Line;
import org.elasticsearch.geo.geometry.ShapeType;

public class LinearRing
extends Line {
    public static final LinearRing EMPTY = new LinearRing();

    private LinearRing() {
    }

    public LinearRing(double[] lats, double[] lons) {
        this(lats, lons, null);
    }

    public LinearRing(double[] lats, double[] lons, double[] alts) {
        super(lats, lons, alts);
        if (lats.length < 2) {
            throw new IllegalArgumentException("linear ring cannot contain less than 2 points, found " + lats.length);
        }
        int last = lats.length - 1;
        if (lats[0] != lats[last] || lons[0] != lons[last] || alts != null && alts[0] != alts[last]) {
            throw new IllegalArgumentException("first and last points of the linear ring must be the same (it must close itself): lats[0]=" + lats[0] + " lats[" + last + "]=" + lats[last] + " lons[0]=" + lons[0] + " lons[" + last + "]=" + lons[last] + (alts == null ? "" : " alts[0]=" + alts[0] + " alts[" + last + "]=" + alts[last]));
        }
    }

    @Override
    public ShapeType type() {
        return ShapeType.LINEARRING;
    }

    @Override
    public <T, E extends Exception> T visit(GeometryVisitor<T, E> visitor) throws E {
        return visitor.visit(this);
    }
}

