/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.sisu.osgi.connect;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.eclipse.sisu.osgi.connect.PlexusConnectContent;
import org.eclipse.sisu.osgi.connect.PlexusConnectFramework;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.connect.ConnectFrameworkFactory;
import org.osgi.framework.connect.ConnectModule;
import org.osgi.framework.connect.ModuleConnector;

final class PlexusModuleConnector
implements ModuleConnector {
    private static final BundleInfo DEFAULT_BUNDLE_INFO = new BundleInfo(false, false);
    static final String MAVEN_EXTENSION_DESCRIPTOR = "META-INF/maven/extension.xml";
    private Map<String, PlexusConnectContent> modulesMap = new HashMap<String, PlexusConnectContent>();
    private File storage;
    private Map<ClassRealm, List<String>> realmBundles = new HashMap<ClassRealm, List<String>>();
    private URI frameworkBundle;
    private Set<String> installedSingletons = new HashSet<String>();

    public PlexusModuleConnector(ConnectFrameworkFactory factory) {
        this.frameworkBundle = PlexusConnectFramework.getLocationFromClass(factory.getClass());
    }

    private String getBsn(String value) {
        if (value != null) {
            return value.split(";")[0].trim();
        }
        return null;
    }

    public Optional<ConnectModule> connect(String location) throws BundleException {
        return Optional.ofNullable((ConnectModule)this.modulesMap.get(location));
    }

    public void initialize(File storage, Map<String, String> configuration) {
        this.storage = storage;
    }

    public Optional<BundleActivator> newBundleActivator() {
        return Optional.empty();
    }

    public File getStorage() {
        return this.storage;
    }

    public synchronized void installRealm(ClassRealm realm, BundleContext bundleContext, Logger logger) {
        boolean isExtensionRealm;
        Collection importRealms;
        Objects.requireNonNull(realm);
        if (this.realmBundles.containsKey(realm)) {
            return;
        }
        logger.debug("Scan realm " + realm.getId());
        ClassRealm parentRealm = realm.getParentRealm();
        if (parentRealm != null) {
            this.installRealm(parentRealm, bundleContext, logger);
        }
        ArrayList<String> installed = new ArrayList<String>();
        this.realmBundles.put(realm, installed);
        RealmExports realmExports = this.readCoreExports(logger, realm);
        LinkedHashMap<String, String> headers = new LinkedHashMap<String, String>();
        headers.put("Manifest-Version", "1.0");
        headers.put("Bundle-ManifestVersion", "2");
        String realmBundleName = PlexusModuleConnector.getRealmBundle(realm);
        headers.put("Bundle-SymbolicName", realmBundleName);
        headers.put("Bundle-Version", "1.0.0." + System.identityHashCode(realm));
        if (!realmExports.packages.isEmpty()) {
            headers.put("Export-Package", String.join((CharSequence)",", realmExports.packages));
        }
        if (!(importRealms = realm.getImportRealms()).isEmpty()) {
            headers.put("Require-Bundle", importRealms.stream().map(PlexusModuleConnector::getRealmBundle).collect(Collectors.joining(",")));
        }
        this.modulesMap.put(realmBundleName, new PlexusConnectContent(null, headers, (ClassLoader)realm));
        logger.debug("Installing " + realmBundleName + " with headers " + headers.entrySet().stream().map(entry -> (String)entry.getKey() + ": " + (String)entry.getValue()).collect(Collectors.joining("\r\n")));
        if (this.installBundle(bundleContext, realmBundleName, logger) != null) {
            installed.add(realmBundleName);
        }
        boolean bl = isExtensionRealm = !realmExports.artifacts.isEmpty() || !realmExports.bundleInfoMap.isEmpty();
        if (isExtensionRealm && realmExports.artifacts.isEmpty() && realmExports.bundleInfoMap.isEmpty()) {
            return;
        }
        for (URL url : realm.getURLs()) {
            File file = PlexusModuleConnector.getFile(url);
            if (file == null) {
                logger.debug("Cannot convert URL " + url + " to File");
                continue;
            }
            try {
                JarFile jarFile = new JarFile(file);
                try {
                    Bundle bundle;
                    Attributes mainAttributes = this.getAttributes(jarFile);
                    if (mainAttributes == null || PlexusConnectFramework.locationsMatch(this.frameworkBundle, file.getAbsolutePath())) {
                        jarFile.close();
                        continue;
                    }
                    String bundleSymbolicName = this.getBsn(mainAttributes.getValue("Bundle-SymbolicName"));
                    if (isExtensionRealm && !realmExports.bundleInfoMap.containsKey(bundleSymbolicName)) {
                        String artifactKey = PlexusModuleConnector.getArtifactKey(jarFile);
                        if (artifactKey == null || !realmExports.artifacts.contains(artifactKey)) {
                            Object identifier;
                            Object object = identifier = artifactKey == null ? file.getName() : artifactKey;
                            if (bundleSymbolicName != null) {
                                identifier = (String)identifier + " (" + bundleSymbolicName + ")";
                            }
                            logger.debug("Skip " + (String)identifier + " as it is not exported by the extension realm.");
                            jarFile.close();
                            continue;
                        }
                        logger.debug("Checking exported artifact " + artifactKey);
                    }
                    if (bundleSymbolicName == null) {
                        logger.debug("File " + file + " is not a bundle");
                        jarFile.close();
                        continue;
                    }
                    BundleInfo info = realmExports.bundleInfoMap.getOrDefault(bundleSymbolicName, DEFAULT_BUNDLE_INFO);
                    String bundleVersion = mainAttributes.getValue("Bundle-Version");
                    logger.debug("Discovered bundle " + bundleSymbolicName + " (" + bundleVersion + ") @ " + file);
                    String location = file.getAbsolutePath();
                    if (this.modulesMap.containsKey(location)) {
                        bundle = bundleContext.getBundle(location);
                    } else if (PlexusModuleConnector.isSingleton(mainAttributes) && !this.installedSingletons.add(bundleSymbolicName)) {
                        bundle = Arrays.stream(bundleContext.getBundles()).filter(b -> b.getSymbolicName().equals(bundleSymbolicName)).findFirst().orElse(null);
                        logger.debug("More than one singleton bundle found for smybolic name " + bundleSymbolicName + " one with path " + location + " and one with path " + (bundle == null ? "???" : bundle.getLocation()));
                    } else {
                        this.modulesMap.put(location, new PlexusConnectContent(jarFile, this.getHeaderFromManifest(jarFile), (ClassLoader)(info.isolated ? null : realm)));
                        bundle = this.installBundle(bundleContext, location, logger);
                    }
                    if (bundle == null) continue;
                    installed.add(location);
                    if (!info.start) continue;
                    try {
                        bundle.start();
                    }
                    catch (BundleException bundleException) {
                    }
                }
                catch (IOException e) {
                    logger.warn("Cannot process jar at " + file, (Throwable)e);
                    jarFile.close();
                }
            }
            catch (IOException e) {
                logger.warn("Cannot open jar at " + file, (Throwable)e);
            }
        }
    }

    private static boolean isSingleton(Attributes mainAttributes) {
        String bsn = mainAttributes.getValue("Bundle-SymbolicName");
        return bsn != null && bsn.contains("singleton:=true");
    }

    private static String getRealmBundle(ClassRealm realm) {
        return "sisu.connect.realm." + realm.getId().replace('>', '.').replace(':', '.');
    }

    private static String getArtifactKey(JarFile jarFile) throws IOException {
        Enumeration<JarEntry> entries = jarFile.entries();
        while (entries.hasMoreElements()) {
            JarEntry jarEntry = entries.nextElement();
            String name = jarEntry.getName();
            if (!name.startsWith("META-INF/maven/") || !name.endsWith("pom.properties")) continue;
            try (InputStream stream = jarFile.getInputStream(jarEntry);){
                Properties properties = new Properties();
                properties.load(stream);
                String string = properties.getProperty("groupId") + ":" + properties.getProperty("artifactId");
                return string;
            }
        }
        return null;
    }

    protected RealmExports readCoreExports(Logger logger, ClassRealm classRealm) {
        RealmExports exports = new RealmExports();
        Enumeration resources = classRealm.loadResourcesFromSelf(MAVEN_EXTENSION_DESCRIPTOR);
        while (resources != null && resources.hasMoreElements()) {
            URL url = (URL)resources.nextElement();
            try {
                InputStream stream = url.openStream();
                try {
                    this.parseCoreExports(stream, exports);
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                logger.warn("Cannot process extension descriptor from " + url, (Throwable)e);
            }
        }
        exports.bundleInfoMap.putAll(PlexusModuleConnector.readBundles(classRealm, logger));
        exports.jars.addAll(PlexusModuleConnector.readJars(classRealm, logger));
        return exports;
    }

    protected Bundle installBundle(BundleContext bundleContext, String location, Logger logger) {
        try {
            Bundle bundle = bundleContext.installBundle(location);
            return bundle;
        }
        catch (BundleException e) {
            if (logger.isDebugEnabled()) {
                logger.warn("Cannot install bundle at " + location, (Throwable)e);
            } else {
                logger.warn("Cannot install bundle at " + location + ": " + e.getMessage());
            }
            PlexusConnectContent content = this.modulesMap.remove(location);
            if (content != null) {
                try {
                    content.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            return null;
        }
    }

    private void parseCoreExports(InputStream stream, RealmExports exports) throws IOException {
        try {
            Xpp3Dom exportedArtifacts;
            Xpp3Dom dom = Xpp3DomBuilder.build((Reader)ReaderFactory.newXmlReader((InputStream)stream));
            if (!"extension".equals(dom.getName())) {
                return;
            }
            Xpp3Dom exportedPackages = dom.getChild("exportedPackages");
            if (exportedPackages != null) {
                Xpp3Dom[] children;
                for (Xpp3Dom child : children = exportedPackages.getChildren("exportedPackage")) {
                    String value = child.getValue();
                    if (value.endsWith(".*")) {
                        value = value.substring(0, value.length() - 2);
                    }
                    exports.packages.add(value);
                }
            }
            if ((exportedArtifacts = dom.getChild("exportedArtifacts")) != null) {
                Xpp3Dom[] children;
                for (Xpp3Dom child : children = exportedArtifacts.getChildren("exportedArtifact")) {
                    String value = child.getValue();
                    if (value.endsWith(".*")) {
                        value = value.substring(0, value.length() - 2);
                    }
                    exports.artifacts.add(value);
                }
            }
        }
        catch (XmlPullParserException e) {
            throw new IOException("parsing failed!", e);
        }
    }

    private Map<String, String> getHeaderFromManifest(JarFile jarFile) throws IOException {
        Attributes attributes = jarFile.getManifest().getMainAttributes();
        LinkedHashMap headers = new LinkedHashMap();
        attributes.forEach((key, value) -> headers.put(key.toString(), value.toString()));
        return Collections.unmodifiableMap(headers);
    }

    public synchronized void disposeRealm(ClassRealm realm, BundleContext bundleContext, Logger logger) {
        this.disposeChilds(realm, bundleContext, logger);
        List<String> remove = this.realmBundles.remove(realm);
        if (remove != null && !remove.isEmpty()) {
            logger.debug("Removing realm " + realm.getId() + " uninstalls " + remove.size() + " bundle(s)");
            for (String location : remove) {
                Bundle bundle = bundleContext.getBundle(location);
                if (bundle == null) continue;
                try {
                    bundle.uninstall();
                }
                catch (BundleException e) {
                    if (logger.isDebugEnabled()) {
                        logger.warn("Cannot uninstall bundle " + bundle.getSymbolicName(), (Throwable)e);
                        continue;
                    }
                    logger.warn("Cannot uninstall bundle " + bundle.getSymbolicName() + ": " + e);
                }
            }
        }
    }

    private void disposeChilds(ClassRealm realm, BundleContext bundleContext, Logger logger) {
        for (ClassRealm child : (ClassRealm[])this.realmBundles.keySet().toArray(ClassRealm[]::new)) {
            if (child.getParentRealm() != realm) continue;
            this.disposeRealm(child, bundleContext, logger);
        }
    }

    private Attributes getAttributes(JarFile jarFile) throws IOException {
        Manifest manifest = jarFile.getManifest();
        if (manifest == null) {
            return null;
        }
        return manifest.getMainAttributes();
    }

    private static File getFile(URL url) {
        if ("file".equalsIgnoreCase(url.getProtocol())) {
            try {
                File file = new File(url.toURI());
                if (file.getName().toLowerCase().endsWith(".jar") && file.isFile()) {
                    return file;
                }
            }
            catch (URISyntaxException uRISyntaxException) {
                // empty catch block
            }
        }
        return null;
    }

    private static Set<String> readJars(ClassRealm realm, Logger logger) {
        HashSet<String> jars = new HashSet<String>();
        Enumeration resources = realm.loadResourcesFromSelf("META-INF/sisu/connect.dependencies");
        while (resources != null && resources.hasMoreElements()) {
            URL url = (URL)resources.nextElement();
            logger.debug("Reading jars from " + url);
            Properties properties = new Properties();
            try {
                InputStream stream = url.openStream();
                try {
                    properties.load(stream);
                    for (String key : properties.stringPropertyNames()) {
                        String[] split = key.split("/", 3);
                        if (split.length != 3 || !"version".equals(split[2])) continue;
                        String version = properties.getProperty(key);
                        String artifactId = split[1];
                        jars.add(artifactId + "-" + version + ".jar");
                    }
                }
                finally {
                    if (stream == null) continue;
                    stream.close();
                }
            }
            catch (IOException e) {
                logger.warn("Cannot read jar infos from url " + url);
            }
        }
        return jars;
    }

    private static Map<String, BundleInfo> readBundles(ClassRealm realm, Logger logger) {
        LinkedHashMap<String, BundleInfo> bundleInfos = new LinkedHashMap<String, BundleInfo>();
        Enumeration resources = realm.loadResourcesFromSelf("META-INF/sisu/connect.bundles");
        while (resources != null && resources.hasMoreElements()) {
            URL url = (URL)resources.nextElement();
            logger.debug("Reading extra bundles from " + url);
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(url.openStream()));){
                reader.lines().forEachOrdered(line -> {
                    if (line.startsWith("#") || line.isBlank()) {
                        return;
                    }
                    String[] split = line.split(",", 2);
                    boolean start = split.length == 2 ? Boolean.parseBoolean(split[1]) : false;
                    String bsn = split[0];
                    boolean isolated = bsn.startsWith(">");
                    if (isolated) {
                        bsn = bsn.substring(1);
                    }
                    bundleInfos.put(bsn, new BundleInfo(start, isolated));
                });
            }
            catch (IOException e) {
                logger.warn("Cannot read bundle infos from url " + url);
            }
        }
        return bundleInfos;
    }

    private static final class RealmExports {
        final Set<String> packages = new HashSet<String>();
        final Set<String> artifacts = new HashSet<String>();
        final Set<String> jars = new HashSet<String>();
        final Map<String, BundleInfo> bundleInfoMap = new LinkedHashMap<String, BundleInfo>();

        private RealmExports() {
        }
    }

    private record BundleInfo(boolean start, boolean isolated) {
    }
}

