/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.equinox.internal.p2.artifact.repository.ArtifactRepositoryComponent;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager;
import org.eclipse.tycho.IRepositoryIdManager;
import org.eclipse.tycho.helper.MavenPropertyHelper;
import org.eclipse.tycho.p2maven.transport.MavenAuthenticator;
import org.eclipse.tycho.p2maven.transport.P2MirrorDisablingArtifactRepositoryManager;
import org.eclipse.tycho.p2maven.transport.RemoteArtifactRepositoryManager;
import org.eclipse.tycho.version.TychoVersion;

@Component(role=IAgentServiceFactory.class, hint="org.eclipse.equinox.p2.repository.artifact.IArtifactRepositoryManager")
public class RemoteArtifactRepositoryManagerAgentFactory
implements IAgentServiceFactory {
    @Requirement
    Logger logger;
    @Requirement
    IRepositoryIdManager repositoryIdManager;
    @Requirement
    MavenAuthenticator authenticator;
    @Requirement
    MavenPropertyHelper propertyHelper;

    public Object createService(IProvisioningAgent agent) {
        IArtifactRepositoryManager plainRepoManager = (IArtifactRepositoryManager)new ArtifactRepositoryComponent().createService(agent);
        if (this.getDisableP2MirrorsConfiguration()) {
            plainRepoManager = new P2MirrorDisablingArtifactRepositoryManager(plainRepoManager, this.logger);
        }
        return new RemoteArtifactRepositoryManager(plainRepoManager, this.repositoryIdManager, this.authenticator);
    }

    private boolean getDisableP2MirrorsConfiguration() {
        String deprecatedKey = "tycho.disableP2Mirrors";
        String deprecatedValue = this.propertyHelper.getGlobalProperty(deprecatedKey);
        if (deprecatedValue != null) {
            this.logger.info("Using " + deprecatedKey + " to disable P2 mirrors is deprecated, use the property eclipse.p2.mirrors instead, see https://tycho.eclipseprojects.io/doc/" + TychoVersion.getTychoVersion() + "/SystemProperties.html for details.");
            return this.getBooleanValue(deprecatedValue);
        }
        String value = this.propertyHelper.getGlobalProperty("eclipse.p2.mirrors");
        if (value != null) {
            boolean p2MirrorsEnabled = this.getBooleanValue(value);
            return !p2MirrorsEnabled;
        }
        return false;
    }

    private boolean getBooleanValue(String value) {
        if (value != null && value.isBlank()) {
            return true;
        }
        return Boolean.parseBoolean(value);
    }
}

