/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tycho.p2maven.transport;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.Objects;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.eclipse.tycho.p2maven.transport.HttpCache;
import org.eclipse.tycho.p2maven.transport.HttpTransportFactory;
import org.eclipse.tycho.p2maven.transport.TransportProtocolHandler;

@Component(role=TransportProtocolHandler.class, hint="http")
public class HttpTransportProtocolHandler
implements TransportProtocolHandler {
    static final String TRANSPORT_TYPE = System.getProperty("tycho.p2.httptransport.type", "Java11Client");
    @Requirement
    Map<String, HttpTransportFactory> transportFactoryMap;
    @Requirement
    HttpCache httpCache;
    @Requirement
    Logger logger;

    private HttpTransportFactory getTransportFactory() {
        return Objects.requireNonNull(this.transportFactoryMap.get(TRANSPORT_TYPE), "Invalid transport configuration");
    }

    @Override
    public long getLastModified(URI uri) throws IOException {
        return this.httpCache.getCacheEntry(uri, this.logger).getLastModified(this.getTransportFactory());
    }

    @Override
    public File getFile(URI remoteFile) throws IOException {
        return this.httpCache.getCacheEntry(remoteFile, this.logger).getCacheFile(this.getTransportFactory());
    }
}

