/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.flow.ui.convert;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.dromara.warm.flow.core.FlowEngine;
import org.dromara.warm.flow.core.entity.Node;
import org.dromara.warm.flow.core.entity.Skip;
import org.dromara.warm.flow.core.enums.NodeType;
import org.dromara.warm.flow.core.enums.SkipType;
import org.dromara.warm.flow.ui.convert.NodeConvertAbstract;
import org.dromara.warm.flow.ui.convert.NodeConvertUtil;

public class SerialNodeConvert
extends NodeConvertAbstract {
    @Override
    public List<Node> convert(Map<String, Object> jsonObject, String startNodeId, String endNodeId, String nextNodeId) {
        ArrayList<Node> seaflowNodeList = new ArrayList<Node>();
        Node node = FlowEngine.newNode();
        seaflowNodeList.add(node);
        ArrayList<Skip> serialSkip = new ArrayList<Skip>();
        List childNodes = (List)jsonObject.get("childNodes");
        for (int j = 0; j < childNodes.size(); ++j) {
            List jsonArray = (List)childNodes.get(j);
            if (jsonArray.size() > 1) {
                String[] nodeIds;
                String subNextNodeId = (String)((Map)jsonArray.get(1)).get("nodeId");
                String subNextNodeType = (String)((Map)jsonArray.get(1)).get("nodeType");
                if (NodeType.isGateWay((Integer)NodeType.getKeyByValue((String)subNextNodeType)).booleanValue()) {
                    String emptyNodeCode = UUID.randomUUID().toString();
                    Node emptyNode = FlowEngine.newNode();
                    emptyNode.setNodeCode(emptyNodeCode);
                    emptyNode.setNodeType(NodeType.BETWEEN.getKey());
                    String emptyApprove = "{\"type\":\"EMPTY\",\"value\":[]}";
                    ArrayList<Skip> emptySkip = new ArrayList<Skip>();
                    Skip emSkip = FlowEngine.newSkip();
                    emSkip.setSkipType(SkipType.PASS.getKey());
                    emSkip.setNextNodeCode(subNextNodeId);
                    emptySkip.add(emSkip);
                    emptyNode.setSkipList(emptySkip);
                    seaflowNodeList.add(emptyNode);
                    Skip flowSkip = this.createSkip((Map)jsonArray.get(0), emptyNodeCode);
                    serialSkip.add(flowSkip);
                } else {
                    Skip flowSkip = this.createSkip((Map)jsonArray.get(0), subNextNodeId);
                    serialSkip.add(flowSkip);
                }
                ArrayList<Map<String, Object>> subArray = new ArrayList<Map<String, Object>>(jsonArray.subList(1, jsonArray.size()));
                List<Node> convert = NodeConvertUtil.convert(subArray, startNodeId, endNodeId);
                Node seaflowNode = convert.get(convert.size() - 1);
                List skipList = seaflowNode.getSkipList();
                for (String nodeId : nodeIds = nextNodeId.split(",")) {
                    Skip skipParentNext = FlowEngine.newSkip();
                    skipParentNext.setSkipType(SkipType.PASS.getKey());
                    skipParentNext.setNextNodeCode(nodeId);
                    skipList.add(skipParentNext);
                }
                seaflowNodeList.addAll(convert);
                continue;
            }
            String emptyNodeCode = UUID.randomUUID().toString();
            Node emptyNode = FlowEngine.newNode();
            emptyNode.setNodeCode(emptyNodeCode);
            emptyNode.setNodeType(NodeType.BETWEEN.getKey());
            String emptyApprove = "{\"type\":\"EMPTY\",\"value\":[]}";
            String[] nodeIds = nextNodeId.split(",");
            ArrayList<Skip> emptySkip = new ArrayList<Skip>();
            for (String nodeId : nodeIds) {
                Skip skipParentNext = FlowEngine.newSkip();
                skipParentNext.setSkipType(SkipType.PASS.getKey());
                skipParentNext.setNextNodeCode(nodeId);
                emptySkip.add(skipParentNext);
            }
            emptyNode.setSkipList(emptySkip);
            seaflowNodeList.add(emptyNode);
            Skip flowSkip = this.createSkip((Map)jsonArray.get(0), emptyNodeCode);
            serialSkip.add(flowSkip);
        }
        node.setSkipList(serialSkip);
        return seaflowNodeList;
    }

    private Skip createSkip(Map<String, Object> subNode, String nextNodeId) {
        Skip skip = FlowEngine.newSkip();
        Boolean defaultSerial = true;
        if (defaultSerial != null && defaultSerial.booleanValue()) {
            String expressionType = "@@default@@|true";
            skip.setSkipCondition(expressionType);
            skip.setSkipName((String)subNode.get("nodeName"));
            skip.setSkipType(SkipType.PASS.getKey());
            skip.setNextNodeCode(nextNodeId);
        } else {
            Map config = (Map)subNode.get("config");
            Map conditions = (Map)config.get("conditions");
            if (conditions != null) {
                Boolean simple = true;
                String group = (String)conditions.get("group");
                String simpleData = (String)conditions.get("simpleData");
                String expressionType = "@@" + (simple != false ? "simple_" + group : "complex") + "@@|";
                skip.setSkipCondition(expressionType + simpleData);
                skip.setSkipName((String)subNode.get("nodeName"));
                skip.setSkipType(SkipType.PASS.getKey());
                skip.setNextNodeCode(nextNodeId);
            }
        }
        return skip;
    }

    @Override
    public String getType() {
        return "serial";
    }
}

