/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.warm.plugin.modes.sb.helper;

import java.util.Map;
import org.dromara.warm.flow.core.exception.FlowException;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.expression.BeanFactoryResolver;
import org.springframework.expression.BeanResolver;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.ParserContext;
import org.springframework.expression.common.TemplateParserContext;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

@Configuration
public class SpelHelper
implements ApplicationContextAware {
    private static final ExpressionParser parser = new SpelExpressionParser();
    private static final ParserContext parserContext = new TemplateParserContext();
    private static ApplicationContext applicationContext;
    private static BeanResolver beanResolver;

    public static BeanResolver beanResolver() {
        if (beanResolver == null) {
            beanResolver = new BeanFactoryResolver((BeanFactory)SpelHelper.getBeanFactory());
        }
        return beanResolver;
    }

    public static Object parseExpression(String expression, Map<String, Object> variable) {
        StandardEvaluationContext context = new StandardEvaluationContext();
        context.setBeanResolver(SpelHelper.beanResolver());
        context.setVariables(variable);
        return parser.parseExpression(expression, parserContext).getValue((EvaluationContext)context, Object.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        if (SpelHelper.applicationContext == null) {
            SpelHelper.applicationContext = applicationContext;
        }
    }

    public static ListableBeanFactory getBeanFactory() {
        if (null == applicationContext) {
            throw new FlowException("No ConfigurableListableBeanFactory or ApplicationContext injected, maybe not in the Spring environment?");
        }
        return applicationContext;
    }

    static {
        beanResolver = null;
    }
}

