/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.javase.config;

import cn.hutool.core.bean.BeanUtil;
import cn.hutool.core.collection.CollUtil;
import cn.hutool.core.io.resource.ClassPathResource;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import org.dromara.sms4j.aliyun.config.AlibabaFactory;
import org.dromara.sms4j.api.SmsBlend;
import org.dromara.sms4j.api.dao.SmsDao;
import org.dromara.sms4j.api.dao.SmsDaoDefaultImpl;
import org.dromara.sms4j.api.proxy.SmsProcessor;
import org.dromara.sms4j.api.universal.SupplierConfig;
import org.dromara.sms4j.api.verify.PhoneVerify;
import org.dromara.sms4j.baidu.config.BaiduFactory;
import org.dromara.sms4j.budingyun.config.BudingV2Factory;
import org.dromara.sms4j.chuanglan.config.ChuangLanFactory;
import org.dromara.sms4j.cloopen.config.CloopenFactory;
import org.dromara.sms4j.comm.exception.SmsBlendException;
import org.dromara.sms4j.comm.utils.SmsUtils;
import org.dromara.sms4j.core.factory.SmsFactory;
import org.dromara.sms4j.core.proxy.EnvirmentHolder;
import org.dromara.sms4j.core.proxy.SmsProxyFactory;
import org.dromara.sms4j.core.proxy.processor.BlackListProcessor;
import org.dromara.sms4j.core.proxy.processor.BlackListRecordingProcessor;
import org.dromara.sms4j.core.proxy.processor.CoreMethodParamValidateProcessor;
import org.dromara.sms4j.core.proxy.processor.RestrictedProcessor;
import org.dromara.sms4j.ctyun.config.CtyunFactory;
import org.dromara.sms4j.danmi.config.DanMiFactory;
import org.dromara.sms4j.dingzhong.config.DingZhongFactory;
import org.dromara.sms4j.emay.config.EmayFactory;
import org.dromara.sms4j.huawei.config.HuaweiFactory;
import org.dromara.sms4j.javase.config.SESmsDaoHolder;
import org.dromara.sms4j.javase.util.YamlUtils;
import org.dromara.sms4j.jdcloud.config.JdCloudFactory;
import org.dromara.sms4j.jg.config.JgFactory;
import org.dromara.sms4j.lianlu.config.LianLuFactory;
import org.dromara.sms4j.luosimao.config.LuoSiMaoFactory;
import org.dromara.sms4j.mas.config.MasFactory;
import org.dromara.sms4j.netease.config.NeteaseFactory;
import org.dromara.sms4j.provider.config.SmsConfig;
import org.dromara.sms4j.provider.factory.BaseProviderFactory;
import org.dromara.sms4j.provider.factory.BeanFactory;
import org.dromara.sms4j.provider.factory.ProviderFactoryHolder;
import org.dromara.sms4j.qiniu.config.QiNiuFactory;
import org.dromara.sms4j.submail.config.SubMailFactory;
import org.dromara.sms4j.tencent.config.TencentFactory;
import org.dromara.sms4j.unisms.config.UniFactory;
import org.dromara.sms4j.yixintong.config.YiXintongFactory;
import org.dromara.sms4j.yunpian.config.YunPianFactory;
import org.dromara.sms4j.zhutong.config.ZhutongFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SEInitializer {
    private static final Logger log = LoggerFactory.getLogger(SEInitializer.class);
    private static final SEInitializer INSTANCE = new SEInitializer();
    private SmsDao smsDao;

    public static SEInitializer initializer() {
        return INSTANCE;
    }

    public void fromYaml() {
        ClassPathResource yamlResouce = new ClassPathResource("sms4j.yml");
        this.fromYaml(yamlResouce.readUtf8Str());
    }

    public void fromYaml(String yaml) {
        InitConfig config = YamlUtils.toBean(yaml, InitConfig.class);
        this.initConfig(config);
    }

    public void fromJson(String json) {
        InitConfig config = (InitConfig)JSONUtil.toBean((String)json, InitConfig.class);
        this.initConfig(config);
    }

    public void fromConfig(SmsConfig smsConfig, List<SupplierConfig> configList) {
        this.registerDefaultFactory();
        BeanUtil.copyProperties((Object)smsConfig, (Object)BeanFactory.getSmsConfig(), (String[])new String[0]);
        if (CollUtil.isEmpty(configList)) {
            return;
        }
        try {
            HashMap blends = new HashMap();
            for (SupplierConfig supplierConfig : configList) {
                PropertyDescriptor[] propertyDescriptors;
                HashMap<String, Object> param = new HashMap<String, Object>();
                String channel = supplierConfig.getSupplier();
                Class<?> clazz = supplierConfig.getClass();
                BeanInfo beanInfo = Introspector.getBeanInfo(clazz, Object.class);
                for (PropertyDescriptor propertyDescriptor : propertyDescriptors = beanInfo.getPropertyDescriptors()) {
                    Method readMethod = propertyDescriptor.getReadMethod();
                    Object item = readMethod.invoke((Object)supplierConfig, new Object[0]);
                    param.put(propertyDescriptor.getName(), item);
                }
                blends.put(channel, param);
            }
            EnvirmentHolder.frozenEnvirmet((SmsConfig)smsConfig, blends);
            SmsProxyFactory.addPreProcessor((SmsProcessor)new RestrictedProcessor());
            SmsProxyFactory.addPreProcessor((SmsProcessor)new BlackListProcessor());
            SmsProxyFactory.addPreProcessor((SmsProcessor)new BlackListRecordingProcessor());
            ServiceLoader<PhoneVerify> loader = ServiceLoader.load(PhoneVerify.class);
            if (loader.iterator().hasNext()) {
                loader.forEach(f -> SmsProxyFactory.addPreProcessor((SmsProcessor)new CoreMethodParamValidateProcessor(f)));
            } else {
                SmsProxyFactory.addPreProcessor((SmsProcessor)new CoreMethodParamValidateProcessor(null));
            }
        }
        catch (Exception e) {
            log.error("\u914d\u7f6e\u5bf9\u8c61\u8f6c\u6362\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u4f46\u4e0d\u5f71\u54cd\u57fa\u7840\u529f\u80fd\u7684\u4f7f\u7528\u3002\u3010\u6ce8\u610f\u3011\uff1a\u672a\u52a0\u8f7dSMS4J\u6269\u5c55\u529f\u80fd\u6a21\u5757\uff0c\u62e6\u622a\u5668\uff0c\u53c2\u6570\u6821\u9a8c\u53ef\u80fd\u5931\u6548\uff01");
        }
        for (SupplierConfig supplierConfig : configList) {
            SmsFactory.createSmsBlend((SupplierConfig)supplierConfig);
        }
    }

    public SEInitializer registerFactory(BaseProviderFactory<? extends SmsBlend, ? extends SupplierConfig> factory) {
        ProviderFactoryHolder.registerFactory(factory);
        return this;
    }

    public SEInitializer registerSmsDao(SmsDao smsDao) {
        if (smsDao == null) {
            throw new SmsBlendException("\u6ce8\u518cDAO\u5b9e\u4f8b\u5931\u8d25\uff0c\u5b9e\u4f8b\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.smsDao = smsDao;
        SESmsDaoHolder.setSmsDao(smsDao);
        return this;
    }

    private void initConfig(InitConfig config) {
        if (config == null) {
            log.error("\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25");
            throw new SmsBlendException("\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25");
        }
        InitSmsConfig smsConfig = config.getSms();
        if (smsConfig == null) {
            log.error("\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25");
            throw new SmsBlendException("\u521d\u59cb\u5316\u914d\u7f6e\u5931\u8d25");
        }
        if (this.smsDao == null) {
            this.registerSmsDao((SmsDao)SmsDaoDefaultImpl.getInstance());
        }
        this.registerDefaultFactory();
        BeanUtil.copyProperties((Object)((Object)smsConfig), (Object)BeanFactory.getSmsConfig(), (String[])new String[0]);
        Map<String, Map<String, Object>> blends = smsConfig.getBlends();
        EnvirmentHolder.frozenEnvirmet((SmsConfig)smsConfig, blends);
        SmsProxyFactory.addPreProcessor((SmsProcessor)new RestrictedProcessor());
        SmsProxyFactory.addPreProcessor((SmsProcessor)new BlackListProcessor());
        SmsProxyFactory.addPreProcessor((SmsProcessor)new BlackListRecordingProcessor());
        ServiceLoader<PhoneVerify> loader = ServiceLoader.load(PhoneVerify.class);
        if (loader.iterator().hasNext()) {
            loader.forEach(f -> SmsProxyFactory.addPreProcessor((SmsProcessor)new CoreMethodParamValidateProcessor(f)));
        } else {
            SmsProxyFactory.addPreProcessor((SmsProcessor)new CoreMethodParamValidateProcessor(null));
        }
        for (String configId : blends.keySet()) {
            Map<String, Object> configMap = blends.get(configId);
            Object supplierObj = configMap.get("supplier");
            String supplier = supplierObj == null ? "" : String.valueOf(supplierObj);
            BaseProviderFactory providerFactory = ProviderFactoryHolder.requireForSupplier((String)(supplier = StrUtil.isEmpty((CharSequence)supplier) ? configId : supplier));
            if (providerFactory == null) {
                log.warn("\u521b\u5efa\"{}\"\u7684\u77ed\u4fe1\u670d\u52a1\u5931\u8d25\uff0c\u672a\u627e\u5230\u670d\u52a1\u5546\u4e3a\"{}\"\u7684\u670d\u52a1", (Object)configId, (Object)supplier);
                continue;
            }
            configMap.put("config-id", configId);
            SmsUtils.replaceKeysSeparator(configMap, (String)"-", (String)"_");
            JSONObject configJson = new JSONObject(configMap);
            SupplierConfig supplierConfig = (SupplierConfig)JSONUtil.toBean((JSONObject)configJson, (Class)providerFactory.getConfigClass());
            SmsFactory.createSmsBlend((SupplierConfig)supplierConfig);
        }
    }

    private void registerDefaultFactory() {
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)AlibabaFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)CloopenFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)CtyunFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)EmayFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)HuaweiFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)NeteaseFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)TencentFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)UniFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)YunPianFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)ZhutongFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)LianLuFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)DingZhongFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)QiNiuFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)ChuangLanFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)JgFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)BudingV2Factory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)MasFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)BaiduFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)LuoSiMaoFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)SubMailFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)DanMiFactory.instance());
        ProviderFactoryHolder.registerFactory((BaseProviderFactory)YiXintongFactory.instance());
        if (SmsUtils.isClassExists((String)"com.jdcloud.sdk.auth.CredentialsProvider")) {
            ProviderFactoryHolder.registerFactory((BaseProviderFactory)JdCloudFactory.instance());
        }
    }

    public static class InitConfig {
        private InitSmsConfig sms;

        public InitSmsConfig getSms() {
            return this.sms;
        }

        public void setSms(InitSmsConfig sms) {
            this.sms = sms;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitConfig)) {
                return false;
            }
            InitConfig other = (InitConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            InitSmsConfig this$sms = this.getSms();
            InitSmsConfig other$sms = other.getSms();
            return !(this$sms == null ? other$sms != null : !((Object)((Object)this$sms)).equals((Object)other$sms));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InitConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            InitSmsConfig $sms = this.getSms();
            result = result * 59 + ($sms == null ? 43 : ((Object)((Object)$sms)).hashCode());
            return result;
        }

        public String toString() {
            return "SEInitializer.InitConfig(sms=" + (Object)((Object)this.getSms()) + ")";
        }
    }

    public static class InitSmsConfig
    extends SmsConfig {
        private Map<String, Map<String, Object>> blends;

        public Map<String, Map<String, Object>> getBlends() {
            return this.blends;
        }

        public void setBlends(Map<String, Map<String, Object>> blends) {
            this.blends = blends;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof InitSmsConfig)) {
                return false;
            }
            InitSmsConfig other = (InitSmsConfig)((Object)o);
            if (!other.canEqual((Object)this)) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            Map<String, Map<String, Object>> this$blends = this.getBlends();
            Map<String, Map<String, Object>> other$blends = other.getBlends();
            return !(this$blends == null ? other$blends != null : !((Object)this$blends).equals(other$blends));
        }

        protected boolean canEqual(Object other) {
            return other instanceof InitSmsConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = super.hashCode();
            Map<String, Map<String, Object>> $blends = this.getBlends();
            result = result * 59 + ($blends == null ? 43 : ((Object)$blends).hashCode());
            return result;
        }

        public String toString() {
            return "SEInitializer.InitSmsConfig(super=" + super.toString() + ", blends=" + this.getBlends() + ")";
        }
    }
}

