/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.sms4j.comm.utils;

import cn.hutool.core.thread.ThreadUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.core.util.URLUtil;
import cn.hutool.http.HttpRequest;
import cn.hutool.http.HttpResponse;
import cn.hutool.http.Method;
import cn.hutool.json.JSONObject;
import cn.hutool.json.JSONUtil;
import java.util.Map;
import org.dromara.sms4j.comm.exception.SmsBlendException;

public class SmsHttpUtils {
    private final Boolean enable;
    private final String host;
    private final Integer port;
    private static final SmsHttpUtils NON_PROXY_INSTANCE = new SmsHttpUtils();
    private static volatile SmsHttpUtils PROXY_INSTANCE;

    private SmsHttpUtils() {
        this.enable = false;
        this.host = null;
        this.port = null;
    }

    private SmsHttpUtils(String host, Integer port) {
        this.enable = true;
        this.host = host;
        this.port = port;
    }

    public static SmsHttpUtils instance() {
        return NON_PROXY_INSTANCE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SmsHttpUtils instance(String host, Integer port) {
        if (PROXY_INSTANCE == null) {
            Class<SmsHttpUtils> clazz = SmsHttpUtils.class;
            synchronized (SmsHttpUtils.class) {
                if (PROXY_INSTANCE == null) {
                    SmsHttpUtils.validateProxyParams(host, port);
                    PROXY_INSTANCE = new SmsHttpUtils(host, port);
                }
                // ** MonitorExit[var2_2] (shouldn't be in output)
            }
        } else if (!SmsHttpUtils.PROXY_INSTANCE.host.equals(host) || !SmsHttpUtils.PROXY_INSTANCE.port.equals(port)) {
            throw new IllegalStateException("Proxy parameters cannot be modified after initialization");
        }
        return PROXY_INSTANCE;
    }

    private static void validateProxyParams(String host, Integer port) {
        if (StrUtil.isBlank((CharSequence)host) || port == null || port <= 0) {
            throw new IllegalArgumentException("Invalid proxy host or port");
        }
    }

    private HttpRequest request(String url) {
        HttpRequest request = HttpRequest.of((String)url);
        if (this.enable.booleanValue()) {
            request.setHttpProxy(this.host, this.port.intValue());
        }
        return request;
    }

    private HttpRequest post(String url) {
        HttpRequest post = this.request(url);
        post.setMethod(Method.POST);
        return post;
    }

    private HttpRequest get(String url) {
        HttpRequest get = this.request(url);
        get.setMethod(Method.GET);
        return get;
    }

    public JSONObject postJson(String url, Map<String, String> headers, String body) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = ((HttpRequest)this.post(url).addHeaders(headers)).body(body).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject postJson(String url, Map<String, String> headers, Map<String, Object> body) {
        return this.postJson(url, headers, JSONUtil.toJsonStr(body));
    }

    public JSONObject postFrom(String url, Map<String, String> headers, Map<String, Object> body) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = ((HttpRequest)this.post(url).addHeaders(headers)).form(body).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject postBasicFrom(String url, Map<String, String> headers, String username, String password, Map<String, Object> body) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = ((HttpRequest)this.post(url).addHeaders(headers)).basicAuth(username, password).form(body).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject postUrl(String url, Map<String, String> headers, Map<String, Object> params) {
        JSONObject jSONObject;
        block8: {
            String urlWithParams = url + "?" + URLUtil.buildQuery(params, null);
            HttpResponse response = ((HttpRequest)this.post(urlWithParams).addHeaders(headers)).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject getBasic(String url, String username, String password) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = this.get(url).basicAuth(username, password).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public JSONObject getUrl(String url) {
        JSONObject jSONObject;
        block8: {
            HttpResponse response = this.get(url).execute();
            try {
                jSONObject = JSONUtil.parseObj((String)response.body());
                if (response == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new SmsBlendException(e.getMessage());
                }
            }
            response.close();
        }
        return jSONObject;
    }

    public void safeSleep(int retryInterval) {
        ThreadUtil.safeSleep((long)((long)retryInterval * 1000L));
    }
}

