/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.store;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import org.dromara.mica.mqtt.core.server.model.Message;
import org.dromara.mica.mqtt.core.server.store.IMqttMessageStore;
import org.dromara.mica.mqtt.core.util.TopicUtil;
import org.tio.utils.cache.TimedCache;

public class InMemoryMqttMessageStore
implements IMqttMessageStore {
    private final ConcurrentMap<String, Message> willStore = new ConcurrentHashMap<String, Message>();
    private final ConcurrentMap<String, Message> retainStore = new ConcurrentHashMap<String, Message>();
    private final TimedCache<String, Message> timedRetainStore = new TimedCache(TimeUnit.HOURS.toMillis(2L), TimeUnit.SECONDS.toMillis(1L), new ConcurrentHashMap());

    @Override
    public boolean addWillMessage(String clientId, Message message) {
        this.willStore.put(clientId, message);
        return true;
    }

    @Override
    public boolean clearWillMessage(String clientId) {
        this.willStore.remove(clientId);
        return true;
    }

    @Override
    public Message getWillMessage(String clientId) {
        return (Message)this.willStore.get(clientId);
    }

    @Override
    public boolean addRetainMessage(String topic, int timeout, Message message) {
        if (timeout <= 0) {
            this.retainStore.put(topic, message);
        } else {
            this.timedRetainStore.put((Serializable)((Object)topic), (Serializable)message, TimeUnit.SECONDS.toMillis(timeout));
        }
        return true;
    }

    @Override
    public boolean clearRetainMessage(String topic) {
        this.retainStore.remove(topic);
        this.timedRetainStore.remove((Serializable)((Object)topic));
        return true;
    }

    @Override
    public List<Message> getRetainMessage(String topicFilter) {
        ArrayList<Message> retainMessageList = new ArrayList<Message>();
        for (String topic : this.retainStore.keySet()) {
            if (!TopicUtil.match((String)topicFilter, (String)topic)) continue;
            retainMessageList.add((Message)this.retainStore.get(topic));
        }
        for (String topic : this.timedRetainStore.keySet()) {
            if (!TopicUtil.match((String)topicFilter, (String)topic)) continue;
            retainMessageList.add((Message)this.timedRetainStore.get((Serializable)((Object)topic)));
        }
        return retainMessageList;
    }

    @Override
    public void clean() throws IOException {
        this.willStore.clear();
        this.retainStore.clear();
        this.timedRetainStore.clear();
        this.timedRetainStore.close();
    }
}

