/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.session;

import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import org.dromara.mica.mqtt.core.common.MqttPendingPublish;
import org.dromara.mica.mqtt.core.common.MqttPendingQos2Publish;
import org.dromara.mica.mqtt.core.common.TopicFilter;
import org.dromara.mica.mqtt.core.server.model.Subscribe;
import org.dromara.mica.mqtt.core.server.session.IMqttSessionManager;
import org.dromara.mica.mqtt.core.server.session.TrieTopicManager;

public class InMemoryMqttSessionManager
implements IMqttSessionManager {
    private final ConcurrentMap<String, AtomicInteger> messageIdStore = new ConcurrentHashMap<String, AtomicInteger>();
    private final TrieTopicManager topicManager = new TrieTopicManager();
    private final ConcurrentMap<String, ConcurrentMap<Integer, MqttPendingPublish>> pendingPublishStore = new ConcurrentHashMap<String, ConcurrentMap<Integer, MqttPendingPublish>>();
    private final ConcurrentMap<String, ConcurrentMap<Integer, MqttPendingQos2Publish>> pendingQos2PublishStore = new ConcurrentHashMap<String, ConcurrentMap<Integer, MqttPendingQos2Publish>>();

    @Override
    public void addSubscribe(TopicFilter topicFilter, String clientId, int mqttQoS) {
        this.topicManager.addSubscribe(topicFilter, clientId, (int)((short)mqttQoS));
    }

    @Override
    public void removeSubscribe(String topicFilter, String clientId) {
        this.topicManager.removeSubscribe(topicFilter, clientId);
    }

    public void removeSubscribe(String clientId) {
        this.topicManager.removeSubscribe(clientId);
    }

    @Override
    public Byte searchSubscribe(String topicName, String clientId) {
        return this.topicManager.searchSubscribe(topicName, clientId);
    }

    @Override
    public List<Subscribe> searchSubscribe(String topicName) {
        return this.topicManager.searchSubscribe(topicName);
    }

    @Override
    public List<Subscribe> getSubscriptions(String clientId) {
        return this.topicManager.getSubscriptions(clientId);
    }

    @Override
    public void addPendingPublish(String clientId, int messageId, MqttPendingPublish pendingPublish) {
        Map data = this.pendingPublishStore.computeIfAbsent(clientId, key -> new ConcurrentHashMap(16));
        data.put(messageId, pendingPublish);
    }

    @Override
    public MqttPendingPublish getPendingPublish(String clientId, int messageId) {
        Map data = (Map)this.pendingPublishStore.get(clientId);
        if (data == null) {
            return null;
        }
        return (MqttPendingPublish)data.get(messageId);
    }

    @Override
    public void removePendingPublish(String clientId, int messageId) {
        Map data = (Map)this.pendingPublishStore.get(clientId);
        if (data != null) {
            data.remove(messageId);
        }
    }

    @Override
    public void addPendingQos2Publish(String clientId, int messageId, MqttPendingQos2Publish pendingQos2Publish) {
        Map data = this.pendingQos2PublishStore.computeIfAbsent(clientId, key -> new ConcurrentHashMap(16));
        data.put(messageId, pendingQos2Publish);
    }

    @Override
    public MqttPendingQos2Publish getPendingQos2Publish(String clientId, int messageId) {
        Map data = (Map)this.pendingQos2PublishStore.get(clientId);
        if (data == null) {
            return null;
        }
        return (MqttPendingQos2Publish)data.get(messageId);
    }

    @Override
    public void removePendingQos2Publish(String clientId, int messageId) {
        Map data = (Map)this.pendingQos2PublishStore.get(clientId);
        if (data != null) {
            data.remove(messageId);
        }
    }

    @Override
    public int getPacketId(String clientId) {
        AtomicInteger packetIdGen = this.messageIdStore.computeIfAbsent(clientId, key -> new AtomicInteger(1));
        return packetIdGen.getAndUpdate(current -> current % 65535 == 0 ? 1 : current + 1);
    }

    @Override
    public boolean hasSession(String clientId) {
        return this.pendingQos2PublishStore.containsKey(clientId) || this.pendingPublishStore.containsKey(clientId) || this.messageIdStore.containsKey(clientId) || !this.topicManager.getSubscriptions(clientId).isEmpty();
    }

    @Override
    public boolean expire(String clientId, int sessionExpirySeconds) {
        return false;
    }

    @Override
    public boolean active(String clientId) {
        return false;
    }

    @Override
    public void remove(String clientId) {
        this.removeSubscribe(clientId);
        this.pendingPublishStore.remove(clientId);
        this.pendingQos2PublishStore.remove(clientId);
        this.messageIdStore.remove(clientId);
    }

    @Override
    public void clean() {
        this.topicManager.clear();
        this.pendingPublishStore.clear();
        this.pendingQos2PublishStore.clear();
        this.messageIdStore.clear();
    }
}

