/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.model;

import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import org.dromara.mica.mqtt.codec.MqttCodecUtil;
import org.dromara.mica.mqtt.codec.MqttVersion;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.tio.core.ChannelContext;
import org.tio.core.Node;

public class ClientInfo
implements Serializable {
    private String clientId;
    private String username;
    private long keepAlive;
    private boolean connected;
    private String protoName;
    private int protoVer;
    private String protoFullName;
    private String ipAddress;
    private int port;
    private Long connectedAt;
    private long createdAt;
    private int decodeQueueSize;
    private int handlerQueueSize;
    private int sendQueueSize;

    public static ClientInfo form(MqttServerCreator serverCreator, ChannelContext context) {
        return ClientInfo.form(serverCreator, context, ClientInfo::new);
    }

    public static ClientInfo form(MqttServerCreator serverCreator, ChannelContext context, Supplier<ClientInfo> extFunc) {
        ClientInfo clientInfo = extFunc.get();
        clientInfo.setClientId(context.getBsId());
        clientInfo.setUsername(context.getUserId());
        clientInfo.setConnected(context.isAccepted());
        clientInfo.setKeepAlive(ClientInfo.getClientKeepAlive(context, serverCreator));
        Node clientNode = context.getClientNode();
        clientInfo.setIpAddress(clientNode.getIp());
        clientInfo.setPort(clientNode.getPort());
        MqttVersion mqttVersion = MqttCodecUtil.getMqttVersion((ChannelContext)context);
        clientInfo.setProtoName(mqttVersion.protocolName());
        clientInfo.setProtoVer(mqttVersion.protocolLevel());
        clientInfo.setProtoFullName(mqttVersion.fullName());
        clientInfo.setConnectedAt(context.stat.timeFirstConnected);
        clientInfo.setCreatedAt(context.stat.timeCreated);
        clientInfo.setDecodeQueueSize(context.getDecodeQueueSize());
        clientInfo.setHandlerQueueSize(context.getHandlerQueueSize());
        clientInfo.setSendQueueSize(context.getSendQueueSize());
        return clientInfo;
    }

    public static long getClientKeepAlive(ChannelContext context, MqttServerCreator serverCreator) {
        if (context.heartbeatTimeout == null) {
            return 60L;
        }
        float keepAliveBackoff = serverCreator.getKeepaliveBackoff();
        long keepAliveTs = (long)((float)context.heartbeatTimeout.longValue() / (keepAliveBackoff * 2.0f));
        return TimeUnit.MILLISECONDS.toSeconds(keepAliveTs);
    }

    public String getClientId() {
        return this.clientId;
    }

    public void setClientId(String clientId) {
        this.clientId = clientId;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public long getKeepAlive() {
        return this.keepAlive;
    }

    public void setKeepAlive(long keepAlive) {
        this.keepAlive = keepAlive;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void setConnected(boolean connected) {
        this.connected = connected;
    }

    public String getProtoName() {
        return this.protoName;
    }

    public void setProtoName(String protoName) {
        this.protoName = protoName;
    }

    public int getProtoVer() {
        return this.protoVer;
    }

    public void setProtoVer(int protoVer) {
        this.protoVer = protoVer;
    }

    public String getProtoFullName() {
        return this.protoFullName;
    }

    public void setProtoFullName(String protoFullName) {
        this.protoFullName = protoFullName;
    }

    public String getIpAddress() {
        return this.ipAddress;
    }

    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public Long getConnectedAt() {
        return this.connectedAt;
    }

    public void setConnectedAt(Long connectedAt) {
        this.connectedAt = connectedAt;
    }

    public long getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(long createdAt) {
        this.createdAt = createdAt;
    }

    public int getDecodeQueueSize() {
        return this.decodeQueueSize;
    }

    public void setDecodeQueueSize(int decodeQueueSize) {
        this.decodeQueueSize = decodeQueueSize;
    }

    public int getHandlerQueueSize() {
        return this.handlerQueueSize;
    }

    public void setHandlerQueueSize(int handlerQueueSize) {
        this.handlerQueueSize = handlerQueueSize;
    }

    public int getSendQueueSize() {
        return this.sendQueueSize;
    }

    public void setSendQueueSize(int sendQueueSize) {
        this.sendQueueSize = sendQueueSize;
    }

    public String toString() {
        return "ClientInfo{clientId='" + this.clientId + '\'' + ", username='" + this.username + '\'' + ", keepAlive=" + this.keepAlive + ", connected=" + this.connected + ", protoName='" + this.protoName + '\'' + ", protoVer=" + this.protoVer + ", ipAddress='" + this.ipAddress + '\'' + ", port=" + this.port + ", connectedAt=" + this.connectedAt + ", createdAt=" + this.createdAt + ", decodeQueueSize=" + this.decodeQueueSize + ", handlerQueueSize=" + this.handlerQueueSize + ", sendQueueSize=" + this.sendQueueSize + '}';
    }
}

