/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.listener;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.listener.IMqttProtocolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;

public class MqttProtocolListeners {
    private static final Logger logger = LoggerFactory.getLogger(MqttProtocolListeners.class);
    private final List<TioServer> servers;

    public MqttProtocolListeners(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig, List<IMqttProtocolListener> listeners) {
        this.servers = MqttProtocolListeners.getTioServers(serverCreator, mqttServerConfig, listeners);
    }

    private static List<TioServer> getTioServers(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig, List<IMqttProtocolListener> listeners) {
        ArrayList<TioServer> servers = new ArrayList<TioServer>();
        for (IMqttProtocolListener listener : listeners) {
            servers.add(listener.config(serverCreator, mqttServerConfig));
        }
        return servers;
    }

    public void start() {
        for (TioServer server : this.servers) {
            try {
                server.start();
            }
            catch (IOException e) {
                String serverConfigName = server.getServerConfig().getName();
                String message = serverConfigName + ' ' + server.getServerNode() + " start fail.";
                throw new IllegalStateException(message, e);
            }
        }
    }

    public boolean stop() {
        boolean result = true;
        for (TioServer server : this.servers) {
            logger.info("{} stop result:{}", (Object)server.getServerConfig().getName(), (Object)(result &= server.stop()));
        }
        return result;
    }
}

