/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.listener;

import java.io.InputStream;
import java.util.Objects;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.http.websocket.MqttWsMsgHandler;
import org.dromara.mica.mqtt.core.server.http.websocket.MqttWsServerListener;
import org.dromara.mica.mqtt.core.server.listener.IMqttProtocolListener;
import org.dromara.mica.mqtt.core.server.protocol.MqttProtocol;
import org.tio.core.Node;
import org.tio.core.intf.TioUuid;
import org.tio.core.ssl.ClientAuth;
import org.tio.core.ssl.SslConfig;
import org.tio.core.uuid.SnowflakeTioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.websocket.server.WsTioServerHandler;
import org.tio.websocket.server.handler.IWsMsgHandler;

public class MqttProtocolListener
implements IMqttProtocolListener {
    private final MqttProtocol protocol;
    private final Node serverNode;
    private final SslConfig sslConfig;

    public MqttProtocolListener(MqttProtocol protocol, Node serverNode) {
        this(protocol, serverNode, null);
    }

    public MqttProtocolListener(MqttProtocol protocol, Node serverNode, SslConfig sslConfig) {
        this.protocol = MqttProtocolListener.checkSSl(protocol, sslConfig);
        this.serverNode = IMqttProtocolListener.getServerNode(serverNode, protocol);
        this.sslConfig = sslConfig;
    }

    private static MqttProtocol checkSSl(MqttProtocol mqttProtocol, SslConfig sslConfig) {
        if ((MqttProtocol.MQTT_SSL == mqttProtocol || MqttProtocol.MQTT_WSS == mqttProtocol) && sslConfig == null) {
            throw new NullPointerException((Object)((Object)mqttProtocol) + " \u7f3a\u5c11\u5fc5\u8981\u53c2\u6570 SslConfig");
        }
        return Objects.requireNonNull(mqttProtocol, "MqttProtocol is null");
    }

    @Override
    public MqttProtocol getProtocol() {
        return this.protocol;
    }

    @Override
    public Node getServerNode() {
        return this.serverNode;
    }

    @Override
    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    @Override
    public TioServer config(MqttServerCreator serverCreator, TioServerConfig mainServerConfig) {
        TioServerConfig serverConfig = this.protocol == MqttProtocol.MQTT || this.protocol == MqttProtocol.MQTT_SSL ? this.getTcpServerConfig(serverCreator, mainServerConfig) : this.getWebSocketServerConfig(serverCreator, mainServerConfig);
        serverConfig.setUseQueueDecode(mainServerConfig.useQueueDecode);
        serverConfig.setUseQueueSend(mainServerConfig.useQueueSend);
        serverConfig.setTaskService(mainServerConfig.getTaskService());
        serverConfig.setHeartbeatTimeout(0L);
        int readBufferSize = mainServerConfig.getReadBufferSize();
        if (readBufferSize > 0) {
            serverConfig.setReadBufferSize(readBufferSize);
        }
        serverConfig.statOn = mainServerConfig.statOn;
        serverConfig.debug = mainServerConfig.debug;
        serverConfig.setSslConfig(this.sslConfig);
        serverConfig.share(mainServerConfig);
        return new TioServer(this.serverNode, serverConfig);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IMqttProtocolListener that = (IMqttProtocolListener)o;
        return Objects.equals(this.serverNode, that.getServerNode());
    }

    public int hashCode() {
        return Objects.hashCode(this.serverNode);
    }

    private TioServerConfig getTcpServerConfig(MqttServerCreator serverCreator, TioServerConfig mainServerConfig) {
        TioServerConfig serverConfig = new TioServerConfig(serverCreator.getName() + '/' + this.getProtocol().name(), mainServerConfig.getTioServerHandler(), mainServerConfig.getTioServerListener());
        serverConfig.enableProxyProtocol(mainServerConfig.isProxyProtocolEnabled());
        return serverConfig;
    }

    private TioServerConfig getWebSocketServerConfig(MqttServerCreator serverCreator, TioServerConfig mainServerConfig) {
        MqttWsMsgHandler handler = new MqttWsMsgHandler(serverCreator, mainServerConfig.getTioHandler());
        TioServerConfig tioServerConfig = new TioServerConfig(serverCreator.getName() + '/' + this.getProtocol().name(), (TioServerHandler)new WsTioServerHandler(new HttpConfig(), (IWsMsgHandler)handler), (TioServerListener)new MqttWsServerListener(mainServerConfig.getTioServerListener()), mainServerConfig.tioExecutor, mainServerConfig.groupExecutor);
        tioServerConfig.setTioUuid((TioUuid)new SnowflakeTioUuid());
        return tioServerConfig;
    }

    public static Builder mqttBuilder() {
        return new Builder(MqttProtocol.MQTT);
    }

    public static SslBuilder mqttSslBuilder() {
        return new SslBuilder(MqttProtocol.MQTT_SSL);
    }

    public static Builder wsBuilder() {
        return new Builder(MqttProtocol.MQTT_WS);
    }

    public static SslBuilder wssBuilder() {
        return new SslBuilder(MqttProtocol.MQTT_WSS);
    }

    public static class SslBuilder
    extends Builder {
        private SslConfig sslConfig;

        SslBuilder(MqttProtocol protocol) {
            super(protocol);
        }

        @Override
        public SslBuilder serverNode(int port) {
            return this.serverNode(null, port);
        }

        @Override
        public SslBuilder serverNode(String ip, int port) {
            return this.serverNode(new Node(ip, port));
        }

        @Override
        public SslBuilder serverNode(Node serverNode) {
            this.serverNode = serverNode;
            return this;
        }

        public SslBuilder sslConfig(SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public SslBuilder useSsl(InputStream keyStoreInputStream, String keyPasswd) {
            return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd));
        }

        public SslBuilder useSsl(InputStream keyStoreInputStream, String keyPasswd, ClientAuth clientAuth) {
            return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd, (ClientAuth)clientAuth));
        }

        public SslBuilder useSsl(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword, ClientAuth clientAuth) {
            return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd, (InputStream)trustStoreInputStream, (String)trustPassword, (ClientAuth)clientAuth));
        }

        public SslBuilder useSsl(String keyStoreFile, String keyPasswd) {
            return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd));
        }

        public SslBuilder useSsl(String keyStoreFile, String keyPasswd, ClientAuth clientAuth) {
            return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd, (ClientAuth)clientAuth));
        }

        public SslBuilder useSsl(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword, ClientAuth clientAuth) {
            return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd, (String)trustStoreFile, (String)trustPassword, (ClientAuth)clientAuth));
        }

        @Override
        public MqttProtocolListener build() {
            return new MqttProtocolListener(this.protocol, this.serverNode, this.sslConfig);
        }
    }

    public static class Builder {
        protected final MqttProtocol protocol;
        protected Node serverNode;

        Builder(MqttProtocol protocol) {
            this.protocol = protocol;
        }

        public Builder serverNode(int port) {
            return this.serverNode(null, port);
        }

        public Builder serverNode(String ip, int port) {
            return this.serverNode(new Node(ip, port));
        }

        public Builder serverNode(Node serverNode) {
            this.serverNode = serverNode;
            return this;
        }

        public MqttProtocolListener build() {
            return new MqttProtocolListener(this.protocol, this.serverNode, null);
        }
    }
}

