/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.listener;

import java.io.InputStream;
import java.util.Objects;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.http.api.MqttHttpApi;
import org.dromara.mica.mqtt.core.server.http.api.auth.BasicAuthFilter;
import org.dromara.mica.mqtt.core.server.http.handler.HttpFilter;
import org.dromara.mica.mqtt.core.server.http.handler.MqttHttpRequestHandler;
import org.dromara.mica.mqtt.core.server.http.handler.MqttHttpRoutes;
import org.dromara.mica.mqtt.core.server.http.mcp.MqttMcp;
import org.dromara.mica.mqtt.core.server.listener.IMqttProtocolListener;
import org.dromara.mica.mqtt.core.server.protocol.MqttProtocol;
import org.tio.core.Node;
import org.tio.core.intf.TioUuid;
import org.tio.core.ssl.ClientAuth;
import org.tio.core.ssl.SslConfig;
import org.tio.core.uuid.SeqTioUuid;
import org.tio.http.common.HttpConfig;
import org.tio.http.common.handler.HttpRequestHandler;
import org.tio.http.mcp.server.McpServer;
import org.tio.http.server.HttpTioServerHandler;
import org.tio.http.server.HttpTioServerListener;
import org.tio.server.TioServer;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;

public class MqttHttpApiListener
implements IMqttProtocolListener {
    private static final MqttProtocol PROTOCOL = MqttProtocol.MQTT_HTTP_API;
    private final Node serverNode;
    private final HttpFilter authFilter;
    private final McpServer mcpServer;
    private final SslConfig sslConfig;

    MqttHttpApiListener(Node serverNode, HttpFilter authFilter, McpServer mcpServer, SslConfig sslConfig) {
        this.serverNode = IMqttProtocolListener.getServerNode(serverNode, PROTOCOL);
        this.authFilter = authFilter;
        this.mcpServer = mcpServer;
        this.sslConfig = sslConfig;
    }

    @Override
    public MqttProtocol getProtocol() {
        return PROTOCOL;
    }

    @Override
    public Node getServerNode() {
        return this.serverNode;
    }

    public HttpFilter getAuthFilter() {
        return this.authFilter;
    }

    public McpServer getMcpServer() {
        return this.mcpServer;
    }

    @Override
    public SslConfig getSslConfig() {
        return this.sslConfig;
    }

    @Override
    public TioServer config(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig) {
        MqttHttpApi httpApi = new MqttHttpApi(serverCreator, mqttServerConfig);
        httpApi.register();
        if (this.authFilter != null) {
            MqttHttpRoutes.addFilter(this.authFilter);
        }
        if (this.mcpServer != null) {
            MqttMcp mqttMcp = new MqttMcp(serverCreator, mqttServerConfig, this.mcpServer);
            mqttMcp.register();
        }
        TioServerConfig tioServerConfig = new TioServerConfig(serverCreator.getName() + '/' + this.getProtocol().name(), (TioServerHandler)new HttpTioServerHandler(new HttpConfig(), (HttpRequestHandler)new MqttHttpRequestHandler()), (TioServerListener)new HttpTioServerListener(), mqttServerConfig.tioExecutor, mqttServerConfig.groupExecutor);
        tioServerConfig.setTaskService(mqttServerConfig.getTaskService());
        tioServerConfig.setHeartbeatTimeout(30000L);
        tioServerConfig.setShortConnection(true);
        tioServerConfig.setReadBufferSize(132476);
        tioServerConfig.setTioUuid((TioUuid)new SeqTioUuid());
        tioServerConfig.setSslConfig(this.sslConfig);
        tioServerConfig.debug = false;
        tioServerConfig.statOn = false;
        return new TioServer(this.serverNode, tioServerConfig);
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IMqttProtocolListener that = (IMqttProtocolListener)o;
        return Objects.equals(this.serverNode, that.getServerNode());
    }

    public int hashCode() {
        return this.serverNode.hashCode();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private Node serverNode;
        private HttpFilter authFilter;
        private McpServer mcpServer;
        private SslConfig sslConfig;

        public Builder serverNode(int port) {
            return this.serverNode(new Node(null, port));
        }

        public Builder serverNode(String ip, int port) {
            return this.serverNode(new Node(ip, port));
        }

        public Builder serverNode(Node serverNode) {
            this.serverNode = serverNode;
            return this;
        }

        public Builder authFilter(HttpFilter authFilter) {
            this.authFilter = authFilter;
            return this;
        }

        public Builder basicAuth(String username, String password) {
            return this.authFilter(new BasicAuthFilter(username, password));
        }

        public Builder mcpServer(McpServer mcpServer) {
            this.mcpServer = mcpServer;
            return this;
        }

        public Builder mcpServer() {
            return this.mcpServer(new McpServer());
        }

        public Builder mcpServer(String sseEndpoint, String messageEndpoint) {
            return this.mcpServer(new McpServer(sseEndpoint, messageEndpoint));
        }

        public Builder sslConfig(SslConfig sslConfig) {
            this.sslConfig = sslConfig;
            return this;
        }

        public Builder useSsl(InputStream keyStoreInputStream, String keyPasswd) {
            return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd));
        }

        public Builder useSsl(InputStream keyStoreInputStream, String keyPasswd, ClientAuth clientAuth) {
            return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd, (ClientAuth)clientAuth));
        }

        public Builder useSsl(InputStream keyStoreInputStream, String keyPasswd, InputStream trustStoreInputStream, String trustPassword, ClientAuth clientAuth) {
            return this.sslConfig(SslConfig.forServer((InputStream)keyStoreInputStream, (String)keyPasswd, (InputStream)trustStoreInputStream, (String)trustPassword, (ClientAuth)clientAuth));
        }

        public Builder useSsl(String keyStoreFile, String keyPasswd) {
            return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd));
        }

        public Builder useSsl(String keyStoreFile, String keyPasswd, ClientAuth clientAuth) {
            return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd, (ClientAuth)clientAuth));
        }

        public Builder useSsl(String keyStoreFile, String keyPasswd, String trustStoreFile, String trustPassword, ClientAuth clientAuth) {
            return this.sslConfig(SslConfig.forServer((String)keyStoreFile, (String)keyPasswd, (String)trustStoreFile, (String)trustPassword, (ClientAuth)clientAuth));
        }

        public MqttHttpApiListener build() {
            return new MqttHttpApiListener(this.serverNode, this.authFilter, this.mcpServer, this.sslConfig);
        }
    }
}

