/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.http.mcp;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.enums.MessageType;
import org.dromara.mica.mqtt.core.server.http.api.form.PublishForm;
import org.dromara.mica.mqtt.core.server.http.handler.MqttHttpRoutes;
import org.dromara.mica.mqtt.core.server.model.Message;
import org.tio.core.stat.vo.StatVo;
import org.tio.http.common.Method;
import org.tio.http.mcp.schema.McpCallToolResult;
import org.tio.http.mcp.schema.McpJsonSchema;
import org.tio.http.mcp.schema.McpLoggingCapabilities;
import org.tio.http.mcp.schema.McpPromptCapabilities;
import org.tio.http.mcp.schema.McpResourceCapabilities;
import org.tio.http.mcp.schema.McpServerCapabilities;
import org.tio.http.mcp.schema.McpTextContent;
import org.tio.http.mcp.schema.McpTool;
import org.tio.http.mcp.schema.McpToolCapabilities;
import org.tio.http.mcp.server.McpServer;
import org.tio.http.mcp.server.McpServerSession;
import org.tio.server.TioServerConfig;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.JsonUtil;
import org.tio.utils.mica.PayloadEncode;
import org.tio.utils.timer.SystemTimer;
import org.tio.utils.timer.TimerTask;
import org.tio.utils.timer.TimerTaskService;

public class MqttMcp {
    private final MqttServerCreator serverCreator;
    private final TioServerConfig mqttServerConfig;
    private final McpServer mcpServer;

    public MqttMcp(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig) {
        this(serverCreator, mqttServerConfig, new McpServer());
    }

    public MqttMcp(MqttServerCreator serverCreator, TioServerConfig mqttServerConfig, McpServer mcpServer) {
        this.serverCreator = serverCreator;
        this.mqttServerConfig = mqttServerConfig;
        this.mcpServer = mcpServer;
    }

    public McpTool getMqttStatsMcpTool() {
        String jsonSchema = "{\n  \"type\": \"object\",\n  \"description\": \"\u7edf\u8ba1\u4fe1\u606f\u6c47\u603bVO\uff0c\u5305\u542b\u8fde\u63a5\u3001\u6d88\u606f\u548c\u8282\u70b9\u7684\u7edf\u8ba1\u4fe1\u606f\",\n  \"properties\": {\n    \"connections\": {\n      \"type\": \"object\",\n      \"description\": \"\u8fde\u63a5\u76f8\u5173\u7edf\u8ba1\u4fe1\u606f\",\n      \"properties\": {\n        \"accepted\": {\n          \"type\": \"number\",\n          \"description\": \"\u5171\u63a5\u53d7\u8fc7\u7684\u8fde\u63a5\u6570\"\n        },\n        \"size\": {\n          \"type\": \"number\",\n          \"description\": \"\u5f53\u524d\u8fde\u63a5\u6570\"\n        },\n        \"closed\": {\n          \"type\": \"number\",\n          \"description\": \"\u5173\u95ed\u8fc7\u7684\u8fde\u63a5\u6570\"\n        }\n      }\n    },\n    \"messages\": {\n      \"type\": \"object\",\n      \"description\": \"\u6d88\u606f\u76f8\u5173\u7edf\u8ba1\u4fe1\u606f\",\n      \"properties\": {\n        \"handledPackets\": {\n          \"type\": \"number\",\n          \"description\": \"\u5904\u7406\u7684\u5305\u6570\u91cf\"\n        },\n        \"handledBytes\": {\n          \"type\": \"number\",\n          \"description\": \"\u5904\u7406\u7684\u6d88\u606f\u5b57\u8282\u6570\"\n        },\n        \"receivedPackets\": {\n          \"type\": \"number\",\n          \"description\": \"\u63a5\u6536\u7684\u5305\u6570\u91cf\"\n        },\n        \"receivedBytes\": {\n          \"type\": \"number\",\n          \"description\": \"\u63a5\u6536\u7684\u5b57\u8282\u6570\"\n        },\n        \"sendPackets\": {\n          \"type\": \"number\",\n          \"description\": \"\u53d1\u9001\u7684\u5305\u6570\u91cf\"\n        },\n        \"sendBytes\": {\n          \"type\": \"number\",\n          \"description\": \"\u53d1\u9001\u7684\u5b57\u8282\u6570\"\n        },\n        \"bytesPerTcpReceive\": {\n          \"type\": \"number\",\n          \"description\": \"\u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u5b57\u8282\u6570\"\n        },\n        \"packetsPerTcpReceive\": {\n          \"type\": \"number\",\n          \"description\": \"\u5e73\u5747\u6bcf\u6b21TCP\u5305\u63a5\u6536\u7684\u4e1a\u52a1\u5305\u6570\u91cf\"\n        }\n      }\n    },\n    \"nodes\": {\n      \"type\": \"object\",\n      \"description\": \"\u8282\u70b9\u76f8\u5173\u7edf\u8ba1\u4fe1\u606f\",\n      \"properties\": {\n        \"clientNodes\": {\n          \"type\": \"number\",\n          \"description\": \"\u5ba2\u6237\u7aef\u8282\u70b9\u6570\u91cf\"\n        },\n        \"connections\": {\n          \"type\": \"number\",\n          \"description\": \"\u8fde\u63a5\u6570\"\n        },\n        \"users\": {\n          \"type\": \"number\",\n          \"description\": \"\u7528\u6237\u6570\"\n        }\n      }\n    }\n  }\n}";
        McpTool mcpTool = new McpTool();
        mcpTool.setName("getMqttStatus");
        mcpTool.setDescription("\u83b7\u53d6 mqtt \u72b6\u6001");
        mcpTool.setReturnDirect(Boolean.valueOf(true));
        McpJsonSchema jsonSchemaIn = new McpJsonSchema();
        jsonSchemaIn.setType("object");
        jsonSchemaIn.setProperties(new HashMap());
        jsonSchemaIn.setRequired(new ArrayList());
        mcpTool.setInputSchema(jsonSchemaIn);
        McpJsonSchema jsonSchemaOut = (McpJsonSchema)JsonUtil.readValue((String)jsonSchema, McpJsonSchema.class);
        mcpTool.setOutputSchema(jsonSchemaOut);
        return mcpTool;
    }

    public McpCallToolResult getMqttStats(McpServerSession session, Map<String, Object> params) {
        StatVo statVo = this.mqttServerConfig.getStat();
        McpCallToolResult toolResult = new McpCallToolResult();
        McpTextContent content = new McpTextContent(JsonUtil.toJsonString((Object)statVo));
        toolResult.setContent(Collections.singletonList(content));
        toolResult.setStructuredContent((Object)statVo);
        return toolResult;
    }

    public McpTool getMqttPublishMcpTool() {
        String jsonSchemaIn = "{\n  \"type\": \"object\",\n  \"description\": \"MQTT \u6d88\u606f\u53d1\u5e03\",\n  \"properties\": {\n    \"topic\": {\n      \"type\": \"string\",\n      \"description\": \"\u6d88\u606f\u4e3b\u9898\"\n    },\n    \"payload\": {\n      \"type\": \"string\",\n      \"description\": \"\u6d88\u606f\u6b63\u6587\"\n    },\n    \"encoding\": {\n      \"type\": \"string\",\n      \"description\": \"\u6d88\u606f\u6b63\u6587\u7f16\u7801\u65b9\u5f0f\uff08\u4ec5\u652f\u6301 plain \u6216 base64\uff09\"\n    },\n    \"qos\": {\n      \"type\": \"integer\",\n      \"default\": 0,\n      \"description\": \"QoS \u7b49\u7ea7\uff080-2\uff09\"\n    },\n    \"retain\": {\n      \"type\": \"boolean\",\n      \"default\": false,\n      \"description\": \"\u662f\u5426\u4e3a\u4fdd\u7559\u6d88\u606f\"\n    }\n  },\n  \"required\": [\"topic\", \"payload\"]\n}";
        McpTool mcpTool = new McpTool();
        mcpTool.setName("mqttPublish");
        mcpTool.setDescription("mqtt \u6d88\u606f\u53d1\u5e03");
        mcpTool.setReturnDirect(Boolean.valueOf(true));
        mcpTool.setInputSchema((McpJsonSchema)JsonUtil.readValue((String)jsonSchemaIn, McpJsonSchema.class));
        McpJsonSchema jsonSchemaOut = new McpJsonSchema();
        jsonSchemaOut.setType("object");
        HashMap properties = new HashMap();
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("type", "boolean");
        result.put("description", "mqtt \u53d1\u5e03\u7ed3\u679c");
        properties.put("result", result);
        jsonSchemaOut.setProperties(properties);
        jsonSchemaOut.setRequired(Collections.singletonList("result"));
        mcpTool.setOutputSchema(jsonSchemaOut);
        return mcpTool;
    }

    public McpCallToolResult mqttPublish(McpServerSession session, Map<String, Object> params) {
        PublishForm publishForm = (PublishForm)JsonUtil.convertValue(params, PublishForm.class);
        boolean result = this.sendPublish(publishForm);
        HashMap<String, Boolean> json = new HashMap<String, Boolean>(2);
        json.put("result", result);
        McpCallToolResult toolResult = new McpCallToolResult();
        McpTextContent content = new McpTextContent(JsonUtil.toJsonString(json));
        toolResult.setContent(Collections.singletonList(content));
        toolResult.setStructuredContent(json);
        return toolResult;
    }

    private boolean sendPublish(PublishForm form) {
        String payload = form.getPayload();
        Message message = new Message();
        message.setMessageType(MessageType.HTTP_API);
        message.setClientId(form.getClientId());
        message.setTopic(form.getTopic());
        message.setQos(form.getQos());
        message.setRetain(form.isRetain());
        if (StrUtil.isNotBlank((CharSequence)payload)) {
            message.setPayload(PayloadEncode.decode((String)payload, (String)form.getEncoding()));
        }
        return this.serverCreator.getMessageDispatcher().send(message);
    }

    public void register() {
        MqttHttpRoutes.register(Method.GET, this.mcpServer.getSseEndpoint(), arg_0 -> ((McpServer)this.mcpServer).sseEndpoint(arg_0));
        MqttHttpRoutes.register(Method.POST, this.mcpServer.getMessageEndpoint(), arg_0 -> ((McpServer)this.mcpServer).sseMessageEndpoint(arg_0));
        McpServerCapabilities serverCapabilities = new McpServerCapabilities();
        McpLoggingCapabilities logging = new McpLoggingCapabilities();
        serverCapabilities.setLogging(logging);
        McpPromptCapabilities prompts = new McpPromptCapabilities();
        prompts.setListChanged(Boolean.valueOf(false));
        serverCapabilities.setPrompts(prompts);
        McpResourceCapabilities resources = new McpResourceCapabilities();
        resources.setListChanged(Boolean.valueOf(false));
        resources.setSubscribe(Boolean.valueOf(false));
        serverCapabilities.setResources(resources);
        McpToolCapabilities tools = new McpToolCapabilities();
        tools.setListChanged(Boolean.valueOf(true));
        serverCapabilities.setTools(tools);
        this.mcpServer.capabilities(serverCapabilities);
        this.mcpServer.tool(this.getMqttStatsMcpTool(), this::getMqttStats);
        this.mcpServer.tool(this.getMqttPublishMcpTool(), this::mqttPublish);
        TimerTaskService taskService = this.mqttServerConfig.getTaskService();
        taskService.addTask(systemTimer -> new TimerTask(TimeUnit.SECONDS.toMillis(15L), (SystemTimer)systemTimer){
            final /* synthetic */ SystemTimer val$systemTimer;
            {
                this.val$systemTimer = systemTimer;
                super(x0);
            }

            public void run() {
                this.val$systemTimer.add((TimerTask)this);
                MqttMcp.this.mcpServer.sendHeartbeat();
            }
        });
    }
}

