/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.http.handler;

import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.dromara.mica.mqtt.core.server.http.handler.HttpFilter;
import org.dromara.mica.mqtt.core.server.http.handler.RouteInfo;
import org.tio.http.common.Method;
import org.tio.http.common.RequestLine;
import org.tio.http.common.handler.HttpRequestFunction;

public final class MqttHttpRoutes {
    private static final LinkedList<HttpFilter> FILTERS = new LinkedList();
    private static final Map<RouteInfo, HttpRequestFunction> ROUTS = new HashMap<RouteInfo, HttpRequestFunction>();

    public static void addFirstFilter(HttpFilter filter) {
        FILTERS.addFirst(filter);
    }

    public static void addFilter(HttpFilter filter) {
        FILTERS.add(filter);
    }

    public static void addFilter(int index, HttpFilter filter) {
        FILTERS.add(index, filter);
    }

    public static List<HttpFilter> getFilters() {
        return Collections.unmodifiableList(FILTERS);
    }

    public static void register(Method method, String path, HttpRequestFunction function) {
        ROUTS.put(new RouteInfo(path, method), function);
    }

    public static HttpRequestFunction getHandler(RequestLine requestLine) {
        String path = requestLine.getPath();
        Method method = requestLine.getMethod();
        return ROUTS.get(new RouteInfo(path, method));
    }

    public static Map<RouteInfo, HttpRequestFunction> getRouts() {
        return Collections.unmodifiableMap(ROUTS);
    }
}

