/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.http.handler;

import java.util.List;
import org.dromara.mica.mqtt.core.server.http.api.code.ResultCode;
import org.dromara.mica.mqtt.core.server.http.api.result.Result;
import org.dromara.mica.mqtt.core.server.http.handler.HttpFilter;
import org.dromara.mica.mqtt.core.server.http.handler.MqttHttpRoutes;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.http.common.HttpRequest;
import org.tio.http.common.HttpResponse;
import org.tio.http.common.RequestLine;
import org.tio.http.common.handler.HttpRequestFunction;
import org.tio.http.common.handler.HttpRequestHandler;

public class MqttHttpRequestHandler
implements HttpRequestHandler {
    private static final Logger logger = LoggerFactory.getLogger(MqttHttpRequestHandler.class);

    public HttpResponse handler(HttpRequest request) {
        RequestLine requestLine = request.getRequestLine();
        List<HttpFilter> httpFilters = MqttHttpRoutes.getFilters();
        try {
            for (HttpFilter filter : httpFilters) {
                if (filter.filter(request)) continue;
                return filter.response(request);
            }
        }
        catch (Exception e) {
            return this.resp500(request, requestLine, e);
        }
        HttpRequestFunction handler = MqttHttpRoutes.getHandler(requestLine);
        if (handler == null) {
            return this.resp404(request, requestLine);
        }
        if (logger.isInfoEnabled()) {
            logger.info("mqtt http api {} path:{}", (Object)requestLine.method, (Object)requestLine.getPathAndQuery());
        }
        try {
            return handler.apply(request);
        }
        catch (Exception e) {
            return this.resp500(request, requestLine, e);
        }
    }

    public HttpResponse resp404(HttpRequest request, RequestLine requestLine) {
        if (logger.isErrorEnabled()) {
            logger.error("mqtt http {} path:{} 404", (Object)requestLine.getMethod().name(), (Object)requestLine.getPathAndQuery());
        }
        return Result.fail(request, ResultCode.E404);
    }

    public HttpResponse resp500(HttpRequest request, RequestLine requestLine, Throwable throwable) {
        if (logger.isErrorEnabled()) {
            logger.error("mqtt http {} path:{} error", new Object[]{requestLine.getMethod().name(), requestLine.getPathAndQuery(), throwable});
        }
        return Result.fail(request, ResultCode.E105);
    }
}

