/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.func;

import java.util.List;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.message.MqttPublishMessage;
import org.dromara.mica.mqtt.core.server.event.IMqttMessageListener;
import org.dromara.mica.mqtt.core.server.func.IMqttFunctionMessageListener;
import org.dromara.mica.mqtt.core.server.func.MqttFunctionManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;

public class MqttFunctionMessageListener
implements IMqttMessageListener {
    private static final Logger logger = LoggerFactory.getLogger(MqttFunctionMessageListener.class);
    private final MqttFunctionManager functionManager;

    public MqttFunctionMessageListener(MqttFunctionManager functionManager) {
        this.functionManager = functionManager;
    }

    @Override
    public void onMessage(ChannelContext context, String clientId, String topic, MqttQoS qoS, MqttPublishMessage message) {
        List<IMqttFunctionMessageListener> listenerList = this.functionManager.get(topic);
        for (IMqttFunctionMessageListener listener : listenerList) {
            try {
                listener.onMessage(context, clientId, topic, qoS, message);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
        }
    }
}

