/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server.func;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import org.dromara.mica.mqtt.core.server.func.IMqttFunctionMessageListener;
import org.dromara.mica.mqtt.core.util.TopicUtil;
import org.tio.utils.hutool.CollUtil;

public class MqttFunctionManager {
    private final Node root = new Node("root", null);

    public void register(String[] topicFilters, IMqttFunctionMessageListener listener) {
        for (String topicFilter : topicFilters) {
            this.register(topicFilter, listener);
        }
    }

    public void register(String topicFilter, IMqttFunctionMessageListener listener) {
        Node prev = this.root;
        String[] topicParts = TopicUtil.getTopicParts((String)topicFilter);
        int partLength = topicParts.length - 1;
        for (int i = 0; i < topicParts.length; ++i) {
            boolean isEnd;
            prev = prev.addChildIfAbsent(topicParts[i]);
            boolean bl = isEnd = i == partLength;
            if (!isEnd) continue;
            prev.listeners.add(listener);
        }
    }

    public List<IMqttFunctionMessageListener> get(String topic) {
        ArrayList<IMqttFunctionMessageListener> listenerList = new ArrayList<IMqttFunctionMessageListener>();
        String[] topicParts = TopicUtil.getTopicParts((String)topic);
        MqttFunctionManager.searchListenerRecursively(this.root, listenerList, topicParts, 0);
        return listenerList;
    }

    private static void searchListenerRecursively(Node node, List<IMqttFunctionMessageListener> listenerList, String[] topicParts, int index) {
        String topicPart;
        Node nodePart;
        if (index >= topicParts.length) {
            return;
        }
        Node nodeMore = node.findNodeByPart("#");
        if (nodeMore != null) {
            listenerList.addAll(nodeMore.listeners);
        }
        int topicPartLen = topicParts.length - 1;
        Node nodeOne = node.findNodeByPart("+");
        if (nodeOne != null) {
            if (index == topicPartLen) {
                listenerList.addAll(nodeOne.listeners);
            } else {
                MqttFunctionManager.searchListenerRecursively(nodeOne, listenerList, topicParts, index + 1);
            }
        }
        if ((nodePart = node.findNodeByPart(topicPart = topicParts[index])) != null) {
            if (index == topicPartLen) {
                listenerList.addAll(nodePart.listeners);
                Node nodePartMore = nodePart.findNodeByPart("#");
                if (nodePartMore != null) {
                    listenerList.addAll(nodePartMore.listeners);
                }
            } else {
                MqttFunctionManager.searchListenerRecursively(nodePart, listenerList, topicParts, index + 1);
            }
        }
    }

    private static class Node {
        private final String part;
        private final List<IMqttFunctionMessageListener> listeners;
        private final Map<String, Node> children;

        public Node(String part) {
            this(part, new CopyOnWriteArrayList<IMqttFunctionMessageListener>());
        }

        public Node(String part, List<IMqttFunctionMessageListener> listeners) {
            this(part, listeners, new ConcurrentHashMap<String, Node>(16));
        }

        public Node(String part, List<IMqttFunctionMessageListener> listeners, Map<String, Node> children) {
            this.part = part;
            this.listeners = listeners;
            this.children = children;
        }

        protected Node addChildIfAbsent(String nodePart) {
            assert (this.children != null);
            return (Node)CollUtil.computeIfAbsent(this.children, (Object)nodePart, Node::new);
        }

        protected Node findNodeByPart(String nodePart) {
            assert (this.children != null);
            return this.children.get(nodePart);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Node node = (Node)o;
            return Objects.equals(this.part, node.part);
        }

        public int hashCode() {
            return this.part != null ? this.part.hashCode() : 0;
        }

        public String toString() {
            return "Node{part='" + this.part + '\'' + '}';
        }
    }
}

