/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.function.Consumer;
import java.util.function.Function;
import org.dromara.mica.mqtt.core.serializer.MqttJsonSerializer;
import org.dromara.mica.mqtt.core.serializer.MqttSerializer;
import org.dromara.mica.mqtt.core.server.MqttMessageInterceptors;
import org.dromara.mica.mqtt.core.server.MqttServer;
import org.dromara.mica.mqtt.core.server.MqttServerAioHandler;
import org.dromara.mica.mqtt.core.server.MqttServerAioListener;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerAuthHandler;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerPublishPermission;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerSubscribeValidator;
import org.dromara.mica.mqtt.core.server.auth.IMqttServerUniqueIdService;
import org.dromara.mica.mqtt.core.server.broker.DefaultMqttBrokerDispatcher;
import org.dromara.mica.mqtt.core.server.dispatcher.AbstractMqttMessageDispatcher;
import org.dromara.mica.mqtt.core.server.dispatcher.IMqttMessageDispatcher;
import org.dromara.mica.mqtt.core.server.event.IMqttConnectStatusListener;
import org.dromara.mica.mqtt.core.server.event.IMqttMessageListener;
import org.dromara.mica.mqtt.core.server.event.IMqttSessionListener;
import org.dromara.mica.mqtt.core.server.interceptor.IMqttMessageInterceptor;
import org.dromara.mica.mqtt.core.server.listener.IMqttProtocolListener;
import org.dromara.mica.mqtt.core.server.listener.MqttHttpApiListener;
import org.dromara.mica.mqtt.core.server.listener.MqttProtocolListener;
import org.dromara.mica.mqtt.core.server.listener.MqttProtocolListeners;
import org.dromara.mica.mqtt.core.server.session.IMqttSessionManager;
import org.dromara.mica.mqtt.core.server.session.InMemoryMqttSessionManager;
import org.dromara.mica.mqtt.core.server.store.IMqttMessageStore;
import org.dromara.mica.mqtt.core.server.store.InMemoryMqttMessageStore;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttConnectStatusListener;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerAuthHandler;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerProcessor;
import org.dromara.mica.mqtt.core.server.support.DefaultMqttServerUniqueIdServiceImpl;
import org.tio.core.Node;
import org.tio.core.task.HeartbeatMode;
import org.tio.server.TioServerConfig;
import org.tio.server.intf.TioServerHandler;
import org.tio.server.intf.TioServerListener;
import org.tio.utils.hutool.StrUtil;
import org.tio.utils.json.JsonAdapter;
import org.tio.utils.json.JsonUtil;
import org.tio.utils.thread.ThreadUtils;
import org.tio.utils.timer.DefaultTimerTaskService;
import org.tio.utils.timer.TimerTaskService;

public class MqttServerCreator {
    private String name = "Mica-Mqtt-Server";
    private final List<IMqttProtocolListener> listeners = new ArrayList<IMqttProtocolListener>();
    private Long heartbeatTimeout;
    private float keepaliveBackoff = 0.75f;
    private int readBufferSize = 8192;
    private int maxBytesInMessage = 0xA00000;
    private IMqttServerAuthHandler authHandler;
    private IMqttServerUniqueIdService uniqueIdService;
    private IMqttServerSubscribeValidator subscribeValidator;
    private IMqttServerPublishPermission publishPermission;
    private IMqttMessageDispatcher messageDispatcher;
    private IMqttMessageStore messageStore;
    private IMqttSessionManager sessionManager;
    private IMqttSessionListener sessionListener;
    private IMqttMessageListener messageListener;
    private IMqttConnectStatusListener connectStatusListener;
    private boolean debug = false;
    private int maxClientIdLength = 64;
    private String nodeName;
    private boolean useQueueSend = true;
    private boolean useQueueDecode = false;
    private boolean statEnable = true;
    private Consumer<TioServerConfig> tioConfigCustomize;
    private final MqttMessageInterceptors messageInterceptors = new MqttMessageInterceptors();
    private TimerTaskService taskService;
    private ExecutorService mqttExecutor;
    private JsonAdapter jsonAdapter;
    private boolean proxyProtocolOn = false;
    private MqttSerializer mqttSerializer;

    public String getName() {
        return this.name;
    }

    public MqttServerCreator name(String name) {
        this.name = name;
        return this;
    }

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public MqttServerCreator heartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
        return this;
    }

    public float getKeepaliveBackoff() {
        return this.keepaliveBackoff;
    }

    public MqttServerCreator keepaliveBackoff(float keepaliveBackoff) {
        if ((double)keepaliveBackoff <= 0.5) {
            throw new IllegalArgumentException("keepalive backoff must greater than 0.5");
        }
        this.keepaliveBackoff = keepaliveBackoff;
        return this;
    }

    public int getReadBufferSize() {
        return this.readBufferSize;
    }

    public MqttServerCreator readBufferSize(int readBufferSize) {
        this.readBufferSize = readBufferSize;
        return this;
    }

    public int getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public MqttServerCreator maxBytesInMessage(int maxBytesInMessage) {
        if (maxBytesInMessage < 1) {
            throw new IllegalArgumentException("maxBytesInMessage must be greater than 0.");
        }
        this.maxBytesInMessage = maxBytesInMessage;
        return this;
    }

    public IMqttServerAuthHandler getAuthHandler() {
        return this.authHandler;
    }

    public MqttServerCreator authHandler(IMqttServerAuthHandler authHandler) {
        this.authHandler = authHandler;
        return this;
    }

    public MqttServerCreator usernamePassword(String username, String password) {
        return this.authHandler(new DefaultMqttServerAuthHandler(username, password));
    }

    public IMqttServerUniqueIdService getUniqueIdService() {
        return this.uniqueIdService;
    }

    public MqttServerCreator uniqueIdService(IMqttServerUniqueIdService uniqueIdService) {
        this.uniqueIdService = uniqueIdService;
        return this;
    }

    public IMqttServerSubscribeValidator getSubscribeValidator() {
        return this.subscribeValidator;
    }

    public MqttServerCreator subscribeValidator(IMqttServerSubscribeValidator subscribeValidator) {
        this.subscribeValidator = subscribeValidator;
        return this;
    }

    public IMqttServerPublishPermission getPublishPermission() {
        return this.publishPermission;
    }

    public MqttServerCreator publishPermission(IMqttServerPublishPermission publishPermission) {
        this.publishPermission = publishPermission;
        return this;
    }

    public IMqttMessageDispatcher getMessageDispatcher() {
        return this.messageDispatcher;
    }

    public MqttServerCreator messageDispatcher(IMqttMessageDispatcher messageDispatcher) {
        this.messageDispatcher = messageDispatcher;
        return this;
    }

    public IMqttMessageStore getMessageStore() {
        return this.messageStore;
    }

    public MqttServerCreator messageStore(IMqttMessageStore messageStore) {
        this.messageStore = messageStore;
        return this;
    }

    public IMqttSessionManager getSessionManager() {
        return this.sessionManager;
    }

    public MqttServerCreator sessionManager(IMqttSessionManager sessionManager) {
        this.sessionManager = sessionManager;
        return this;
    }

    public IMqttSessionListener getSessionListener() {
        return this.sessionListener;
    }

    public MqttServerCreator sessionListener(IMqttSessionListener sessionListener) {
        this.sessionListener = sessionListener;
        return this;
    }

    public IMqttMessageListener getMessageListener() {
        return this.messageListener;
    }

    public MqttServerCreator messageListener(IMqttMessageListener messageListener) {
        this.messageListener = messageListener;
        return this;
    }

    public IMqttConnectStatusListener getConnectStatusListener() {
        return this.connectStatusListener;
    }

    public MqttServerCreator connectStatusListener(IMqttConnectStatusListener connectStatusListener) {
        this.connectStatusListener = connectStatusListener;
        return this;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public MqttServerCreator debug() {
        this.debug = true;
        return this;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public MqttServerCreator maxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
        return this;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public MqttServerCreator nodeName(String nodeName) {
        this.nodeName = nodeName;
        return this;
    }

    public boolean isUseQueueSend() {
        return this.useQueueSend;
    }

    public MqttServerCreator useQueueSend(boolean useQueueSend) {
        this.useQueueSend = useQueueSend;
        return this;
    }

    public boolean isUseQueueDecode() {
        return this.useQueueDecode;
    }

    public MqttServerCreator useQueueDecode(boolean useQueueDecode) {
        this.useQueueDecode = useQueueDecode;
        return this;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public MqttServerCreator statEnable() {
        return this.statEnable(true);
    }

    public MqttServerCreator statEnable(boolean enable) {
        this.statEnable = enable;
        return this;
    }

    public MqttServerCreator tioConfigCustomize(Consumer<TioServerConfig> tioConfigCustomize) {
        this.tioConfigCustomize = tioConfigCustomize;
        return this;
    }

    public MqttMessageInterceptors getMessageInterceptors() {
        return this.messageInterceptors;
    }

    public MqttServerCreator addInterceptor(IMqttMessageInterceptor interceptor) {
        this.messageInterceptors.add(interceptor);
        return this;
    }

    public MqttServerCreator taskService(TimerTaskService taskService) {
        this.taskService = taskService;
        return this;
    }

    public ExecutorService getMqttExecutor() {
        return this.mqttExecutor;
    }

    public MqttServerCreator mqttExecutor(ExecutorService mqttExecutor) {
        this.mqttExecutor = mqttExecutor;
        return this;
    }

    public JsonAdapter getJsonAdapter() {
        return this.jsonAdapter;
    }

    public MqttServerCreator jsonAdapter(JsonAdapter jsonAdapter) {
        this.jsonAdapter = JsonUtil.getJsonAdapter((JsonAdapter)jsonAdapter);
        return this;
    }

    public boolean isProxyProtocolEnabled() {
        return this.proxyProtocolOn;
    }

    public MqttServerCreator proxyProtocolEnable() {
        return this.proxyProtocolEnable(true);
    }

    public MqttServerCreator proxyProtocolEnable(boolean proxyProtocolOn) {
        this.proxyProtocolOn = proxyProtocolOn;
        return this;
    }

    public MqttSerializer getMqttSerializer() {
        return this.mqttSerializer;
    }

    public MqttServerCreator mqttSerializer(MqttSerializer mqttSerializer) {
        this.mqttSerializer = mqttSerializer;
        return this;
    }

    public MqttServerCreator enableMqtt() {
        return this.enableMqtt(MqttProtocolListener.Builder::build);
    }

    public MqttServerCreator enableMqtt(int port) {
        return this.enableMqtt(builder -> builder.serverNode(port).build());
    }

    public MqttServerCreator enableMqtt(Function<MqttProtocolListener.Builder, MqttProtocolListener> function) {
        return this.addMqttProtocolListener(function.apply(MqttProtocolListener.mqttBuilder()));
    }

    public MqttServerCreator enableMqttSsl(Function<MqttProtocolListener.SslBuilder, MqttProtocolListener> function) {
        return this.addMqttProtocolListener(function.apply(MqttProtocolListener.mqttSslBuilder()));
    }

    public MqttServerCreator enableMqttWs() {
        return this.enableMqttWs(MqttProtocolListener.Builder::build);
    }

    public MqttServerCreator enableMqttWs(int port) {
        return this.enableMqttWs(builder -> builder.serverNode(port).build());
    }

    public MqttServerCreator enableMqttWs(Function<MqttProtocolListener.Builder, MqttProtocolListener> function) {
        return this.addMqttProtocolListener(function.apply(MqttProtocolListener.wsBuilder()));
    }

    public MqttServerCreator enableMqttWss(Function<MqttProtocolListener.SslBuilder, MqttProtocolListener> function) {
        return this.addMqttProtocolListener(function.apply(MqttProtocolListener.wssBuilder()));
    }

    public MqttServerCreator enableMqttHttpApi() {
        return this.enableMqttHttpApi(MqttHttpApiListener.Builder::build);
    }

    public MqttServerCreator enableMqttHttpApi(int port) {
        return this.enableMqttHttpApi(builder -> builder.serverNode(port).build());
    }

    public MqttServerCreator enableMqttHttpApi(Function<MqttHttpApiListener.Builder, MqttHttpApiListener> function) {
        return this.addMqttProtocolListener(function.apply(MqttHttpApiListener.builder()));
    }

    private MqttServerCreator addMqttProtocolListener(IMqttProtocolListener listener) {
        boolean contains = this.listeners.contains(listener);
        if (contains) {
            String protocolName = listener.getProtocol().name();
            Node serverNode = listener.getServerNode();
            throw new IllegalStateException("Mqtt protocol:" + protocolName + " serverNode:" + serverNode + " already exists");
        }
        this.listeners.add(listener);
        return this;
    }

    public MqttServer build() {
        if (StrUtil.isBlank((CharSequence)this.nodeName)) {
            this.nodeName = StrUtil.getNanoId();
        }
        if (this.uniqueIdService == null) {
            this.uniqueIdService = new DefaultMqttServerUniqueIdServiceImpl();
        }
        if (this.messageDispatcher == null) {
            this.messageDispatcher = new DefaultMqttBrokerDispatcher();
        }
        if (this.sessionManager == null) {
            this.sessionManager = new InMemoryMqttSessionManager();
        }
        if (this.messageStore == null) {
            this.messageStore = new InMemoryMqttMessageStore();
        }
        if (this.connectStatusListener == null) {
            this.connectStatusListener = new DefaultMqttConnectStatusListener();
        }
        if (this.taskService == null) {
            this.taskService = new DefaultTimerTaskService(200L, 60);
        }
        if (this.mqttExecutor == null) {
            this.mqttExecutor = ThreadUtils.getBizExecutor((int)ThreadUtils.MAX_POOL_SIZE_FOR_TIO);
        }
        if (this.mqttSerializer == null) {
            this.mqttSerializer = new MqttJsonSerializer();
        }
        if (this.listeners.isEmpty()) {
            this.enableMqtt();
        }
        DefaultMqttServerProcessor serverProcessor = new DefaultMqttServerProcessor(this, this.taskService, this.mqttExecutor);
        MqttServerAioHandler handler = new MqttServerAioHandler(this, serverProcessor);
        MqttServerAioListener listener = new MqttServerAioListener(this);
        TioServerConfig tioConfig = new TioServerConfig(this.name, (TioServerHandler)handler, (TioServerListener)listener);
        tioConfig.setUseQueueDecode(this.useQueueDecode);
        tioConfig.setUseQueueSend(this.useQueueSend);
        tioConfig.setTaskService(this.taskService);
        tioConfig.statOn = this.statEnable;
        if (this.readBufferSize > 0) {
            tioConfig.setReadBufferSize(this.readBufferSize);
        }
        tioConfig.enableProxyProtocol(this.proxyProtocolOn);
        if (this.heartbeatTimeout != null && this.heartbeatTimeout > 0L) {
            tioConfig.setHeartbeatTimeout(this.heartbeatTimeout.longValue());
        }
        tioConfig.setHeartbeatBackoff(this.keepaliveBackoff);
        tioConfig.setHeartbeatMode(HeartbeatMode.LAST_RESP);
        if (this.debug) {
            tioConfig.debug = true;
        }
        if (this.tioConfigCustomize != null) {
            this.tioConfigCustomize.accept(tioConfig);
        }
        this.jsonAdapter(JsonUtil.getJsonAdapter((JsonAdapter)this.getJsonAdapter()));
        MqttProtocolListeners listeners = new MqttProtocolListeners(this, tioConfig, this.listeners);
        MqttServer mqttServer = new MqttServer(this, tioConfig, listeners);
        if (this.messageDispatcher instanceof AbstractMqttMessageDispatcher) {
            ((AbstractMqttMessageDispatcher)this.messageDispatcher).config(mqttServer);
        }
        return mqttServer;
    }

    public MqttServer start() {
        MqttServer mqttServer = this.build();
        mqttServer.start();
        return mqttServer;
    }
}

