/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server;

import java.nio.ByteBuffer;
import org.dromara.mica.mqtt.codec.MqttDecoder;
import org.dromara.mica.mqtt.codec.MqttEncoder;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.codes.MqttConnectReasonCode;
import org.dromara.mica.mqtt.codec.exception.DecoderException;
import org.dromara.mica.mqtt.codec.exception.MqttIdentifierRejectedException;
import org.dromara.mica.mqtt.codec.exception.MqttUnacceptableProtocolVersionException;
import org.dromara.mica.mqtt.codec.message.MqttConnAckMessage;
import org.dromara.mica.mqtt.codec.message.MqttConnectMessage;
import org.dromara.mica.mqtt.codec.message.MqttMessage;
import org.dromara.mica.mqtt.codec.message.MqttPublishMessage;
import org.dromara.mica.mqtt.codec.message.MqttSubscribeMessage;
import org.dromara.mica.mqtt.codec.message.MqttUnSubscribeMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttMessageIdVariableHeader;
import org.dromara.mica.mqtt.core.server.MqttServerCreator;
import org.dromara.mica.mqtt.core.server.MqttServerProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.tio.core.ChannelContext;
import org.tio.core.Tio;
import org.tio.core.TioConfig;
import org.tio.core.exception.TioDecodeException;
import org.tio.core.intf.Packet;
import org.tio.server.intf.TioServerHandler;

public class MqttServerAioHandler
implements TioServerHandler {
    private static final Logger log = LoggerFactory.getLogger(MqttServerAioHandler.class);
    private final MqttDecoder mqttDecoder;
    private final MqttEncoder mqttEncoder;
    private final MqttServerProcessor processor;

    public MqttServerAioHandler(MqttServerCreator serverCreator, MqttServerProcessor processor) {
        this.mqttDecoder = new MqttDecoder(serverCreator.getMaxBytesInMessage(), serverCreator.getMaxClientIdLength());
        this.mqttEncoder = MqttEncoder.INSTANCE;
        this.processor = processor;
    }

    public Packet decode(ByteBuffer buffer, int limit, int position, int readableLength, ChannelContext context) throws TioDecodeException {
        try {
            return this.mqttDecoder.doDecode(context, buffer, readableLength);
        }
        catch (DecoderException e) {
            this.processFailure(context, e);
            throw new TioDecodeException((Throwable)e);
        }
    }

    public ByteBuffer encode(Packet packet, TioConfig tioConfig, ChannelContext context) {
        return this.mqttEncoder.doEncode(context, (MqttMessage)packet);
    }

    public void handler(Packet packet, ChannelContext context) {
        MqttMessage mqttMessage = (MqttMessage)packet;
        log.debug("MqttMessage:{}", (Object)mqttMessage);
        MqttFixedHeader fixedHeader = mqttMessage.fixedHeader();
        MqttMessageType messageType = fixedHeader.messageType();
        if (MqttMessageType.CONNECT == messageType) {
            this.processor.processConnect(context, (MqttConnectMessage)mqttMessage);
            return;
        }
        if (!context.isAccepted()) {
            Tio.remove((ChannelContext)context, (String)"Mqtt connected but is not accepted.");
            return;
        }
        switch (messageType) {
            case PUBLISH: {
                this.processor.processPublish(context, (MqttPublishMessage)mqttMessage);
                break;
            }
            case PUBACK: {
                this.processor.processPubAck(context, (MqttMessageIdVariableHeader)mqttMessage.variableHeader());
                break;
            }
            case PUBREC: {
                this.processor.processPubRec(context, (MqttMessageIdVariableHeader)mqttMessage.variableHeader());
                break;
            }
            case PUBREL: {
                this.processor.processPubRel(context, (MqttMessageIdVariableHeader)mqttMessage.variableHeader());
                break;
            }
            case PUBCOMP: {
                this.processor.processPubComp(context, (MqttMessageIdVariableHeader)mqttMessage.variableHeader());
                break;
            }
            case SUBSCRIBE: {
                this.processor.processSubscribe(context, (MqttSubscribeMessage)mqttMessage);
                break;
            }
            case UNSUBSCRIBE: {
                this.processor.processUnSubscribe(context, (MqttUnSubscribeMessage)mqttMessage);
                break;
            }
            case PINGREQ: {
                this.processor.processPingReq(context);
                break;
            }
            case DISCONNECT: {
                this.processor.processDisConnect(context);
                break;
            }
        }
    }

    private void processFailure(ChannelContext context, DecoderException cause) {
        if (cause instanceof MqttUnacceptableProtocolVersionException) {
            MqttConnAckMessage message = MqttConnAckMessage.builder().returnCode(MqttConnectReasonCode.CONNECTION_REFUSED_UNACCEPTABLE_PROTOCOL_VERSION).sessionPresent(false).build();
            Tio.bSend((ChannelContext)context, (Packet)message);
        } else if (cause instanceof MqttIdentifierRejectedException) {
            MqttConnAckMessage message = MqttConnAckMessage.builder().returnCode(MqttConnectReasonCode.CONNECTION_REFUSED_IDENTIFIER_REJECTED).sessionPresent(false).build();
            Tio.bSend((ChannelContext)context, (Packet)message);
        }
    }
}

