/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.server;

import java.util.ArrayList;
import java.util.List;
import org.dromara.mica.mqtt.codec.message.MqttMessage;
import org.dromara.mica.mqtt.core.server.interceptor.IMqttMessageInterceptor;
import org.tio.core.ChannelContext;

public class MqttMessageInterceptors {
    private final List<IMqttMessageInterceptor> interceptors = new ArrayList<IMqttMessageInterceptor>();

    void add(IMqttMessageInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    public void onAfterConnected(ChannelContext context, boolean isConnected, boolean isReconnect) throws Exception {
        for (IMqttMessageInterceptor interceptor : this.interceptors) {
            interceptor.onAfterConnected(context, isConnected, isReconnect);
        }
    }

    public void onAfterReceivedBytes(ChannelContext context, int receivedBytes) throws Exception {
        for (IMqttMessageInterceptor interceptor : this.interceptors) {
            interceptor.onAfterReceivedBytes(context, receivedBytes);
        }
    }

    public void onAfterDecoded(ChannelContext context, MqttMessage message, int packetSize) throws Exception {
        for (IMqttMessageInterceptor interceptor : this.interceptors) {
            interceptor.onAfterDecoded(context, message, packetSize);
        }
    }

    public void onAfterHandled(ChannelContext context, MqttMessage message, long cost) throws Exception {
        for (IMqttMessageInterceptor interceptor : this.interceptors) {
            interceptor.onAfterHandled(context, message, cost);
        }
    }

    public void onAfterSent(ChannelContext context, MqttMessage message, boolean isSentSuccess) throws Exception {
        for (IMqttMessageInterceptor interceptor : this.interceptors) {
            interceptor.onAfterSent(context, message, isSentSuccess);
        }
    }
}

