/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.spring.server.config;

import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.util.unit.DataSize;
import org.tio.core.Node;
import org.tio.core.ssl.ClientAuth;

@ConfigurationProperties(value="mqtt.server")
public class MqttServerProperties {
    public static final String PREFIX = "mqtt.server";
    private boolean enabled = true;
    private String name = "Mica-Mqtt-Server";
    private MqttAuth auth = new MqttAuth();
    private Long heartbeatTimeout;
    private float keepaliveBackoff = 0.75f;
    private DataSize readBufferSize = DataSize.ofBytes((long)8192L);
    private DataSize maxBytesInMessage = DataSize.ofBytes((long)0xA00000L);
    private boolean debug = false;
    private int maxClientIdLength = 64;
    private String nodeName;
    private boolean statEnable = true;
    private boolean proxyProtocolOn = false;
    private Listener mqttListener = new Listener();
    private SslListener mqttSslListener = new SslListener();
    private Listener wsListener = new Listener();
    private SslListener wssListener = new SslListener();
    private HttpListener httpListener = new HttpListener();

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getName() {
        return this.name;
    }

    public MqttAuth getAuth() {
        return this.auth;
    }

    public Long getHeartbeatTimeout() {
        return this.heartbeatTimeout;
    }

    public float getKeepaliveBackoff() {
        return this.keepaliveBackoff;
    }

    public DataSize getReadBufferSize() {
        return this.readBufferSize;
    }

    public DataSize getMaxBytesInMessage() {
        return this.maxBytesInMessage;
    }

    public boolean isDebug() {
        return this.debug;
    }

    public int getMaxClientIdLength() {
        return this.maxClientIdLength;
    }

    public String getNodeName() {
        return this.nodeName;
    }

    public boolean isStatEnable() {
        return this.statEnable;
    }

    public boolean isProxyProtocolOn() {
        return this.proxyProtocolOn;
    }

    public Listener getMqttListener() {
        return this.mqttListener;
    }

    public SslListener getMqttSslListener() {
        return this.mqttSslListener;
    }

    public Listener getWsListener() {
        return this.wsListener;
    }

    public SslListener getWssListener() {
        return this.wssListener;
    }

    public HttpListener getHttpListener() {
        return this.httpListener;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setAuth(MqttAuth auth) {
        this.auth = auth;
    }

    public void setHeartbeatTimeout(Long heartbeatTimeout) {
        this.heartbeatTimeout = heartbeatTimeout;
    }

    public void setKeepaliveBackoff(float keepaliveBackoff) {
        this.keepaliveBackoff = keepaliveBackoff;
    }

    public void setReadBufferSize(DataSize readBufferSize) {
        this.readBufferSize = readBufferSize;
    }

    public void setMaxBytesInMessage(DataSize maxBytesInMessage) {
        this.maxBytesInMessage = maxBytesInMessage;
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    public void setMaxClientIdLength(int maxClientIdLength) {
        this.maxClientIdLength = maxClientIdLength;
    }

    public void setNodeName(String nodeName) {
        this.nodeName = nodeName;
    }

    public void setStatEnable(boolean statEnable) {
        this.statEnable = statEnable;
    }

    public void setProxyProtocolOn(boolean proxyProtocolOn) {
        this.proxyProtocolOn = proxyProtocolOn;
    }

    public void setMqttListener(Listener mqttListener) {
        this.mqttListener = mqttListener;
    }

    public void setMqttSslListener(SslListener mqttSslListener) {
        this.mqttSslListener = mqttSslListener;
    }

    public void setWsListener(Listener wsListener) {
        this.wsListener = wsListener;
    }

    public void setWssListener(SslListener wssListener) {
        this.wssListener = wssListener;
    }

    public void setHttpListener(HttpListener httpListener) {
        this.httpListener = httpListener;
    }

    public static class McpServer {
        private boolean enable = false;
        private String sseEndpoint;
        private String messageEndpoint;

        public boolean isEnable() {
            return this.enable;
        }

        public String getSseEndpoint() {
            return this.sseEndpoint;
        }

        public String getMessageEndpoint() {
            return this.messageEndpoint;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setSseEndpoint(String sseEndpoint) {
            this.sseEndpoint = sseEndpoint;
        }

        public void setMessageEndpoint(String messageEndpoint) {
            this.messageEndpoint = messageEndpoint;
        }
    }

    public static class HttpBasicAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }

    public static class HttpSsl
    extends Ssl {
        private boolean enable = false;

        public boolean isEnable() {
            return this.enable;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }
    }

    public static class HttpListener
    extends Listener {
        private HttpBasicAuth basicAuth = new HttpBasicAuth();
        private McpServer mcpServer = new McpServer();
        private HttpSsl ssl = new HttpSsl();

        public HttpBasicAuth getBasicAuth() {
            return this.basicAuth;
        }

        public McpServer getMcpServer() {
            return this.mcpServer;
        }

        public HttpSsl getSsl() {
            return this.ssl;
        }

        public void setBasicAuth(HttpBasicAuth basicAuth) {
            this.basicAuth = basicAuth;
        }

        public void setMcpServer(McpServer mcpServer) {
            this.mcpServer = mcpServer;
        }

        public void setSsl(HttpSsl ssl) {
            this.ssl = ssl;
        }
    }

    public static class Ssl {
        private String keystorePath;
        private String keystorePass;
        private String truststorePath;
        private String truststorePass;
        private ClientAuth clientAuth = ClientAuth.NONE;

        public String getKeystorePath() {
            return this.keystorePath;
        }

        public String getKeystorePass() {
            return this.keystorePass;
        }

        public String getTruststorePath() {
            return this.truststorePath;
        }

        public String getTruststorePass() {
            return this.truststorePass;
        }

        public ClientAuth getClientAuth() {
            return this.clientAuth;
        }

        public void setKeystorePath(String keystorePath) {
            this.keystorePath = keystorePath;
        }

        public void setKeystorePass(String keystorePass) {
            this.keystorePass = keystorePass;
        }

        public void setTruststorePath(String truststorePath) {
            this.truststorePath = truststorePath;
        }

        public void setTruststorePass(String truststorePass) {
            this.truststorePass = truststorePass;
        }

        public void setClientAuth(ClientAuth clientAuth) {
            this.clientAuth = clientAuth;
        }
    }

    public static class SslListener
    extends Listener {
        private Ssl ssl = new Ssl();

        public Ssl getSsl() {
            return this.ssl;
        }

        public void setSsl(Ssl ssl) {
            this.ssl = ssl;
        }
    }

    public static class Listener {
        private boolean enable = false;
        private String ip;
        private Integer port;

        public Node getServerNode() {
            if (this.ip == null && this.port == null) {
                return null;
            }
            return new Node(this.ip, this.port.intValue());
        }

        public boolean isEnable() {
            return this.enable;
        }

        public String getIp() {
            return this.ip;
        }

        public Integer getPort() {
            return this.port;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setIp(String ip) {
            this.ip = ip;
        }

        public void setPort(Integer port) {
            this.port = port;
        }
    }

    public static class MqttAuth {
        private boolean enable = false;
        private String username;
        private String password;

        public boolean isEnable() {
            return this.enable;
        }

        public String getUsername() {
            return this.username;
        }

        public String getPassword() {
            return this.password;
        }

        public void setEnable(boolean enable) {
            this.enable = enable;
        }

        public void setUsername(String username) {
            this.username = username;
        }

        public void setPassword(String password) {
            this.password = password;
        }
    }
}

