/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.spring.server;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.Arrays;
import org.dromara.mica.mqtt.core.annotation.MqttServerFunction;
import org.dromara.mica.mqtt.core.deserialize.MqttDeserializer;
import org.dromara.mica.mqtt.core.server.func.IMqttFunctionMessageListener;
import org.dromara.mica.mqtt.core.server.func.MqttFunctionManager;
import org.dromara.mica.mqtt.core.util.TopicUtil;
import org.dromara.mica.mqtt.spring.server.MqttServerFunctionListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.context.ApplicationContext;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.core.env.Environment;
import org.springframework.lang.NonNull;
import org.springframework.util.ClassUtils;
import org.springframework.util.ReflectionUtils;

public class MqttServerFunctionDetector
implements BeanPostProcessor {
    private static final Logger log = LoggerFactory.getLogger(MqttServerFunctionDetector.class);
    private final ApplicationContext applicationContext;

    public Object postProcessAfterInitialization(@NonNull Object bean, String beanName) throws BeansException {
        Class userClass = ClassUtils.getUserClass((Object)bean);
        if (bean instanceof IMqttFunctionMessageListener) {
            MqttServerFunction subscribe = (MqttServerFunction)AnnotationUtils.findAnnotation((Class)userClass, MqttServerFunction.class);
            if (subscribe != null) {
                String[] topicFilters = MqttServerFunctionDetector.getTopicFilters(this.applicationContext, subscribe.value());
                MqttFunctionManager functionManager = this.getFunctionManager();
                functionManager.register(topicFilters, (IMqttFunctionMessageListener)bean);
            }
        } else {
            ReflectionUtils.doWithMethods((Class)userClass, method -> {
                MqttServerFunction subscribe = (MqttServerFunction)AnnotationUtils.findAnnotation((Method)method, MqttServerFunction.class);
                if (subscribe != null) {
                    int modifiers = method.getModifiers();
                    if (Modifier.isStatic(modifiers)) {
                        throw new IllegalArgumentException("@MqttServerFunction on method " + method + " must not static.");
                    }
                    if (!Modifier.isPublic(modifiers)) {
                        throw new IllegalArgumentException("@MqttServerFunction on method " + method + " must public.");
                    }
                    int paramCount = method.getParameterCount();
                    if (paramCount < 2 || paramCount > 6) {
                        throw new IllegalArgumentException("@MqttServerFunction on method " + method + " parameter count must 2 ~ 6.");
                    }
                    String[] topicTemplates = subscribe.value();
                    String[] topicFilters = MqttServerFunctionDetector.getTopicFilters(this.applicationContext, topicTemplates);
                    Class deserialized = subscribe.deserialize();
                    MqttDeserializer deserializer = this.getMqttDeserializer(deserialized);
                    MqttServerFunctionListener functionListener = new MqttServerFunctionListener(bean, method, topicTemplates, topicFilters, deserializer);
                    MqttFunctionManager functionManager = this.getFunctionManager();
                    functionManager.register(topicFilters, (IMqttFunctionMessageListener)functionListener);
                }
            }, (ReflectionUtils.MethodFilter)ReflectionUtils.USER_DECLARED_METHODS);
        }
        return bean;
    }

    protected MqttFunctionManager getFunctionManager() {
        return (MqttFunctionManager)this.applicationContext.getBean(MqttFunctionManager.class);
    }

    protected MqttDeserializer getMqttDeserializer(Class<MqttDeserializer> deserializerType) {
        return (MqttDeserializer)this.applicationContext.getBeanProvider(deserializerType).getIfAvailable(() -> (MqttDeserializer)BeanUtils.instantiateClass((Class)deserializerType));
    }

    private static String[] getTopicFilters(ApplicationContext applicationContext, String[] values) {
        return (String[])Arrays.stream(values).map(arg_0 -> ((Environment)applicationContext.getEnvironment()).resolvePlaceholders(arg_0)).map(TopicUtil::getTopicFilter).toArray(String[]::new);
    }

    public MqttServerFunctionDetector(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
    }
}

