/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.util;

import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.nio.ByteBuffer;
import java.util.Map;
import org.dromara.mica.mqtt.codec.message.MqttPublishMessage;
import org.dromara.mica.mqtt.core.deserialize.MqttDeserializer;
import org.dromara.mica.mqtt.core.function.ObjectParamValueFunction;
import org.dromara.mica.mqtt.core.function.ParamValueFunction;
import org.dromara.mica.mqtt.core.function.ParamValueFunctions;
import org.dromara.mica.mqtt.core.function.TopicVarsParamValueFunction;
import org.tio.core.ChannelContext;

public class MethodParamUtil {
    public static ParamValueFunction[] getParamValueFunctions(Method method, String[] topicTemplates, String[] topicFilters, MqttDeserializer deserializer) {
        int parameterCount = method.getParameterCount();
        ParamValueFunction[] functions = new ParamValueFunction[parameterCount];
        Type[] parameterTypes = method.getGenericParameterTypes();
        for (int i = 0; i < parameterCount; ++i) {
            Type parameterType = parameterTypes[i];
            functions[i] = parameterType == ChannelContext.class ? ParamValueFunctions.Context : (parameterType == String.class ? ParamValueFunctions.Topic : (parameterType instanceof ParameterizedType && MethodParamUtil.isStringStringMap(parameterType) ? new TopicVarsParamValueFunction(topicTemplates, topicFilters) : (parameterType == MqttPublishMessage.class ? ParamValueFunctions.Message : (parameterType == byte[].class ? ParamValueFunctions.Payload : (parameterType == ByteBuffer.class ? ParamValueFunctions.ByteBuff : new ObjectParamValueFunction(deserializer, parameterType))))));
        }
        return functions;
    }

    public static boolean isStringStringMap(Type parameterType) {
        ParameterizedType parameterizedType = (ParameterizedType)parameterType;
        Type rawType = parameterizedType.getRawType();
        if (rawType != Map.class) {
            return false;
        }
        Type[] typeArguments = parameterizedType.getActualTypeArguments();
        return typeArguments[0].equals(String.class) && typeArguments[1].equals(String.class);
    }
}

