/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.function;

import java.util.Collections;
import org.dromara.mica.mqtt.codec.message.MqttPublishMessage;
import org.dromara.mica.mqtt.core.common.TopicTemplate;
import org.dromara.mica.mqtt.core.function.ParamValueFunction;
import org.tio.core.ChannelContext;

public class TopicVarsParamValueFunction
implements ParamValueFunction {
    private final TopicTemplate[] topicTemplates;

    public TopicVarsParamValueFunction(String[] topicTemplates, String[] topicFilters) {
        this.topicTemplates = TopicVarsParamValueFunction.getTopicTemplates(topicTemplates, topicFilters);
    }

    private static TopicTemplate[] getTopicTemplates(String[] topicTemplates, String[] topicFilters) {
        TopicTemplate[] templates = new TopicTemplate[topicTemplates.length];
        for (int i = 0; i < templates.length; ++i) {
            templates[i] = new TopicTemplate(topicTemplates[i], topicFilters[i]);
        }
        return templates;
    }

    @Override
    public Object getValue(ChannelContext context, String topic, MqttPublishMessage message, byte[] payload) {
        int length = this.topicTemplates.length;
        if (length == 1) {
            return this.topicTemplates[0].getVariables(topic);
        }
        for (TopicTemplate topicTemplate : this.topicTemplates) {
            if (!topicTemplate.match(topic)) continue;
            return topicTemplate.getVariables(topic);
        }
        return Collections.emptyMap();
    }
}

