/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.common;

import java.util.Map;
import org.dromara.mica.mqtt.core.util.TopicUtil;

public enum TopicFilterType {
    NONE{

        @Override
        public boolean match(String topicFilter, String topicName) {
            return TopicUtil.match(topicFilter, topicName);
        }

        @Override
        public Map<String, String> getTopicVars(String topicTemplate, String topicName) {
            return TopicUtil.getTopicVars(topicTemplate, topicName);
        }
    }
    ,
    QUEUE{

        @Override
        public boolean match(String topicFilter, String topicName) {
            int prefixLen = TopicFilterType.SHARE_QUEUE_PREFIX.length();
            return TopicUtil.match(topicFilter.substring(prefixLen), topicName);
        }

        @Override
        public Map<String, String> getTopicVars(String topicTemplate, String topicName) {
            int prefixLen = TopicFilterType.SHARE_QUEUE_PREFIX.length();
            return TopicUtil.getTopicVars(topicTemplate.substring(prefixLen), topicName);
        }
    }
    ,
    SHARE{

        @Override
        public boolean match(String topicFilter, String topicName) {
            int prefixLen = TopicFilterType.findShareTopicIndex(topicFilter);
            return TopicUtil.match(topicFilter.substring(prefixLen), topicName);
        }

        @Override
        public Map<String, String> getTopicVars(String topicTemplate, String topicName) {
            int prefixLen = TopicFilterType.findShareTopicIndex(topicTemplate);
            return TopicUtil.getTopicVars(topicTemplate.substring(prefixLen), topicName);
        }
    };

    public static final String SHARE_QUEUE_PREFIX = "$queue/";
    public static final String SHARE_GROUP_PREFIX = "$share/";

    public abstract boolean match(String var1, String var2);

    public abstract Map<String, String> getTopicVars(String var1, String var2);

    public static TopicFilterType getType(String topicFilter) {
        if (topicFilter.startsWith(SHARE_QUEUE_PREFIX)) {
            return QUEUE;
        }
        if (topicFilter.startsWith(SHARE_GROUP_PREFIX)) {
            return SHARE;
        }
        return NONE;
    }

    public static String getShareGroupName(String topicFilter) {
        int prefixLength = SHARE_GROUP_PREFIX.length();
        int topicFilterLength = topicFilter.length();
        for (int i = prefixLength; i < topicFilterLength; ++i) {
            char ch = topicFilter.charAt(i);
            if ('/' != ch) continue;
            return topicFilter.substring(prefixLength, i);
        }
        throw new IllegalArgumentException("\u5171\u4eab\u8ba2\u9605 topicFilter: " + topicFilter + " \u4e0d\u7b26\u5408\u89c4\u8303 $share/<group-name>/xxx");
    }

    private static int findShareTopicIndex(String topicFilter) {
        int prefixLength = SHARE_GROUP_PREFIX.length();
        int topicFilterLength = topicFilter.length();
        for (int i = prefixLength; i < topicFilterLength; ++i) {
            char ch = topicFilter.charAt(i);
            if ('/' != ch) continue;
            return i + 1;
        }
        throw new IllegalArgumentException("\u5171\u4eab\u8ba2\u9605 topicFilter: " + topicFilter + " \u4e0d\u7b26\u5408\u89c4\u8303 $share/<group-name>/xxx");
    }
}

