/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.core.common;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.dromara.mica.mqtt.codec.message.MqttMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.core.util.timer.AckTimerTask;
import org.tio.utils.timer.Timer;
import org.tio.utils.timer.TimerTaskService;

public final class RetryProcessor<T extends MqttMessage> {
    private AckTimerTask ackTimerTask;
    private BiConsumer<MqttFixedHeader, T> handler;
    private T originalMessage;

    public void start(TimerTaskService taskService) {
        Objects.requireNonNull(this.handler, "RetryProcessor handler is null.");
        this.startTimer(Objects.requireNonNull(taskService, "RetryProcessor taskService is null."));
    }

    private void startTimer(TimerTaskService taskService) {
        this.ackTimerTask = (AckTimerTask)taskService.addTask(systemTimer -> new AckTimerTask((Timer)systemTimer, () -> {
            MqttFixedHeader fixedHeader = new MqttFixedHeader(this.originalMessage.fixedHeader().messageType(), true, this.originalMessage.fixedHeader().qosLevel(), this.originalMessage.fixedHeader().isRetain(), this.originalMessage.fixedHeader().remainingLength());
            this.handler.accept(fixedHeader, (MqttFixedHeader)this.originalMessage);
        }, 5, 10));
    }

    public void stop() {
        if (this.ackTimerTask != null) {
            this.ackTimerTask.cancel();
        }
    }

    public void setHandle(BiConsumer<MqttFixedHeader, T> runnable) {
        this.handler = runnable;
    }

    public void setOriginalMessage(T originalMessage) {
        this.originalMessage = originalMessage;
    }
}

