/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.header;

import java.util.Objects;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;

public final class MqttFixedHeader {
    private final MqttMessageType messageType;
    private final boolean isDup;
    private final boolean isRetain;
    private final int headLength;
    private final int remainingLength;
    private MqttQoS qosLevel;

    public MqttFixedHeader(MqttMessageType messageType, boolean isDup, MqttQoS qosLevel, boolean isRetain, int remainingLength) {
        this(messageType, isDup, qosLevel, isRetain, 0, remainingLength);
    }

    public MqttFixedHeader(MqttMessageType messageType, boolean isDup, MqttQoS qosLevel, boolean isRetain, int headLength, int remainingLength) {
        this.messageType = Objects.requireNonNull(messageType, "messageType is null.");
        this.isDup = isDup;
        this.qosLevel = Objects.requireNonNull(qosLevel, "qosLevel is null.");
        this.isRetain = isRetain;
        this.headLength = headLength;
        this.remainingLength = remainingLength;
    }

    public MqttMessageType messageType() {
        return this.messageType;
    }

    public boolean isDup() {
        return this.isDup;
    }

    public MqttQoS qosLevel() {
        return this.qosLevel;
    }

    public void downgradeQos() {
        this.qosLevel = MqttQoS.QOS0;
    }

    public boolean isRetain() {
        return this.isRetain;
    }

    public int headLength() {
        return this.headLength;
    }

    public int remainingLength() {
        return this.remainingLength;
    }

    public int getMessageLength() {
        return this.headLength + this.remainingLength;
    }

    public String toString() {
        return "MqttFixedHeader[messageType=" + (Object)((Object)this.messageType) + ", isDup=" + this.isDup + ", qosLevel=" + (Object)((Object)this.qosLevel) + ", isRetain=" + this.isRetain + ", remainingLength=" + this.remainingLength + ']';
    }
}

