/*
 * Decompiled with CFR 0.152.
 */
package org.dromara.mica.mqtt.codec.message.builder;

import java.util.function.Consumer;
import org.dromara.mica.mqtt.codec.MqttMessageType;
import org.dromara.mica.mqtt.codec.MqttQoS;
import org.dromara.mica.mqtt.codec.codes.MqttDisconnectReasonCode;
import org.dromara.mica.mqtt.codec.message.MqttMessage;
import org.dromara.mica.mqtt.codec.message.header.MqttFixedHeader;
import org.dromara.mica.mqtt.codec.message.header.MqttReasonCodeAndPropertiesVariableHeader;
import org.dromara.mica.mqtt.codec.message.properties.MqttDisconnectProperties;
import org.dromara.mica.mqtt.codec.properties.MqttProperties;

public final class MqttDisconnectBuilder {
    private MqttDisconnectReasonCode reasonCode;
    private MqttProperties properties = MqttProperties.NO_PROPERTIES;

    public MqttDisconnectBuilder reasonCode(MqttDisconnectReasonCode reasonCode) {
        this.reasonCode = reasonCode;
        return this;
    }

    public MqttDisconnectBuilder properties(MqttProperties properties) {
        this.properties = properties;
        return this;
    }

    public MqttDisconnectBuilder properties(Consumer<MqttDisconnectProperties> consumer) {
        MqttDisconnectProperties disconnectProperties = new MqttDisconnectProperties();
        consumer.accept(disconnectProperties);
        return this.properties(disconnectProperties.getProperties());
    }

    public MqttMessage build() {
        MqttFixedHeader mqttFixedHeader = new MqttFixedHeader(MqttMessageType.DISCONNECT, false, MqttQoS.QOS0, false, 0);
        MqttReasonCodeAndPropertiesVariableHeader mqttDisconnectVariableHeader = new MqttReasonCodeAndPropertiesVariableHeader(this.reasonCode.value(), this.properties);
        return new MqttMessage(mqttFixedHeader, mqttDisconnectVariableHeader);
    }
}

