/*
 * Decompiled with CFR 0.152.
 */
package org.docx4j.toc.switches;

import java.util.Map;
import org.docx4j.Docx4jProperties;
import org.docx4j.toc.TocEntry;
import org.docx4j.toc.switches.AbstractSwitch;
import org.docx4j.toc.switches.SwitchProcessorInterface;
import org.docx4j.wml.Style;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TSwitch
extends AbstractSwitch {
    private static Logger log = LoggerFactory.getLogger(TSwitch.class);
    public static final String ID = "\\t";
    private static final int PRIORITY = 9;
    private static final String DOCX4J_FIELDS_TOC_SWITCH_T_SEPARATOR = "docx4j.Fields.TOC.SwitchT.Separator";
    private static final String COMMA = ",";

    @Override
    public void process(Style s, SwitchProcessorInterface sp) {
        if (log.isDebugEnabled()) {
            log.debug(s.getStyleId());
        }
        if (sp.isStyleFound()) {
            log.debug(s.getName().getVal() + "already found");
            return;
        }
        TocEntry te = sp.getEntry();
        Map<String, Integer> styleLevelMap = this.getStyleLevelMap();
        for (String styleMapValue : styleLevelMap.keySet()) {
            if (!sp.getStyleBasedOnHelper().isBasedOn(s, styleMapValue)) continue;
            te.setEntryLevel(styleLevelMap.get(styleMapValue));
            if (log.isDebugEnabled()) {
                log.debug("its based on " + styleMapValue + "; level " + styleLevelMap.get(styleMapValue));
            }
            sp.setStyleFound(true);
            break;
        }
    }

    @Override
    public boolean isStyleSwitch() {
        return true;
    }

    @Override
    public String parseFieldArgument(String fieldArgument) {
        this.fieldArgument = fieldArgument;
        this.tSwitchSeparator = Docx4jProperties.getProperty(DOCX4J_FIELDS_TOC_SWITCH_T_SEPARATOR, COMMA);
        return "";
    }

    @Override
    public boolean hasFieldArgument() {
        return true;
    }

    @Override
    public int getPriority() {
        return 9;
    }
}

