/*
 * Decompiled with CFR 0.152.
 */
package org.dhatim.fastexcel.reader;

import java.nio.charset.StandardCharsets;
import java.util.Objects;

public final class CellAddress
implements Comparable<CellAddress> {
    public static final CellAddress A1 = new CellAddress(0, 0);
    private static final char ABSOLUTE_REFERENCE_MARKER = '$';
    private static final int COL_RADIX = 26;
    private final int row;
    private final int col;

    public CellAddress(int row, int column) {
        this.row = row;
        this.col = column;
    }

    public CellAddress(String address) {
        int length = address.length();
        if (length == 0) {
            this.row = 0;
            this.col = 0;
        } else {
            int offset;
            int col = 0;
            for (offset = address.charAt(0) == '$' ? 1 : 0; offset < length; ++offset) {
                char c = address.charAt(offset);
                if (c == '$') {
                    ++offset;
                    break;
                }
                if (CellAddress.isAsciiDigit(c)) break;
                col = col * 26 + CellAddress.toUpperCase(c) - 65 + 1;
            }
            this.col = col - 1;
            this.row = Integer.parseUnsignedInt(address.substring(offset)) - 1;
        }
    }

    public int getRow() {
        return this.row;
    }

    public int getColumn() {
        return this.col;
    }

    @Override
    public int compareTo(CellAddress other) {
        int r = this.row - other.row;
        if (r != 0) {
            return r;
        }
        r = this.col - other.col;
        return r;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        CellAddress other = (CellAddress)obj;
        return this.row == other.row && this.col == other.col;
    }

    public int hashCode() {
        return Objects.hash(this.row, this.col);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        CellAddress.format(sb, this.row, this.col);
        return sb.toString();
    }

    static void format(StringBuilder sb, int row, int col) {
        sb.append(CellAddress.convertNumToColString(col));
        sb.append(row + 1);
    }

    public static String convertNumToColString(int col) {
        int excelColNum = col + 1;
        int MAX_COL_CHARS = 3;
        byte[] colRef = new byte[3];
        int colRemain = excelColNum;
        int pos = 2;
        while (colRemain > 0) {
            int thisPart = colRemain % 26;
            if (thisPart == 0) {
                thisPart = 26;
            }
            colRemain = (colRemain - thisPart) / 26;
            colRef[pos--] = (byte)(thisPart + 65 - 1);
        }
        return new String(colRef, ++pos, 3 - pos, StandardCharsets.ISO_8859_1);
    }

    private static final boolean isAsciiLowerCase(char c) {
        return 'a' <= c && c <= 'z';
    }

    private static final boolean isAsciiUpperCase(char c) {
        return 'A' <= c && c <= 'Z';
    }

    private static final boolean isAsciiDigit(char c) {
        return '0' <= c && c <= '9';
    }

    private static final char toUpperCase(char c) {
        if (CellAddress.isAsciiUpperCase(c)) {
            return c;
        }
        if (CellAddress.isAsciiLowerCase(c)) {
            return (char)(c + -32);
        }
        throw new IllegalArgumentException("Unexpected char: " + c);
    }
}

