/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.session.Session;
import org.apache.shiro.session.UnknownSessionException;
import org.apache.shiro.session.mgt.eis.AbstractSessionDAO;
import org.crazycake.shiro.ObjectSerializer;
import org.crazycake.shiro.RedisManager;
import org.crazycake.shiro.RedisSerializer;
import org.crazycake.shiro.SerializationException;
import org.crazycake.shiro.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisSessionDAO
extends AbstractSessionDAO {
    private static Logger logger = LoggerFactory.getLogger(RedisSessionDAO.class);
    private static final String DEFAULT_SESSION_KEY_PREFIX = "shiro:session:";
    private RedisManager redisManager;
    private String keyPrefix = "shiro:session:";
    private RedisSerializer keySerializer = new StringSerializer();
    private RedisSerializer valueSerializer = new ObjectSerializer();

    public void update(Session session) throws UnknownSessionException {
        this.saveSession(session);
    }

    private void saveSession(Session session) throws UnknownSessionException {
        byte[] value;
        byte[] key;
        if (session == null || session.getId() == null) {
            logger.error("session or session id is null");
            throw new UnknownSessionException("session or session id is null");
        }
        try {
            key = this.keySerializer.serialize(this.getRedisSessionKey(session.getId()));
            value = this.valueSerializer.serialize(session);
        }
        catch (SerializationException e) {
            logger.error("serialize session error. session id=" + session.getId());
            throw new UnknownSessionException((Throwable)e);
        }
        session.setTimeout((long)(this.redisManager.getExpire() * 1000));
        this.redisManager.set(key, value, this.redisManager.getExpire());
    }

    public void delete(Session session) {
        if (session == null || session.getId() == null) {
            logger.error("session or session id is null");
            return;
        }
        try {
            this.redisManager.del(this.keySerializer.serialize(this.getRedisSessionKey(session.getId())));
        }
        catch (SerializationException e) {
            logger.error("delete session error. session id=" + session.getId());
        }
    }

    public Collection<Session> getActiveSessions() {
        HashSet<Session> sessions = new HashSet<Session>();
        try {
            Set<byte[]> keys = this.redisManager.keys(this.keySerializer.serialize(this.keyPrefix + "*"));
            if (keys != null && keys.size() > 0) {
                for (byte[] key : keys) {
                    Session s = (Session)this.valueSerializer.deserialize(this.redisManager.get(key));
                    sessions.add(s);
                }
            }
        }
        catch (SerializationException e) {
            logger.error("get active sessions error.");
        }
        return sessions;
    }

    protected Serializable doCreate(Session session) {
        if (session == null) {
            logger.error("session is null");
            throw new UnknownSessionException("session is null");
        }
        Serializable sessionId = this.generateSessionId(session);
        this.assignSessionId(session, sessionId);
        this.saveSession(session);
        return sessionId;
    }

    protected Session doReadSession(Serializable sessionId) {
        if (sessionId == null) {
            logger.warn("session id is null");
            return null;
        }
        Session s = null;
        try {
            s = (Session)this.valueSerializer.deserialize(this.redisManager.get(this.keySerializer.serialize(this.getRedisSessionKey(sessionId))));
        }
        catch (SerializationException e) {
            logger.error("read session error. settionId=" + sessionId);
        }
        return s;
    }

    private String getRedisSessionKey(Serializable sessionId) {
        return this.keyPrefix + sessionId;
    }

    public RedisManager getRedisManager() {
        return this.redisManager;
    }

    public void setRedisManager(RedisManager redisManager) {
        this.redisManager = redisManager;
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }

    public RedisSerializer getKeySerializer() {
        return this.keySerializer;
    }

    public void setKeySerializer(RedisSerializer keySerializer) {
        this.keySerializer = keySerializer;
    }

    public RedisSerializer getValueSerializer() {
        return this.valueSerializer;
    }

    public void setValueSerializer(RedisSerializer valueSerializer) {
        this.valueSerializer = valueSerializer;
    }
}

