/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.Set;
import org.apache.commons.pool2.impl.GenericObjectPoolConfig;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;

public class RedisManager {
    private String host = "127.0.0.1";
    private int port = 6379;
    private int expire = 0;
    private int timeout = 2000;
    private String password;
    private int database = 0;
    private volatile JedisPool jedisPool = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        RedisManager redisManager = this;
        synchronized (redisManager) {
            if (this.jedisPool == null) {
                this.jedisPool = new JedisPool((GenericObjectPoolConfig)new JedisPoolConfig(), this.host, this.port, this.timeout, this.password, this.database);
            }
        }
    }

    private void checkAndInit() {
        if (this.jedisPool == null) {
            this.init();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] get(byte[] key) {
        this.checkAndInit();
        if (key == null) {
            return null;
        }
        byte[] value = null;
        Jedis jedis = this.jedisPool.getResource();
        try {
            value = jedis.get(key);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] set(byte[] key, byte[] value) {
        this.checkAndInit();
        if (key == null) {
            return null;
        }
        Jedis jedis = this.jedisPool.getResource();
        try {
            jedis.set(key, value);
            if (this.expire != 0) {
                jedis.expire(key, this.expire);
            }
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] set(byte[] key, byte[] value, int expire) {
        this.checkAndInit();
        if (key == null) {
            return null;
        }
        Jedis jedis = this.jedisPool.getResource();
        try {
            jedis.set(key, value);
            if (expire != 0) {
                jedis.expire(key, expire);
            }
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void del(byte[] key) {
        this.checkAndInit();
        if (key == null) {
            return;
        }
        Jedis jedis = this.jedisPool.getResource();
        try {
            jedis.del(key);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flushDB() {
        this.checkAndInit();
        Jedis jedis = this.jedisPool.getResource();
        try {
            jedis.flushDB();
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Long dbSize() {
        this.checkAndInit();
        Long dbSize = 0L;
        Jedis jedis = this.jedisPool.getResource();
        try {
            dbSize = jedis.dbSize();
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return dbSize;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<byte[]> keys(byte[] pattern) {
        this.checkAndInit();
        Set keys = null;
        Jedis jedis = this.jedisPool.getResource();
        try {
            keys = jedis.keys(pattern);
        }
        finally {
            this.jedisPool.returnResource(jedis);
        }
        return keys;
    }

    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public int getExpire() {
        return this.expire;
    }

    public void setExpire(int expire) {
        this.expire = expire;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public int getDatabase() {
        return this.database;
    }

    public void setDatabase(int database) {
        this.database = database;
    }
}

