/*
 * Decompiled with CFR 0.152.
 */
package org.crazycake.shiro;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.shiro.cache.Cache;
import org.apache.shiro.cache.CacheException;
import org.apache.shiro.util.CollectionUtils;
import org.crazycake.shiro.ObjectSerializer;
import org.crazycake.shiro.RedisManager;
import org.crazycake.shiro.RedisSerializer;
import org.crazycake.shiro.SerializationException;
import org.crazycake.shiro.StringSerializer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RedisCache<K, V>
implements Cache<K, V> {
    private static Logger logger = LoggerFactory.getLogger(RedisCache.class);
    private static final String DEFAULT_CACHE_KEY_PREFIX = "shiro:cache:";
    private RedisSerializer keySerializer = new StringSerializer();
    private RedisSerializer valueSerializer = new ObjectSerializer();
    private RedisManager redisManager;
    private String keyPrefix = "shiro:cache:";

    public RedisCache(RedisManager redisManager, RedisSerializer keySerializer, RedisSerializer valueSerializer) {
        if (redisManager == null) {
            throw new IllegalArgumentException("Cache argument cannot be null.");
        }
        this.redisManager = redisManager;
        this.keySerializer = keySerializer;
        this.valueSerializer = valueSerializer;
    }

    public RedisCache(RedisManager cache, RedisSerializer keySerializer, RedisSerializer valueSerializer, String prefix) {
        this(cache, keySerializer, valueSerializer);
        this.keyPrefix = prefix;
    }

    public V get(K key) throws CacheException {
        logger.debug("get key [" + key + "]");
        if (key == null) {
            return null;
        }
        try {
            Object redisCacheKey = this.getRedisCacheKey(key);
            byte[] rawValue = this.redisManager.get(this.keySerializer.serialize(redisCacheKey));
            Object value = this.valueSerializer.deserialize(rawValue);
            return (V)value;
        }
        catch (SerializationException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V put(K key, V value) throws CacheException {
        logger.debug("put key [" + key + "]");
        try {
            Object redisCacheKey = this.getRedisCacheKey(key);
            this.redisManager.set(this.keySerializer.serialize(redisCacheKey), this.valueSerializer.serialize(value));
            return value;
        }
        catch (SerializationException e) {
            throw new CacheException((Throwable)e);
        }
    }

    public V remove(K key) throws CacheException {
        logger.debug("remove key [" + key + "]");
        try {
            V previous = this.get(key);
            Object redisCacheKey = this.getRedisCacheKey(key);
            this.redisManager.del(this.keySerializer.serialize(redisCacheKey));
            return previous;
        }
        catch (SerializationException e) {
            throw new CacheException((Throwable)e);
        }
    }

    private Object getRedisCacheKey(K key) {
        if (key == null) {
            return null;
        }
        Object redisKey = key;
        if (this.keySerializer instanceof StringSerializer) {
            redisKey = key.toString();
        }
        if (redisKey instanceof String) {
            return this.keyPrefix + (String)redisKey;
        }
        return redisKey;
    }

    public void clear() throws CacheException {
        logger.debug("clear cache");
        this.redisManager.flushDB();
    }

    public int size() {
        Long longSize = new Long(this.redisManager.dbSize());
        return longSize.intValue();
    }

    public Set<K> keys() {
        Set<byte[]> keys = null;
        try {
            keys = this.redisManager.keys(this.keySerializer.serialize(this.keyPrefix + "*"));
        }
        catch (SerializationException e) {
            logger.error("get keys error", (Throwable)e);
            return Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptySet();
        }
        HashSet convertedKeys = new HashSet();
        for (byte[] key : keys) {
            try {
                convertedKeys.add(this.keySerializer.deserialize(key));
            }
            catch (SerializationException e) {
                logger.error("deserialize keys error", (Throwable)e);
            }
        }
        return convertedKeys;
    }

    public Collection<V> values() {
        Set<byte[]> keys = null;
        try {
            keys = this.redisManager.keys(this.keySerializer.serialize(this.keyPrefix + "*"));
        }
        catch (SerializationException e) {
            logger.error("get values error", (Throwable)e);
            return Collections.emptySet();
        }
        if (CollectionUtils.isEmpty(keys)) {
            return Collections.emptySet();
        }
        ArrayList<Object> values = new ArrayList<Object>(keys.size());
        for (byte[] key : keys) {
            Object value = null;
            try {
                value = this.valueSerializer.deserialize(this.redisManager.get(key));
            }
            catch (SerializationException e) {
                logger.error("deserialize values= error", (Throwable)e);
            }
            if (value == null) continue;
            values.add(value);
        }
        return Collections.unmodifiableList(values);
    }

    public String getKeyPrefix() {
        return this.keyPrefix;
    }

    public void setKeyPrefix(String keyPrefix) {
        this.keyPrefix = keyPrefix;
    }
}

