/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.mojo.natives.plugin;

import java.io.File;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.codehaus.mojo.natives.NativeBuildException;
import org.codehaus.mojo.natives.NativeSources;
import org.codehaus.mojo.natives.compiler.ResourceCompiler;
import org.codehaus.mojo.natives.compiler.ResourceCompilerConfiguration;
import org.codehaus.mojo.natives.manager.NoSuchNativeProviderException;
import org.codehaus.mojo.natives.manager.ResourceCompilerManager;
import org.codehaus.mojo.natives.plugin.AbstractNativeMojo;
import org.codehaus.mojo.natives.plugin.NativeMojoUtils;
import org.codehaus.plexus.util.FileUtils;

@Mojo(name="resource-compile", defaultPhase=LifecyclePhase.GENERATE_RESOURCES)
public class NativeResourceCompileMojo
extends AbstractNativeMojo {
    @Parameter(defaultValue="msvc", required=true)
    private String provider;
    @Parameter
    private String resourceCompilerExecutable;
    @Parameter
    private List<String> resourceCompilerOptions;
    @Parameter
    private NativeSources[] resources;
    @Parameter(defaultValue="${project.build.directory}", required=true)
    protected File resourceCompilerOutputDirectory;
    @Component
    private ResourceCompilerManager manager;

    public void execute() throws MojoExecutionException {
        if (!this.resourceCompilerOutputDirectory.exists()) {
            this.resourceCompilerOutputDirectory.mkdirs();
        }
        FileUtils.mkdir((String)this.project.getBuild().getDirectory());
        ResourceCompiler compiler = this.getResourceCompiler();
        ResourceCompilerConfiguration config = new ResourceCompilerConfiguration();
        config.setExecutable(this.resourceCompilerExecutable);
        config.setWorkingDirectory(this.workingDirectory);
        config.setOptions(NativeMojoUtils.trimParams(this.resourceCompilerOptions));
        config.setOutputDirectory(this.resourceCompilerOutputDirectory);
        config.setEnvFactory(this.getEnvFactory());
        try {
            List resourceOutputFiles = compiler.compile(config, this.resources);
            this.saveCompilerOutputFilePaths(resourceOutputFiles);
        }
        catch (NativeBuildException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)((Object)e));
        }
    }

    private ResourceCompiler getResourceCompiler() throws MojoExecutionException {
        ResourceCompiler rc;
        try {
            rc = this.manager.getResourceCompiler(this.provider);
        }
        catch (NoSuchNativeProviderException pe) {
            throw new MojoExecutionException(pe.getMessage());
        }
        return rc;
    }
}

