/*
 * Decompiled with CFR 0.152.
 */
package org.codehaus.modello.plugin.xsd;

import org.codehaus.modello.ModelloException;
import org.codehaus.modello.model.Model;
import org.codehaus.modello.model.Version;
import org.codehaus.modello.plugin.xsd.metadata.XsdModelMetadata;
import org.codehaus.modello.plugins.xml.metadata.XmlModelMetadata;
import org.codehaus.plexus.util.StringUtils;

public class XsdModelHelper {
    public static String getNamespace(Model model, Version version) throws ModelloException {
        String namespace;
        XmlModelMetadata xmlModelMetadata = (XmlModelMetadata)model.getMetadata(XmlModelMetadata.ID);
        XsdModelMetadata xsdModelMetadata = (XsdModelMetadata)model.getMetadata(XsdModelMetadata.ID);
        if (StringUtils.isNotEmpty((String)xsdModelMetadata.getNamespace())) {
            namespace = xsdModelMetadata.getNamespace(version);
        } else {
            if (StringUtils.isEmpty((String)xmlModelMetadata.getNamespace())) {
                throw new ModelloException("Cannot generate xsd without xmlns specification: <model xml.namespace='...'> or <model xsd.namespace='...'>");
            }
            namespace = xmlModelMetadata.getNamespace(version);
        }
        return namespace;
    }

    public static String getTargetNamespace(Model model, Version version, String namespace) {
        XsdModelMetadata xsdModelMetadata = (XsdModelMetadata)model.getMetadata(XsdModelMetadata.ID);
        String targetNamespace = xsdModelMetadata.getTargetNamespace() == null ? namespace : xsdModelMetadata.getTargetNamespace(version);
        return targetNamespace;
    }

    public static String getTargetNamespace(Model model, Version version) throws ModelloException {
        return XsdModelHelper.getTargetNamespace(model, version, XsdModelHelper.getNamespace(model, version));
    }
}

