/*
 * Decompiled with CFR 0.152.
 */
package org.checkerframework.nullaway.dataflow.cfg.builder;

import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.lang.model.type.TypeMirror;
import org.checkerframework.nullaway.checker.nullness.qual.NonNull;
import org.checkerframework.nullaway.dataflow.cfg.ControlFlowGraph;
import org.checkerframework.nullaway.dataflow.cfg.block.BlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.ConditionalBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.ExceptionBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.RegularBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.SingleSuccessorBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.block.SpecialBlock;
import org.checkerframework.nullaway.dataflow.cfg.block.SpecialBlockImpl;
import org.checkerframework.nullaway.dataflow.cfg.builder.ConditionalJump;
import org.checkerframework.nullaway.dataflow.cfg.builder.ExtendedNode;
import org.checkerframework.nullaway.dataflow.cfg.builder.Label;
import org.checkerframework.nullaway.dataflow.cfg.builder.MissingEdge;
import org.checkerframework.nullaway.dataflow.cfg.builder.NodeWithExceptionsHolder;
import org.checkerframework.nullaway.dataflow.cfg.builder.PhaseOneResult;
import org.checkerframework.nullaway.dataflow.cfg.builder.UnconditionalJump;
import org.checkerframework.nullaway.dataflow.cfg.node.CatchMarkerNode;
import org.checkerframework.nullaway.dataflow.cfg.node.Node;
import org.checkerframework.nullaway.javacutil.BugInCF;
import org.checkerframework.nullaway.org.plumelib.util.ArraySet;

public class CFGTranslationPhaseTwo {
    private CFGTranslationPhaseTwo() {
    }

    public static ControlFlowGraph process(PhaseOneResult in) {
        Map<Label, Integer> bindings = in.bindings;
        List<ExtendedNode> nodeList = in.nodeList;
        Set<Integer> leaders = in.leaders;
        assert (!in.nodeList.isEmpty());
        SpecialBlockImpl regularExitBlock = new SpecialBlockImpl(SpecialBlock.SpecialBlockType.EXIT);
        SpecialBlockImpl exceptionalExitBlock = new SpecialBlockImpl(SpecialBlock.SpecialBlockType.EXCEPTIONAL_EXIT);
        ArraySet<MissingEdge> missingEdges = new ArraySet<MissingEdge>(1);
        LinkedHashSet<MissingEdge> missingExceptionalEdges = new LinkedHashSet<MissingEdge>();
        SpecialBlockImpl startBlock = new SpecialBlockImpl(SpecialBlock.SpecialBlockType.ENTRY);
        missingEdges.add(new MissingEdge(startBlock, 0));
        @NonNull RegularBlockImpl block = new RegularBlockImpl();
        int i = 0;
        for (ExtendedNode node : nodeList) {
            switch (node.getType()) {
                case NODE: {
                    if (leaders.contains(i)) {
                        RegularBlockImpl b = new RegularBlockImpl();
                        block.setSuccessor(b);
                        block = b;
                    }
                    block.addNode(node.getNode());
                    node.setBlock(block);
                    boolean terminatesExecution = node.getTerminatesExecution();
                    if (!terminatesExecution) break;
                    block.setSuccessor(exceptionalExitBlock);
                    block = new RegularBlockImpl();
                    break;
                }
                case CONDITIONAL_JUMP: {
                    ConditionalJump cj = (ConditionalJump)node;
                    node.setBlock(block);
                    assert (block != null);
                    final ConditionalBlockImpl cb = new ConditionalBlockImpl();
                    if (cj.getTrueFlowRule() != null) {
                        cb.setThenFlowRule(cj.getTrueFlowRule());
                    }
                    if (cj.getFalseFlowRule() != null) {
                        cb.setElseFlowRule(cj.getFalseFlowRule());
                    }
                    block.setSuccessor(cb);
                    block = new RegularBlockImpl();
                    Label thenLabel = cj.getThenLabel();
                    Label elseLabel = cj.getElseLabel();
                    Object target = bindings.get(thenLabel);
                    assert (target != null);
                    missingEdges.add(new MissingEdge(new RegularBlockImpl(){

                        @Override
                        public void setSuccessor(BlockImpl successor) {
                            cb.setThenSuccessor(successor);
                        }
                    }, (Integer)target));
                    target = bindings.get(elseLabel);
                    if (target == null) {
                        throw new BugInCF(String.format("in conditional jump %s, no binding for elseLabel %s: %s", cj, elseLabel, bindings));
                    }
                    missingEdges.add(new MissingEdge(new RegularBlockImpl(){

                        @Override
                        public void setSuccessor(BlockImpl successor) {
                            cb.setElseSuccessor(successor);
                        }
                    }, (Integer)target));
                    break;
                }
                case UNCONDITIONAL_JUMP: {
                    UnconditionalJump uj = (UnconditionalJump)node;
                    if (leaders.contains(i)) {
                        RegularBlockImpl b = new RegularBlockImpl();
                        block.setSuccessor(b);
                        block = b;
                    }
                    node.setBlock(block);
                    if (node.getLabel() == in.regularExitLabel) {
                        block.setSuccessor(regularExitBlock);
                        block.setFlowRule(uj.getFlowRule());
                    } else if (node.getLabel() == in.exceptionalExitLabel) {
                        block.setSuccessor(exceptionalExitBlock);
                        block.setFlowRule(uj.getFlowRule());
                    } else {
                        int target = bindings.get(node.getLabel());
                        missingEdges.add(new MissingEdge((SingleSuccessorBlockImpl)block, target, uj.getFlowRule()));
                    }
                    block = new RegularBlockImpl();
                    break;
                }
                case EXCEPTION_NODE: {
                    NodeWithExceptionsHolder en = (NodeWithExceptionsHolder)node;
                    ExceptionBlockImpl e = new ExceptionBlockImpl();
                    Node nn = en.getNode();
                    e.setNode(nn);
                    node.setBlock(e);
                    block.setSuccessor(e);
                    block = new RegularBlockImpl();
                    if (!node.getTerminatesExecution()) {
                        missingEdges.add(new MissingEdge(e, i + 1));
                    }
                    for (Map.Entry<TypeMirror, Set<Label>> entry : en.getExceptions().entrySet()) {
                        TypeMirror cause = entry.getKey();
                        for (Label label : entry.getValue()) {
                            Integer target = bindings.get(label);
                            missingExceptionalEdges.add(new MissingEdge((SingleSuccessorBlockImpl)e, target, cause));
                        }
                    }
                    break;
                }
            }
            ++i;
        }
        for (MissingEdge p : missingEdges) {
            Integer index = p.index;
            assert (index != null) : "CFGBuilder: problem in CFG construction " + p.source;
            ExtendedNode extendedNode = nodeList.get(index);
            BlockImpl target = extendedNode.getBlock();
            SingleSuccessorBlockImpl source = p.source;
            source.setSuccessor(target);
            if (p.flowRule == null) continue;
            source.setFlowRule(p.flowRule);
        }
        for (MissingEdge p : missingExceptionalEdges) {
            TypeMirror catchType;
            Node firstNode;
            Integer index = p.index;
            TypeMirror cause = p.cause;
            ExceptionBlockImpl source = (ExceptionBlockImpl)p.source;
            if (index == null) {
                source.addExceptionalSuccessor(exceptionalExitBlock, cause);
                continue;
            }
            ExtendedNode extendedNode = nodeList.get(index);
            BlockImpl target = extendedNode.getBlock();
            List<Node> targetNodes = target.getNodes();
            Node node = firstNode = targetNodes.isEmpty() ? null : targetNodes.get(0);
            if (firstNode instanceof CatchMarkerNode && in.types.isSubtype(catchType = ((CatchMarkerNode)firstNode).getCatchType(), cause)) {
                cause = catchType;
            }
            source.addExceptionalSuccessor(target, cause);
        }
        return new ControlFlowGraph(startBlock, regularExitBlock, exceptionalExitBlock, in.underlyingAST, in.treeToCfgNodes, in.treeToConvertedCfgNodes, in.postfixTreeToCfgNodes, in.returnNodes, in.declaredClasses, in.declaredLambdas);
    }
}

