/*
 * Decompiled with CFR 0.152.
 */
package org.camunda.spin.impl.xml.dom;

import java.util.Iterator;
import org.camunda.spin.impl.xml.dom.DomXmlNodeIterator;
import org.camunda.spin.impl.xml.dom.format.DomXmlDataFormat;
import org.camunda.spin.xml.SpinXmlAttribute;
import org.w3c.dom.Attr;
import org.w3c.dom.NodeList;

public class DomXmlAttributeIterable
implements Iterable<SpinXmlAttribute> {
    protected final NodeList nodeList;
    protected final DomXmlDataFormat dataFormat;
    protected final String namespace;
    protected final boolean validating;

    public DomXmlAttributeIterable(NodeList nodeList, DomXmlDataFormat dataFormat) {
        this.nodeList = nodeList;
        this.dataFormat = dataFormat;
        this.namespace = null;
        this.validating = false;
    }

    public DomXmlAttributeIterable(NodeList nodeList, DomXmlDataFormat dataFormat, String namespace) {
        this.nodeList = nodeList;
        this.dataFormat = dataFormat;
        this.namespace = namespace;
        this.validating = true;
    }

    @Override
    public Iterator<SpinXmlAttribute> iterator() {
        return new DomXmlNodeIterator<SpinXmlAttribute>(){
            private NodeList attributes;
            {
                this.attributes = DomXmlAttributeIterable.this.nodeList;
            }

            @Override
            protected int getLength() {
                return this.attributes.getLength();
            }

            @Override
            protected SpinXmlAttribute getCurrent() {
                if (this.attributes != null) {
                    Attr attribute = (Attr)this.attributes.item(this.index);
                    SpinXmlAttribute current = DomXmlAttributeIterable.this.dataFormat.createAttributeWrapper(attribute);
                    if (!DomXmlAttributeIterable.this.validating || current.hasNamespace(DomXmlAttributeIterable.this.namespace)) {
                        return current;
                    }
                }
                return null;
            }
        };
    }
}

