/*
 * Decompiled with CFR 0.152.
 */
package org.bytedeco.javacpp.indexer;

import org.bytedeco.javacpp.indexer.ByteIndexer;

public class ByteArrayIndexer
extends ByteIndexer {
    protected byte[] array;

    public ByteArrayIndexer(byte[] array) {
        this(array, new long[]{array.length}, new long[]{1L});
    }

    public ByteArrayIndexer(byte[] array, long[] sizes, long[] strides) {
        super(sizes, strides);
        this.array = array;
    }

    public byte[] array() {
        return this.array;
    }

    @Override
    public byte get(long i) {
        return this.array[(int)i];
    }

    @Override
    public ByteIndexer get(long i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)i * (int)this.strides[0] + n];
        }
        return this;
    }

    @Override
    public byte get(long i, long j) {
        return this.array[(int)i * (int)this.strides[0] + (int)j];
    }

    @Override
    public ByteIndexer get(long i, long j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n];
        }
        return this;
    }

    @Override
    public byte get(long i, long j, long k) {
        return this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k];
    }

    @Override
    public byte get(long ... indices) {
        return this.array[(int)this.index(indices)];
    }

    @Override
    public ByteIndexer get(long[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            b[offset + n] = this.array[(int)this.index(indices) + n];
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, byte b) {
        this.array[(int)i] = b;
        return this;
    }

    @Override
    public ByteIndexer put(long i, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, byte b) {
        this.array[(int)i * (int)this.strides[0] + (int)j] = b;
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public ByteIndexer put(long i, long j, long k, byte b) {
        this.array[(int)i * (int)this.strides[0] + (int)j * (int)this.strides[1] + (int)k] = b;
        return this;
    }

    @Override
    public ByteIndexer put(long[] indices, byte b) {
        this.array[(int)this.index((long[])indices)] = b;
        return this;
    }

    @Override
    public ByteIndexer put(long[] indices, byte[] b, int offset, int length) {
        for (int n = 0; n < length; ++n) {
            this.array[(int)this.index((long[])indices) + n] = b[offset + n];
        }
        return this;
    }

    @Override
    public void release() {
        this.array = null;
    }
}

