/*
 * Decompiled with CFR 0.152.
 */
package org.bsc.async;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Spliterators;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.bsc.async.AsyncGeneratorOperators;
import org.bsc.async.InternalIterator;
import org.bsc.async.internal.UnmodifiableDeque;

public interface AsyncGenerator<E>
extends Iterable<E>,
AsyncGeneratorOperators<E> {
    default public AsyncGeneratorOperators<E> async(final Executor executor) {
        return new AsyncGeneratorOperators<E>(){

            @Override
            public Data<E> next() {
                return AsyncGenerator.this.next();
            }

            @Override
            public Executor executor() {
                return executor;
            }
        };
    }

    @Override
    public Data<E> next();

    default public CompletableFuture<Object> toCompletableFuture() {
        Data<E> next = this.next();
        if (next.isDone()) {
            return CompletableFuture.completedFuture(next.resultValue);
        }
        return next.data.thenCompose(v -> this.toCompletableFuture());
    }

    @Deprecated
    default public <R extends List<E>> CompletableFuture<R> collectAsync(R result, Consumer<E> consumer, Executor executor) {
        return this.async(executor).collectAsync(result, (R r, E e) -> {
            consumer.accept(e);
            r.add(e);
        });
    }

    @Deprecated
    default public <R extends List<E>> CompletableFuture<R> collectAsync(R result, Consumer<E> consumer) {
        return this.collectAsync(result, consumer, this.executor());
    }

    default public Stream<E> stream() {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(this.iterator(), 16), false);
    }

    @Override
    default public Iterator<E> iterator() {
        return new InternalIterator(this);
    }

    public static <E> AsyncGenerator<E> empty() {
        return Data::done;
    }

    public static <E, U> AsyncGenerator<U> map(Iterator<E> iterator, Function<E, CompletableFuture<U>> mapFunction) {
        return () -> {
            if (!iterator.hasNext()) {
                return Data.done();
            }
            return Data.of((CompletableFuture)mapFunction.apply(iterator.next()));
        };
    }

    public static <E, U> AsyncGenerator<U> collect(Iterator<E> iterator, BiConsumer<E, Consumer<CompletableFuture<U>>> consumer) {
        ArrayList accumulator = new ArrayList();
        Consumer<CompletableFuture> addElement = accumulator::add;
        while (iterator.hasNext()) {
            consumer.accept(iterator.next(), addElement);
        }
        Iterator it = accumulator.iterator();
        return () -> {
            if (!it.hasNext()) {
                return Data.done();
            }
            return Data.of((CompletableFuture)it.next());
        };
    }

    public static <E, U> AsyncGenerator<U> map(Collection<E> collection, Function<E, CompletableFuture<U>> mapFunction) {
        if (collection == null || collection.isEmpty()) {
            return AsyncGenerator.empty();
        }
        return AsyncGenerator.map(collection.iterator(), mapFunction);
    }

    public static <E, U> AsyncGenerator<U> collect(Collection<E> collection, BiConsumer<E, Consumer<CompletableFuture<U>>> consumer) {
        if (collection == null || collection.isEmpty()) {
            return AsyncGenerator.empty();
        }
        return AsyncGenerator.collect(collection.iterator(), consumer);
    }

    public static class Data<E> {
        final CompletableFuture<E> data;
        final Embed<E> embed;
        final Object resultValue;

        public Data(CompletableFuture<E> data, Embed<E> embed, Object resultValue) {
            this.data = data;
            this.embed = embed;
            this.resultValue = resultValue;
        }

        public boolean isDone() {
            return this.data == null && this.embed == null;
        }

        public static <E> Data<E> of(CompletableFuture<E> data) {
            return new Data<E>(data, null, null);
        }

        public static <E> Data<E> of(E data) {
            return new Data<E>(CompletableFuture.completedFuture(data), null, null);
        }

        public static <E> Data<E> composeWith(AsyncGenerator<E> generator, EmbedCompletionHandler onCompletion) {
            return new Data<E>(null, new Embed<E>(generator, onCompletion), null);
        }

        public static <E> Data<E> done() {
            return new Data<E>(null, null, null);
        }

        public static <E> Data<E> done(Object resultValue) {
            return new Data<E>(null, null, resultValue);
        }

        public static <E> Data<E> error(Throwable exception) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(exception);
            return Data.of(future);
        }
    }

    public static class Embed<E> {
        final AsyncGenerator<E> generator;
        final EmbedCompletionHandler onCompletion;

        public Embed(AsyncGenerator<E> generator, EmbedCompletionHandler onCompletion) {
            Objects.requireNonNull(generator, "generator cannot be null");
            this.generator = generator;
            this.onCompletion = onCompletion;
        }
    }

    @FunctionalInterface
    public static interface EmbedCompletionHandler {
        public void accept(Object var1) throws Exception;
    }

    public static class WithEmbed<E>
    implements AsyncGenerator<E> {
        protected final Deque<Embed<E>> generatorsStack = new ArrayDeque<Embed<E>>(2);
        private final Deque<Data<E>> returnValueStack = new ArrayDeque<Data<E>>(2);

        public WithEmbed(AsyncGenerator<E> delegate, EmbedCompletionHandler onGeneratorDoneWithResult) {
            this.generatorsStack.push(new Embed<E>(delegate, onGeneratorDoneWithResult));
        }

        public WithEmbed(AsyncGenerator<E> delegate) {
            this(delegate, null);
        }

        public Deque<Data<E>> resultValues() {
            return new UnmodifiableDeque<Data<E>>(this.returnValueStack);
        }

        private void clearPreviousReturnsValuesIfAny() {
            if (this.returnValueStack.size() > 1 && this.returnValueStack.size() == this.generatorsStack.size()) {
                this.returnValueStack.clear();
            }
        }

        protected boolean isLastGenerator() {
            return this.generatorsStack.size() == 1;
        }

        @Override
        public Data<E> next() {
            if (this.generatorsStack.isEmpty()) {
                throw new IllegalStateException("no generator found!");
            }
            Embed<E> embed = this.generatorsStack.peek();
            Data result = embed.generator.next();
            if (result.isDone()) {
                this.clearPreviousReturnsValuesIfAny();
                this.returnValueStack.push(result);
                if (embed.onCompletion != null) {
                    try {
                        embed.onCompletion.accept(result.resultValue);
                    }
                    catch (Exception e) {
                        return Data.error(e);
                    }
                }
                if (this.isLastGenerator()) {
                    return result;
                }
                this.generatorsStack.pop();
                return this.next();
            }
            if (result.embed != null) {
                if (this.generatorsStack.size() >= 2) {
                    return Data.error(new UnsupportedOperationException("Currently recursive nested generators are not supported!"));
                }
                this.generatorsStack.push(result.embed);
                return this.next();
            }
            return result;
        }
    }

    public static class WithResult<E>
    implements AsyncGenerator<E> {
        protected final AsyncGenerator<E> delegate;
        private Object resultValue;

        public WithResult(AsyncGenerator<E> delegate) {
            this.delegate = delegate;
        }

        public AsyncGenerator<E> delegate() {
            return this.delegate;
        }

        public Optional<Object> resultValue() {
            return Optional.ofNullable(this.resultValue);
        }

        @Override
        public final Data<E> next() {
            Data<E> result = this.delegate.next();
            if (result.isDone()) {
                this.resultValue = result.resultValue;
            }
            return result;
        }
    }
}

