/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.store;

import com.google.common.base.Stopwatch;
import com.google.common.collect.Lists;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.Address;
import org.bitcoinj.core.AddressFormatException;
import org.bitcoinj.core.ECKey;
import org.bitcoinj.core.LegacyAddress;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Sha256Hash;
import org.bitcoinj.core.StoredBlock;
import org.bitcoinj.core.StoredUndoableBlock;
import org.bitcoinj.core.Transaction;
import org.bitcoinj.core.TransactionOutputChanges;
import org.bitcoinj.core.UTXO;
import org.bitcoinj.core.UTXOProviderException;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VerificationException;
import org.bitcoinj.script.Script;
import org.bitcoinj.script.ScriptException;
import org.bitcoinj.store.BlockStoreException;
import org.bitcoinj.store.FullPrunedBlockStore;
import org.fusesource.leveldbjni.JniDBFactory;
import org.iq80.leveldb.DB;
import org.iq80.leveldb.DBException;
import org.iq80.leveldb.DBIterator;
import org.iq80.leveldb.Options;
import org.iq80.leveldb.ReadOptions;
import org.iq80.leveldb.Snapshot;
import org.iq80.leveldb.WriteBatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LevelDBFullPrunedBlockStore
implements FullPrunedBlockStore {
    private static final Logger log = LoggerFactory.getLogger(LevelDBFullPrunedBlockStore.class);
    NetworkParameters params;
    DB db = null;
    protected Sha256Hash chainHeadHash;
    protected StoredBlock chainHeadBlock;
    protected Sha256Hash verifiedChainHeadHash;
    protected StoredBlock verifiedChainHeadBlock;
    protected int fullStoreDepth;
    protected boolean instrument = false;
    Stopwatch totalStopwatch;
    protected long hit;
    protected long miss;
    Map<String, Stopwatch> methodStartTime;
    Map<String, Long> methodCalls;
    Map<String, Long> methodTotalTime;
    int exitBlock;
    protected Map<ByteBuffer, UTXO> utxoCache;
    protected Map<ByteBuffer, UTXO> utxoUncommittedCache;
    protected Set<ByteBuffer> utxoUncommittedDeletedCache;
    protected String filename;
    protected boolean autoCommit = true;
    Map<ByteBuffer, byte[]> uncommited;
    Set<ByteBuffer> uncommitedDeletes;
    protected long leveldbReadCache;
    protected int leveldbWriteCache;
    protected int openOutCache;
    protected BloomFilter bloom;
    static final long LEVELDB_READ_CACHE_DEFAULT = 0x6400000L;
    static final int LEVELDB_WRITE_CACHE_DEFAULT = 0xA00000;
    static final int OPENOUT_CACHE_DEFAULT = 100000;
    long hasCall;
    long hasTrue;
    long hasFalse;
    WriteBatch batch;

    public LevelDBFullPrunedBlockStore(NetworkParameters params, String filename, int blockCount) {
        this(params, filename, blockCount, 0x6400000L, 0xA00000, 100000, false, Integer.MAX_VALUE);
    }

    public LevelDBFullPrunedBlockStore(NetworkParameters params, String filename, int blockCount, long leveldbReadCache, int leveldbWriteCache, int openOutCache, boolean instrument, int exitBlock) {
        this.params = params;
        this.fullStoreDepth = blockCount;
        this.instrument = instrument;
        this.exitBlock = exitBlock;
        this.methodStartTime = new HashMap<String, Stopwatch>();
        this.methodCalls = new HashMap<String, Long>();
        this.methodTotalTime = new HashMap<String, Long>();
        this.filename = filename;
        this.leveldbReadCache = leveldbReadCache;
        this.leveldbWriteCache = leveldbWriteCache;
        this.openOutCache = openOutCache;
        this.bloom = new BloomFilter();
        this.totalStopwatch = Stopwatch.createStarted();
        this.openDB();
        this.bloom.reloadCache(this.db);
        this.totalStopwatch = Stopwatch.createStarted();
    }

    private void openDB() {
        Options options = new Options();
        options.createIfMissing(true);
        options.cacheSize(this.leveldbReadCache);
        options.writeBufferSize(this.leveldbWriteCache);
        options.maxOpenFiles(10000);
        try {
            this.db = JniDBFactory.factory.open(new File(this.filename), options);
        }
        catch (IOException e) {
            throw new RuntimeException("Can not open DB", e);
        }
        this.utxoCache = new LRUCache(this.openOutCache, 0.75f);
        try {
            if (this.batchGet(this.getKey(KeyType.CREATED)) == null) {
                this.createNewStore(this.params);
            } else {
                this.initFromDb();
            }
        }
        catch (BlockStoreException e) {
            throw new RuntimeException("Can not init/load db", e);
        }
    }

    private void initFromDb() throws BlockStoreException {
        Sha256Hash hash = Sha256Hash.wrap(this.batchGet(this.getKey(KeyType.CHAIN_HEAD_SETTING)));
        this.chainHeadBlock = this.get(hash);
        this.chainHeadHash = hash;
        if (this.chainHeadBlock == null) {
            throw new BlockStoreException("corrupt database block store - head block not found");
        }
        hash = Sha256Hash.wrap(this.batchGet(this.getKey(KeyType.VERIFIED_CHAIN_HEAD_SETTING)));
        this.verifiedChainHeadBlock = this.get(hash);
        this.verifiedChainHeadHash = hash;
        if (this.verifiedChainHeadBlock == null) {
            throw new BlockStoreException("corrupt database block store - verified head block not found");
        }
    }

    private void createNewStore(NetworkParameters params) throws BlockStoreException {
        try {
            StoredBlock storedGenesisHeader = new StoredBlock(params.getGenesisBlock().cloneAsHeader(), params.getGenesisBlock().getWork(), 0);
            LinkedList genesisTransactions = Lists.newLinkedList();
            StoredUndoableBlock storedGenesis = new StoredUndoableBlock(params.getGenesisBlock().getHash(), genesisTransactions);
            this.beginDatabaseBatchWrite();
            this.put(storedGenesisHeader, storedGenesis);
            this.setChainHead(storedGenesisHeader);
            this.setVerifiedChainHead(storedGenesisHeader);
            this.batchPut(this.getKey(KeyType.CREATED), JniDBFactory.bytes((String)"done"));
            this.commitDatabaseBatchWrite();
        }
        catch (VerificationException e) {
            throw new RuntimeException(e);
        }
    }

    void beginMethod(String name) {
        this.methodStartTime.put(name, Stopwatch.createStarted());
    }

    void endMethod(String name) {
        if (this.methodCalls.containsKey(name)) {
            this.methodCalls.put(name, this.methodCalls.get(name) + 1L);
            this.methodTotalTime.put(name, this.methodTotalTime.get(name) + this.methodStartTime.get(name).elapsed(TimeUnit.NANOSECONDS));
        } else {
            this.methodCalls.put(name, 1L);
            this.methodTotalTime.put(name, this.methodStartTime.get(name).elapsed(TimeUnit.NANOSECONDS));
        }
    }

    void dumpStats() {
        long wallTimeNanos = this.totalStopwatch.elapsed(TimeUnit.NANOSECONDS);
        long dbtime = 0L;
        for (String name : this.methodCalls.keySet()) {
            long calls = this.methodCalls.get(name);
            long time = this.methodTotalTime.get(name);
            dbtime += time;
            long average = time / calls;
            double proportion = ((double)time + 0.0) / ((double)wallTimeNanos + 0.0);
            log.info(name + " c:" + calls + " r:" + time + " a:" + average + " p:" + String.format("%.2f", proportion));
        }
        double dbproportion = ((double)dbtime + 0.0) / ((double)wallTimeNanos + 0.0);
        double hitrate = ((double)this.hit + 0.0) / ((double)(this.hit + this.miss) + 0.0);
        log.info("Cache size:" + this.utxoCache.size() + " hit:" + this.hit + " miss:" + this.miss + " rate:" + String.format("%.2f", hitrate));
        this.bloom.printStat();
        log.info("hasTxOut call:" + this.hasCall + " True:" + this.hasTrue + " False:" + this.hasFalse);
        log.info("Wall:" + this.totalStopwatch + " percent:" + String.format("%.2f", dbproportion));
        String stats = this.db.getProperty("leveldb.stats");
        System.out.println(stats);
    }

    @Override
    public void put(StoredBlock block) throws BlockStoreException {
        this.putUpdateStoredBlock(block, false);
    }

    @Override
    public StoredBlock getChainHead() throws BlockStoreException {
        return this.chainHeadBlock;
    }

    @Override
    public void setChainHead(StoredBlock chainHead) throws BlockStoreException {
        Sha256Hash hash;
        if (this.instrument) {
            this.beginMethod("setChainHead");
        }
        this.chainHeadHash = hash = chainHead.getHeader().getHash();
        this.chainHeadBlock = chainHead;
        this.batchPut(this.getKey(KeyType.CHAIN_HEAD_SETTING), hash.getBytes());
        if (this.instrument) {
            this.endMethod("setChainHead");
        }
    }

    @Override
    public void close() throws BlockStoreException {
        try {
            this.db.close();
        }
        catch (IOException e) {
            throw new BlockStoreException("Could not close db", e);
        }
    }

    @Override
    public NetworkParameters getParams() {
        return this.params;
    }

    @Override
    public List<UTXO> getOpenTransactionOutputs(List<ECKey> keys) throws UTXOProviderException {
        LinkedList<UTXO> results = new LinkedList<UTXO>();
        for (ECKey key : keys) {
            ByteBuffer bb = ByteBuffer.allocate(21);
            bb.put((byte)KeyType.ADDRESS_HASHINDEX.ordinal());
            bb.put(key.getPubKeyHash());
            ReadOptions ro = new ReadOptions();
            Snapshot sn = this.db.getSnapshot();
            ro.snapshot(sn);
            DBIterator iterator = this.db.iterator(ro);
            iterator.seek(bb.array());
            while (iterator.hasNext()) {
                UTXO txout;
                ByteBuffer bbKey = ByteBuffer.wrap((byte[])iterator.peekNext().getKey());
                bbKey.get();
                byte[] addressKey = new byte[20];
                bbKey.get(addressKey);
                if (!Arrays.equals(addressKey, key.getPubKeyHash())) break;
                byte[] hashBytes = new byte[32];
                bbKey.get(hashBytes);
                int index = bbKey.getInt();
                Sha256Hash hash = Sha256Hash.wrap(hashBytes);
                try {
                    txout = this.getTransactionOutput(hash, index);
                }
                catch (BlockStoreException e) {
                    throw new UTXOProviderException("block store execption", e);
                }
                if (txout != null) {
                    Script sc = txout.getScript();
                    Address address = sc.getToAddress(this.params, true);
                    UTXO output = new UTXO(txout.getHash(), txout.getIndex(), txout.getValue(), txout.getHeight(), txout.isCoinbase(), txout.getScript(), address.toString());
                    results.add(output);
                }
                iterator.next();
            }
            try {
                iterator.close();
                ro = null;
                sn.close();
                sn = null;
            }
            catch (IOException e) {
                log.error("Error closing snapshot/iterator?", (Throwable)e);
            }
        }
        return results;
    }

    @Override
    public int getChainHeadHeight() throws UTXOProviderException {
        try {
            return this.getVerifiedChainHead().getHeight();
        }
        catch (BlockStoreException e) {
            throw new UTXOProviderException(e);
        }
    }

    protected void putUpdateStoredBlock(StoredBlock storedBlock, boolean wasUndoable) {
        if (this.instrument) {
            this.beginMethod("putUpdateStoredBlock");
        }
        Sha256Hash hash = storedBlock.getHeader().getHash();
        ByteBuffer bb = ByteBuffer.allocate(97);
        storedBlock.serializeCompact(bb);
        bb.put((byte)(wasUndoable ? 1 : 0));
        this.batchPut(this.getKey(KeyType.HEADERS_ALL, hash), bb.array());
        if (this.instrument) {
            this.endMethod("putUpdateStoredBlock");
        }
    }

    @Override
    public void put(StoredBlock storedBlock, StoredUndoableBlock undoableBlock) throws BlockStoreException {
        ByteBuffer undoBuf;
        if (this.instrument) {
            this.beginMethod("put");
        }
        int height = storedBlock.getHeight();
        byte[] transactions = null;
        byte[] txOutChanges = null;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            if (undoableBlock.getTxOutChanges() != null) {
                undoableBlock.getTxOutChanges().serializeToStream(bos);
                txOutChanges = bos.toByteArray();
            } else {
                int numTxn = undoableBlock.getTransactions().size();
                Utils.uint32ToByteStreamLE(numTxn, bos);
                for (Transaction tx : undoableBlock.getTransactions()) {
                    tx.bitcoinSerialize(bos);
                }
                transactions = bos.toByteArray();
            }
            bos.close();
        }
        catch (IOException e) {
            throw new BlockStoreException(e);
        }
        Sha256Hash hash = storedBlock.getHeader().getHash();
        ByteBuffer keyBuf = ByteBuffer.allocate(33);
        keyBuf.put((byte)KeyType.HEIGHT_UNDOABLEBLOCKS.ordinal());
        keyBuf.putInt(height);
        keyBuf.put(hash.getBytes(), 4, 28);
        this.batchPut(keyBuf.array(), new byte[1]);
        if (transactions == null) {
            undoBuf = ByteBuffer.allocate(8 + txOutChanges.length + 4 + 0);
            undoBuf.putInt(height);
            undoBuf.putInt(txOutChanges.length);
            undoBuf.put(txOutChanges);
            undoBuf.putInt(0);
            this.batchPut(this.getKey(KeyType.UNDOABLEBLOCKS_ALL, hash), undoBuf.array());
        } else {
            undoBuf = ByteBuffer.allocate(12 + transactions.length);
            undoBuf.putInt(height);
            undoBuf.putInt(0);
            undoBuf.putInt(transactions.length);
            undoBuf.put(transactions);
            this.batchPut(this.getKey(KeyType.UNDOABLEBLOCKS_ALL, hash), undoBuf.array());
        }
        if (this.instrument) {
            this.endMethod("put");
        }
        this.putUpdateStoredBlock(storedBlock, true);
    }

    private byte[] getKey(KeyType keytype) {
        byte[] key = new byte[]{(byte)keytype.ordinal()};
        return key;
    }

    private byte[] getTxKey(KeyType keytype, Sha256Hash hash) {
        byte[] key = new byte[33];
        key[0] = (byte)keytype.ordinal();
        System.arraycopy(hash.getBytes(), 0, key, 1, 32);
        return key;
    }

    private byte[] getTxKey(KeyType keytype, Sha256Hash hash, int index) {
        byte[] key = new byte[37];
        key[0] = (byte)keytype.ordinal();
        System.arraycopy(hash.getBytes(), 0, key, 1, 32);
        byte[] heightBytes = ByteBuffer.allocate(4).putInt(index).array();
        System.arraycopy(heightBytes, 0, key, 33, 4);
        return key;
    }

    private byte[] getKey(KeyType keytype, Sha256Hash hash) {
        byte[] key = new byte[29];
        key[0] = (byte)keytype.ordinal();
        System.arraycopy(hash.getBytes(), 4, key, 1, 28);
        return key;
    }

    private byte[] getKey(KeyType keytype, byte[] hash) {
        byte[] key = new byte[29];
        key[0] = (byte)keytype.ordinal();
        System.arraycopy(hash, 4, key, 1, 28);
        return key;
    }

    @Override
    public StoredBlock getOnceUndoableStoredBlock(Sha256Hash hash) throws BlockStoreException {
        return this.get(hash, true);
    }

    @Override
    public StoredBlock get(Sha256Hash hash) throws BlockStoreException {
        return this.get(hash, false);
    }

    public StoredBlock get(Sha256Hash hash, boolean wasUndoableOnly) throws BlockStoreException {
        boolean undoableResult;
        byte[] result;
        if (this.chainHeadHash != null && this.chainHeadHash.equals(hash)) {
            return this.chainHeadBlock;
        }
        if (this.verifiedChainHeadHash != null && this.verifiedChainHeadHash.equals(hash)) {
            return this.verifiedChainHeadBlock;
        }
        if (this.instrument) {
            this.beginMethod("get");
        }
        if ((result = this.batchGet(this.getKey(KeyType.HEADERS_ALL, hash))) == null) {
            if (this.instrument) {
                this.endMethod("get");
            }
            return null;
        }
        boolean bl = undoableResult = result[96] == 1;
        if (wasUndoableOnly && !undoableResult) {
            if (this.instrument) {
                this.endMethod("get");
            }
            return null;
        }
        StoredBlock stored = StoredBlock.deserializeCompact(this.params, ByteBuffer.wrap(result));
        stored.getHeader().verifyHeader();
        if (this.instrument) {
            this.endMethod("get");
        }
        return stored;
    }

    @Override
    public StoredUndoableBlock getUndoBlock(Sha256Hash hash) throws BlockStoreException {
        try {
            StoredUndoableBlock block;
            byte[] result;
            if (this.instrument) {
                this.beginMethod("getUndoBlock");
            }
            if ((result = this.batchGet(this.getKey(KeyType.UNDOABLEBLOCKS_ALL, hash))) == null) {
                if (this.instrument) {
                    this.endMethod("getUndoBlock");
                }
                return null;
            }
            ByteBuffer bb = ByteBuffer.wrap(result);
            bb.getInt();
            int txOutSize = bb.getInt();
            if (txOutSize == 0) {
                int txSize = bb.getInt();
                byte[] transactions = new byte[txSize];
                bb.get(transactions);
                int numTxn = (int)Utils.readUint32(transactions, 0);
                int offset = 4;
                LinkedList<Transaction> transactionList = new LinkedList<Transaction>();
                for (int i = 0; i < numTxn; ++i) {
                    Transaction tx = new Transaction(this.params, transactions, offset);
                    transactionList.add(tx);
                    offset += tx.getMessageSize();
                }
                block = new StoredUndoableBlock(hash, transactionList);
            } else {
                byte[] txOutChanges = new byte[txOutSize];
                bb.get(txOutChanges);
                TransactionOutputChanges outChangesObject = new TransactionOutputChanges(new ByteArrayInputStream(txOutChanges));
                block = new StoredUndoableBlock(hash, outChangesObject);
            }
            if (this.instrument) {
                this.endMethod("getUndoBlock");
            }
            return block;
        }
        catch (IOException e) {
            if (this.instrument) {
                this.endMethod("getUndoBlock");
            }
            throw new BlockStoreException(e);
        }
    }

    @Override
    public UTXO getTransactionOutput(Sha256Hash hash, long index) throws BlockStoreException {
        block15: {
            if (this.instrument) {
                this.beginMethod("getTransactionOutput");
            }
            try {
                UTXO result = null;
                byte[] key = this.getTxKey(KeyType.OPENOUT_ALL, hash, (int)index);
                if (this.autoCommit) {
                    result = this.utxoCache.get(ByteBuffer.wrap(key));
                } else {
                    if (this.utxoUncommittedDeletedCache.contains(ByteBuffer.wrap(key))) {
                        ++this.hit;
                        if (this.instrument) {
                            this.endMethod("getTransactionOutput");
                        }
                        return result;
                    }
                    result = this.utxoUncommittedCache.get(ByteBuffer.wrap(key));
                    if (result == null) {
                        result = this.utxoCache.get(ByteBuffer.wrap(key));
                    }
                }
                if (result != null) {
                    ++this.hit;
                    if (this.instrument) {
                        this.endMethod("getTransactionOutput");
                    }
                    return result;
                }
                ++this.miss;
                byte[] inbytes = this.batchGet(key);
                if (inbytes == null) {
                    if (this.instrument) {
                        this.endMethod("getTransactionOutput");
                    }
                    return null;
                }
                ByteArrayInputStream bis = new ByteArrayInputStream(inbytes);
                UTXO txout = new UTXO(bis);
                if (this.instrument) {
                    this.endMethod("getTransactionOutput");
                }
                return txout;
            }
            catch (DBException e) {
                log.error("Exception in getTransactionOutput.", (Throwable)e);
                if (this.instrument) {
                    this.endMethod("getTransactionOutput");
                }
            }
            catch (IOException e) {
                log.error("Exception in getTransactionOutput.", (Throwable)e);
                if (!this.instrument) break block15;
                this.endMethod("getTransactionOutput");
            }
        }
        throw new BlockStoreException("problem");
    }

    @Override
    public void addUnspentTransactionOutput(UTXO out) throws BlockStoreException {
        LegacyAddress a;
        if (this.instrument) {
            this.beginMethod("addUnspentTransactionOutput");
        }
        this.bloom.add(out.getHash());
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            out.serializeToStream(bos);
        }
        catch (IOException e) {
            throw new BlockStoreException("problem serialising utxo", e);
        }
        byte[] key = this.getTxKey(KeyType.OPENOUT_ALL, out.getHash(), (int)out.getIndex());
        this.batchPut(key, bos.toByteArray());
        if (this.autoCommit) {
            this.utxoCache.put(ByteBuffer.wrap(key), out);
        } else {
            this.utxoUncommittedCache.put(ByteBuffer.wrap(key), out);
            this.utxoUncommittedDeletedCache.remove(ByteBuffer.wrap(key));
        }
        if (out.getAddress() == null || out.getAddress().equals("")) {
            if (this.instrument) {
                this.endMethod("addUnspentTransactionOutput");
            }
            return;
        }
        try {
            a = LegacyAddress.fromBase58(this.params, out.getAddress());
        }
        catch (AddressFormatException e) {
            if (this.instrument) {
                this.endMethod("addUnspentTransactionOutput");
            }
            return;
        }
        ByteBuffer bb = ByteBuffer.allocate(57);
        bb.put((byte)KeyType.ADDRESS_HASHINDEX.ordinal());
        bb.put(((Address)a).getHash());
        bb.put(out.getHash().getBytes());
        bb.putInt((int)out.getIndex());
        byte[] value = new byte[]{};
        this.batchPut(bb.array(), value);
        if (this.instrument) {
            this.endMethod("addUnspentTransactionOutput");
        }
    }

    private void batchPut(byte[] key, byte[] value) {
        if (this.autoCommit) {
            this.db.put(key, value);
        } else {
            this.uncommited.put(ByteBuffer.wrap(key), value);
            this.batch.put(key, value);
        }
    }

    private byte[] batchGet(byte[] key) {
        ByteBuffer bbKey = ByteBuffer.wrap(key);
        if (!this.autoCommit && this.uncommitedDeletes != null && this.uncommitedDeletes.contains(bbKey)) {
            return null;
        }
        byte[] value = null;
        if (!this.autoCommit && this.uncommited != null && (value = this.uncommited.get(bbKey)) != null) {
            return value;
        }
        try {
            value = this.db.get(key);
        }
        catch (DBException e) {
            log.error("Caught error opening file", (Throwable)e);
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            value = this.db.get(key);
        }
        return value;
    }

    private void batchDelete(byte[] key) {
        if (!this.autoCommit) {
            this.batch.delete(key);
            this.uncommited.remove(ByteBuffer.wrap(key));
            this.uncommitedDeletes.add(ByteBuffer.wrap(key));
        } else {
            this.db.delete(key);
        }
    }

    @Override
    public void removeUnspentTransactionOutput(UTXO out) throws BlockStoreException {
        if (this.instrument) {
            this.beginMethod("removeUnspentTransactionOutput");
        }
        byte[] key = this.getTxKey(KeyType.OPENOUT_ALL, out.getHash(), (int)out.getIndex());
        if (this.autoCommit) {
            this.utxoCache.remove(ByteBuffer.wrap(key));
        } else {
            this.utxoUncommittedDeletedCache.add(ByteBuffer.wrap(key));
            this.utxoUncommittedCache.remove(ByteBuffer.wrap(key));
        }
        this.batchDelete(key);
        ByteBuffer bb = ByteBuffer.allocate(57);
        byte[] hashBytes = null;
        try {
            String address = out.getAddress();
            if (address == null || address.equals("")) {
                Script sc = out.getScript();
                Address a = sc.getToAddress(this.params);
                hashBytes = a.getHash();
            } else {
                LegacyAddress a = LegacyAddress.fromBase58(this.params, out.getAddress());
                hashBytes = ((Address)a).getHash();
            }
        }
        catch (AddressFormatException e) {
            if (this.instrument) {
                this.endMethod("removeUnspentTransactionOutput");
            }
            return;
        }
        catch (ScriptException e) {
            if (this.instrument) {
                this.endMethod("removeUnspentTransactionOutput");
            }
            return;
        }
        bb.put((byte)KeyType.ADDRESS_HASHINDEX.ordinal());
        bb.put(hashBytes);
        bb.put(out.getHash().getBytes());
        bb.putInt((int)out.getIndex());
        this.batchDelete(bb.array());
        if (this.instrument) {
            this.endMethod("removeUnspentTransactionOutput");
        }
    }

    @Override
    public boolean hasUnspentOutputs(Sha256Hash hash, int numOutputs) throws BlockStoreException {
        if (this.instrument) {
            this.beginMethod("hasUnspentOutputs");
        }
        ++this.hasCall;
        if (!this.bloom.wasAdded(hash)) {
            if (this.instrument) {
                this.endMethod("hasUnspentOutputs");
            }
            ++this.hasFalse;
            return false;
        }
        byte[] key = this.getTxKey(KeyType.OPENOUT_ALL, hash);
        byte[] subResult = new byte[key.length];
        DBIterator iterator = this.db.iterator();
        iterator.seek(key);
        if (iterator.hasNext()) {
            byte[] result = (byte[])iterator.peekNext().getKey();
            System.arraycopy(result, 0, subResult, 0, subResult.length);
            if (Arrays.equals(key, subResult)) {
                ++this.hasTrue;
                try {
                    iterator.close();
                }
                catch (IOException e) {
                    log.error("Error closing iterator", (Throwable)e);
                }
                if (this.instrument) {
                    this.endMethod("hasUnspentOutputs");
                }
                return true;
            }
            ++this.hasFalse;
            try {
                iterator.close();
            }
            catch (IOException e) {
                log.error("Error closing iterator", (Throwable)e);
            }
            if (this.instrument) {
                this.endMethod("hasUnspentOutputs");
            }
            return false;
        }
        try {
            iterator.close();
        }
        catch (IOException e) {
            log.error("Error closing iterator", (Throwable)e);
        }
        ++this.hasFalse;
        if (this.instrument) {
            this.endMethod("hasUnspentOutputs");
        }
        return false;
    }

    @Override
    public StoredBlock getVerifiedChainHead() throws BlockStoreException {
        return this.verifiedChainHeadBlock;
    }

    @Override
    public void setVerifiedChainHead(StoredBlock chainHead) throws BlockStoreException {
        Sha256Hash hash;
        if (this.instrument) {
            this.beginMethod("setVerifiedChainHead");
        }
        this.verifiedChainHeadHash = hash = chainHead.getHeader().getHash();
        this.verifiedChainHeadBlock = chainHead;
        this.batchPut(this.getKey(KeyType.VERIFIED_CHAIN_HEAD_SETTING), hash.getBytes());
        if (this.chainHeadBlock.getHeight() < chainHead.getHeight()) {
            this.setChainHead(chainHead);
        }
        this.removeUndoableBlocksWhereHeightIsLessThan(chainHead.getHeight() - this.fullStoreDepth);
        if (this.instrument) {
            this.endMethod("setVerifiedChainHead");
        }
    }

    void removeUndoableBlocksWhereHeightIsLessThan(int height) {
        if (height < 0) {
            return;
        }
        DBIterator iterator = this.db.iterator();
        ByteBuffer keyBuf = ByteBuffer.allocate(5);
        keyBuf.put((byte)KeyType.HEIGHT_UNDOABLEBLOCKS.ordinal());
        keyBuf.putInt(height);
        iterator.seek(keyBuf.array());
        while (iterator.hasNext()) {
            byte[] bytekey = (byte[])iterator.peekNext().getKey();
            ByteBuffer buff = ByteBuffer.wrap(bytekey);
            buff.get();
            int keyHeight = buff.getInt();
            byte[] hashbytes = new byte[32];
            buff.get(hashbytes, 4, 28);
            if (keyHeight > height) break;
            this.batchDelete(this.getKey(KeyType.UNDOABLEBLOCKS_ALL, hashbytes));
            this.batchDelete(bytekey);
            iterator.next();
        }
        try {
            iterator.close();
        }
        catch (IOException e) {
            log.error("Error closing iterator", (Throwable)e);
        }
    }

    @Override
    public void beginDatabaseBatchWrite() throws BlockStoreException {
        if (!this.autoCommit) {
            return;
        }
        if (this.instrument) {
            this.beginMethod("beginDatabaseBatchWrite");
        }
        this.batch = this.db.createWriteBatch();
        this.uncommited = new HashMap<ByteBuffer, byte[]>();
        this.uncommitedDeletes = new HashSet<ByteBuffer>();
        this.utxoUncommittedCache = new HashMap<ByteBuffer, UTXO>();
        this.utxoUncommittedDeletedCache = new HashSet<ByteBuffer>();
        this.autoCommit = false;
        if (this.instrument) {
            this.endMethod("beginDatabaseBatchWrite");
        }
    }

    @Override
    public void commitDatabaseBatchWrite() throws BlockStoreException {
        this.uncommited = null;
        this.uncommitedDeletes = null;
        if (this.instrument) {
            this.beginMethod("commitDatabaseBatchWrite");
        }
        this.db.write(this.batch);
        for (Map.Entry<ByteBuffer, UTXO> entry : this.utxoUncommittedCache.entrySet()) {
            this.utxoCache.put(entry.getKey(), entry.getValue());
        }
        this.utxoUncommittedCache = null;
        for (ByteBuffer byteBuffer : this.utxoUncommittedDeletedCache) {
            this.utxoCache.remove(byteBuffer);
        }
        this.utxoUncommittedDeletedCache = null;
        this.autoCommit = true;
        try {
            this.batch.close();
            this.batch = null;
        }
        catch (IOException e) {
            log.error("Error in db commit.", (Throwable)e);
            throw new BlockStoreException("could not close batch.");
        }
        if (this.instrument) {
            this.endMethod("commitDatabaseBatchWrite");
        }
        if (this.instrument && this.verifiedChainHeadBlock.getHeight() % 1000 == 0) {
            log.info("Height: " + this.verifiedChainHeadBlock.getHeight());
            this.dumpStats();
            if (this.verifiedChainHeadBlock.getHeight() == this.exitBlock) {
                System.err.println("Exit due to exitBlock set");
                System.exit(1);
            }
        }
    }

    @Override
    public void abortDatabaseBatchWrite() throws BlockStoreException {
        try {
            this.uncommited = null;
            this.uncommitedDeletes = null;
            this.utxoUncommittedCache = null;
            this.utxoUncommittedDeletedCache = null;
            this.autoCommit = true;
            if (this.batch != null) {
                this.batch.close();
                this.batch = null;
            }
        }
        catch (IOException e) {
            throw new BlockStoreException("could not close batch in abort.", e);
        }
    }

    public void resetStore() {
        try {
            this.db.close();
            this.uncommited = null;
            this.uncommitedDeletes = null;
            this.autoCommit = true;
            this.bloom = new BloomFilter();
            this.utxoCache = new LRUCache(this.openOutCache, 0.75f);
        }
        catch (IOException e) {
            log.error("Exception in resetStore.", (Throwable)e);
        }
        File f = new File(this.filename);
        if (f.isDirectory()) {
            for (File c : f.listFiles()) {
                c.delete();
            }
        }
        this.openDB();
    }

    static enum KeyType {
        CREATED,
        CHAIN_HEAD_SETTING,
        VERIFIED_CHAIN_HEAD_SETTING,
        VERSION_SETTING,
        HEADERS_ALL,
        UNDOABLEBLOCKS_ALL,
        HEIGHT_UNDOABLEBLOCKS,
        OPENOUT_ALL,
        ADDRESS_HASHINDEX;

    }

    private class BloomFilter {
        private byte[] cache = new byte[0x8000000];
        public long returnedTrue;
        public long returnedFalse;
        public long added;

        public void reloadCache(DB db) {
            log.info("Loading Bloom Filter");
            DBIterator iterator = db.iterator();
            byte[] key = LevelDBFullPrunedBlockStore.this.getKey(KeyType.OPENOUT_ALL);
            iterator.seek(key);
            while (iterator.hasNext()) {
                ByteBuffer bbKey = ByteBuffer.wrap((byte[])iterator.peekNext().getKey());
                byte firstByte = bbKey.get();
                if (key[0] != firstByte) {
                    this.printStat();
                    return;
                }
                byte[] hash = new byte[32];
                bbKey.get(hash);
                this.add(hash);
                iterator.next();
            }
            try {
                iterator.close();
            }
            catch (IOException e) {
                log.error("Error closing iterator", (Throwable)e);
            }
            this.printStat();
        }

        public void printStat() {
            log.info("Bloom Added: " + this.added + " T: " + this.returnedTrue + " F: " + this.returnedFalse);
        }

        public void add(byte[] hash) {
            byte[] firstHash = new byte[4];
            ++this.added;
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(hash, i * 4, firstHash, 0, 4);
                this.setBit(firstHash);
            }
        }

        public void add(Sha256Hash hash) {
            this.add(hash.getBytes());
        }

        public boolean wasAdded(Sha256Hash hash) {
            byte[] firstHash = new byte[4];
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(hash.getBytes(), i * 4, firstHash, 0, 4);
                boolean result = this.getBit(firstHash);
                if (result) continue;
                ++this.returnedFalse;
                return false;
            }
            ++this.returnedTrue;
            return true;
        }

        private void setBit(byte[] entry) {
            byte newEntry;
            int arrayIndex = (entry[0] & 0x3F) << 21 | (entry[1] & 0xFF) << 13 | (entry[2] & 0xFF) << 5 | (entry[3] & 0xFF) >> 3;
            int bit = entry[3] & 7;
            int orBit = 1 << bit;
            this.cache[arrayIndex] = newEntry = (byte)(this.cache[arrayIndex] | orBit);
        }

        private boolean getBit(byte[] entry) {
            int arrayIndex = (entry[0] & 0x3F) << 21 | (entry[1] & 0xFF) << 13 | (entry[2] & 0xFF) << 5 | (entry[3] & 0xFF) >> 3;
            byte arrayEntry = this.cache[arrayIndex];
            int bit = entry[3] & 7;
            int orBit = 1 << bit;
            int result = arrayEntry & orBit;
            return result != 0;
        }
    }

    public class LRUCache
    extends LinkedHashMap<ByteBuffer, UTXO> {
        private static final long serialVersionUID = 1L;
        private int capacity;

        public LRUCache(int capacity, float loadFactor) {
            super(capacity, loadFactor, true);
            this.capacity = capacity;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<ByteBuffer, UTXO> eldest) {
            return this.size() > this.capacity;
        }
    }
}

