/*
 * Decompiled with CFR 0.152.
 */
package org.bitcoinj.net.discovery;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bitcoinj.core.NetworkParameters;
import org.bitcoinj.core.Utils;
import org.bitcoinj.core.VersionMessage;
import org.bitcoinj.net.discovery.MultiplexingDiscovery;
import org.bitcoinj.net.discovery.PeerDiscovery;
import org.bitcoinj.net.discovery.PeerDiscoveryException;
import org.bitcoinj.utils.ContextPropagatingThreadFactory;
import org.bitcoinj.utils.DaemonThreadFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DnsDiscovery
extends MultiplexingDiscovery {
    private static final Logger log = LoggerFactory.getLogger(DnsDiscovery.class);

    public DnsDiscovery(NetworkParameters netParams) {
        this(netParams.getDnsSeeds(), netParams);
    }

    public DnsDiscovery(String[] dnsSeeds, NetworkParameters params) {
        super(params, DnsDiscovery.buildDiscoveries(params, dnsSeeds));
    }

    private static List<PeerDiscovery> buildDiscoveries(NetworkParameters params, String[] seeds) {
        ArrayList<PeerDiscovery> discoveries = new ArrayList<PeerDiscovery>();
        if (seeds != null) {
            for (String seed : seeds) {
                discoveries.add(new DnsSeedDiscovery(params, seed));
            }
        }
        return discoveries;
    }

    @Override
    protected ExecutorService createExecutor() {
        if (Utils.isLinux()) {
            return Executors.newSingleThreadExecutor(new ContextPropagatingThreadFactory("DNS seed lookups"));
        }
        return Executors.newFixedThreadPool(this.seeds.size(), new DaemonThreadFactory("DNS seed lookups"));
    }

    public static class DnsSeedDiscovery
    implements PeerDiscovery {
        private final String hostname;
        private final NetworkParameters params;

        public DnsSeedDiscovery(NetworkParameters params, String hostname) {
            this.hostname = hostname;
            this.params = params;
        }

        @Override
        public InetSocketAddress[] getPeers(long services, long timeoutValue, TimeUnit timeoutUnit) throws PeerDiscoveryException {
            InetAddress[] response = null;
            if (services != 0L) {
                String hostnameWithServices = "x" + Long.toHexString(services) + "." + this.hostname;
                log.info("Requesting {} peers from {}", (Object)VersionMessage.toStringServices(services), (Object)hostnameWithServices);
                try {
                    response = InetAddress.getAllByName(hostnameWithServices);
                    log.info("Got {} peers from {}", (Object)response.length, (Object)hostnameWithServices);
                }
                catch (UnknownHostException e) {
                    log.info("Seed {} doesn't appear to support service bit filtering: {}", (Object)this.hostname, (Object)e.getMessage());
                }
            }
            if (response == null || response.length == 0) {
                log.info("Requesting all peers from {}", (Object)this.hostname);
                try {
                    response = InetAddress.getAllByName(this.hostname);
                    log.info("Got {} peers from {}", (Object)response.length, (Object)this.hostname);
                }
                catch (UnknownHostException e) {
                    throw new PeerDiscoveryException(e);
                }
            }
            InetSocketAddress[] result = new InetSocketAddress[response.length];
            for (int i = 0; i < response.length; ++i) {
                result[i] = new InetSocketAddress(response[i], this.params.getPort());
            }
            return result;
        }

        @Override
        public void shutdown() {
        }

        public String toString() {
            return this.hostname;
        }
    }
}

