/*
 * Decompiled with CFR 0.152.
 */
package org.forester.rio;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.forester.datastructures.IntMatrix;
import org.forester.io.parsers.IteratingPhylogenyParser;
import org.forester.io.parsers.PhylogenyParser;
import org.forester.io.parsers.nexus.NexusPhylogeniesParser;
import org.forester.io.parsers.nhx.NHXParser;
import org.forester.io.parsers.util.ParserUtils;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.PhylogenyMethods;
import org.forester.phylogeny.PhylogenyNode;
import org.forester.phylogeny.data.Taxonomy;
import org.forester.phylogeny.factories.ParserBasedPhylogenyFactory;
import org.forester.phylogeny.factories.PhylogenyFactory;
import org.forester.rio.RIOException;
import org.forester.sdi.GSDI;
import org.forester.sdi.GSDIR;
import org.forester.sdi.SDIException;
import org.forester.sdi.SDIR;
import org.forester.sdi.SDIutil;
import org.forester.util.BasicDescriptiveStatistics;
import org.forester.util.ForesterUtil;

public final class RIO {
    public static final int DEFAULT_RANGE = -1;
    private static final int END_OF_GT = Integer.MAX_VALUE;
    private static IntMatrix _m;
    private Phylogeny[] _analyzed_gene_trees;
    private List<PhylogenyNode> _removed_gene_tree_nodes;
    private int _ext_nodes;
    private int _int_nodes;
    private SDIutil.TaxonomyComparisonBase _gsdir_tax_comp_base;
    private final StringBuilder _log;
    private final BasicDescriptiveStatistics _duplications_stats;
    private final boolean _produce_log;
    private final boolean _verbose;
    private final REROOTING _rerooting;
    private final Phylogeny _species_tree;
    private Phylogeny _min_dub_gene_tree;

    private RIO(IteratingPhylogenyParser p, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, int first, int last, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        if (last == -1 && first >= 0) {
            last = Integer.MAX_VALUE;
        } else if (first == -1 && last >= 0) {
            first = 0;
        }
        RIO.removeSingleDescendentsNodes(species_tree, verbose);
        p.reset();
        RIO.checkPreconditions(p, species_tree, rerooting, outgroup, first, last);
        this._produce_log = produce_log;
        this._verbose = verbose;
        this._rerooting = rerooting;
        this._ext_nodes = -1;
        this._int_nodes = -1;
        this._log = new StringBuilder();
        this._gsdir_tax_comp_base = null;
        this._analyzed_gene_trees = null;
        this._removed_gene_tree_nodes = null;
        this._duplications_stats = new BasicDescriptiveStatistics();
        p.reset();
        this.inferOrthologs(p, species_tree, algorithm, outgroup, first, last, transfer_taxonomy);
        this._species_tree = species_tree;
    }

    private RIO(Phylogeny[] gene_trees, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, int first, int last, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        if (last == -1 && first >= 0) {
            last = gene_trees.length - 1;
        } else if (first == -1 && last >= 0) {
            first = 0;
        }
        RIO.removeSingleDescendentsNodes(species_tree, verbose);
        RIO.checkPreconditions(gene_trees, species_tree, rerooting, outgroup, first, last);
        this._produce_log = produce_log;
        this._verbose = verbose;
        this._rerooting = rerooting;
        this._ext_nodes = -1;
        this._int_nodes = -1;
        this._log = new StringBuilder();
        this._gsdir_tax_comp_base = null;
        this._analyzed_gene_trees = null;
        this._removed_gene_tree_nodes = null;
        this._duplications_stats = new BasicDescriptiveStatistics();
        this.inferOrthologs(gene_trees, species_tree, algorithm, outgroup, first, last, transfer_taxonomy);
        this._species_tree = species_tree;
    }

    public final Phylogeny[] getAnalyzedGeneTrees() {
        return this._analyzed_gene_trees;
    }

    public final BasicDescriptiveStatistics getDuplicationsStatistics() {
        return this._duplications_stats;
    }

    public final int getExtNodesOfAnalyzedGeneTrees() {
        return this._ext_nodes;
    }

    public final SDIutil.TaxonomyComparisonBase getGSDIRtaxCompBase() {
        return this._gsdir_tax_comp_base;
    }

    public final int getIntNodesOfAnalyzedGeneTrees() {
        return this._int_nodes;
    }

    public final StringBuilder getLog() {
        return this._log;
    }

    public final Phylogeny getMinDuplicationsGeneTree() {
        return this._min_dub_gene_tree;
    }

    public final IntMatrix getOrthologTable() {
        return _m;
    }

    public final List<PhylogenyNode> getRemovedGeneTreeNodes() {
        return this._removed_gene_tree_nodes;
    }

    public final Phylogeny getSpeciesTree() {
        return this._species_tree;
    }

    private final void inferOrthologs(IteratingPhylogenyParser parser, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, String outgroup, int first, int last, boolean transfer_taxonomy) throws SDIException, RIOException, FileNotFoundException, IOException {
        boolean no_range;
        if (!parser.hasNext()) {
            throw new RIOException("no gene trees to analyze");
        }
        if (this.log()) {
            this.preLog(-1, species_tree, algorithm, outgroup);
        }
        if (this._verbose) {
            System.out.println();
        }
        DecimalFormat pf = new DecimalFormat("000");
        int gene_tree_ext_nodes = 0;
        int i = 0;
        int counter = 0;
        boolean bl = no_range = first < 0 || last < first;
        while (parser.hasNext()) {
            Phylogeny gt = parser.next();
            if (no_range || i >= first && i <= last) {
                if (gt.isEmpty()) {
                    throw new RIOException("gene tree #" + i + " is empty");
                }
                if (gt.getNumberOfExternalNodes() == 1) {
                    throw new RIOException("gene tree #" + i + " has only one external node");
                }
                if (this._verbose) {
                    ForesterUtil.updateProgress(i, pf);
                }
                if (counter == 0) {
                    if (algorithm == SDIutil.ALGORITHM.SDIR) {
                        PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(gt, species_tree);
                        if (species_tree.isEmpty()) {
                            throw new RIOException("failed to establish species based mapping between gene and species trees");
                        }
                    }
                    gene_tree_ext_nodes = gt.getNumberOfExternalNodes();
                } else if (gene_tree_ext_nodes != gt.getNumberOfExternalNodes()) {
                    throw new RIOException("gene tree #" + i + " has a different number of external nodes (" + gt.getNumberOfExternalNodes() + ") than the preceding gene tree(s) (" + gene_tree_ext_nodes + ")");
                }
                if (algorithm == SDIutil.ALGORITHM.SDIR) {
                    PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(species_tree, gt);
                    if (gt.isEmpty()) {
                        throw new RIOException("failed to establish species based mapping between gene and species trees");
                    }
                }
                Phylogeny analyzed_gt = this.performOrthologInference(gt, species_tree, algorithm, outgroup, counter, transfer_taxonomy);
                RIO.calculateOrthologTable(analyzed_gt, true, counter);
                ++counter;
            }
            ++i;
        }
        if (first >= 0 && counter == 0 && i > 0) {
            throw new RIOException("attempt to analyze first gene tree #" + first + " in a set of " + i);
        }
        if (no_range) {
            first = 0;
        }
        if (this.log()) {
            this.postLog(species_tree, first, first + counter - 1);
        }
        if (this._verbose) {
            System.out.println();
            System.out.println();
        }
    }

    private final void inferOrthologs(Phylogeny[] gene_trees, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, String outgroup, int first, int last, boolean transfer_taxonomy) throws SDIException, RIOException, FileNotFoundException, IOException {
        int i;
        Phylogeny[] my_gene_trees;
        if (algorithm == SDIutil.ALGORITHM.SDIR) {
            PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(gene_trees[0], species_tree);
            if (species_tree.isEmpty()) {
                throw new RIOException("failed to establish species based mapping between gene and species trees");
            }
        }
        if (first >= 0 && last >= first && last < gene_trees.length) {
            my_gene_trees = new Phylogeny[1 + last - first];
            int c = 0;
            for (i = first; i <= last; ++i) {
                my_gene_trees[c++] = gene_trees[i];
            }
        } else {
            my_gene_trees = gene_trees;
        }
        if (this.log()) {
            this.preLog(gene_trees.length, species_tree, algorithm, outgroup);
        }
        if (this._verbose && my_gene_trees.length >= 4) {
            System.out.println();
        }
        this._analyzed_gene_trees = new Phylogeny[my_gene_trees.length];
        int gene_tree_ext_nodes = 0;
        for (i = 0; i < my_gene_trees.length; ++i) {
            Phylogeny gt = my_gene_trees[i];
            if (gt.isEmpty()) {
                throw new RIOException("gene tree #" + i + " is empty");
            }
            if (gt.getNumberOfExternalNodes() == 1) {
                throw new RIOException("gene tree #" + i + " has only one external node");
            }
            if (this._verbose && my_gene_trees.length > 4) {
                ForesterUtil.updateProgress((double)i / (double)my_gene_trees.length);
            }
            if (i == 0) {
                gene_tree_ext_nodes = gt.getNumberOfExternalNodes();
            } else if (gene_tree_ext_nodes != gt.getNumberOfExternalNodes()) {
                throw new RIOException("gene tree #" + i + " has a different number of external nodes (" + gt.getNumberOfExternalNodes() + ") than the preceding gene tree(s) (" + gene_tree_ext_nodes + ")");
            }
            if (algorithm == SDIutil.ALGORITHM.SDIR) {
                PhylogenyMethods.taxonomyBasedDeletionOfExternalNodes(species_tree, gt);
                if (gt.isEmpty()) {
                    throw new RIOException("failed to establish species based mapping between gene and species trees");
                }
            }
            this._analyzed_gene_trees[i] = this.performOrthologInference(gt, species_tree, algorithm, outgroup, i, transfer_taxonomy);
        }
        if (this.log()) {
            this.postLog(species_tree, first, last);
        }
        if (this._verbose && my_gene_trees.length > 4) {
            System.out.println();
            System.out.println();
        }
    }

    private final boolean log() {
        return this._produce_log;
    }

    private final void log(String s) {
        this._log.append(s);
        this._log.append(ForesterUtil.LINE_SEPARATOR);
    }

    private final void logRemovedGeneTreeNodes() {
        this.log("Species stripped from gene trees:");
        TreeSet<String> rn = new TreeSet<String>();
        for (PhylogenyNode n : this.getRemovedGeneTreeNodes()) {
            Taxonomy t = n.getNodeData().getTaxonomy();
            switch (this.getGSDIRtaxCompBase()) {
                case CODE: {
                    rn.add(t.getTaxonomyCode());
                    break;
                }
                case ID: {
                    rn.add(t.getIdentifier().toString());
                    break;
                }
                case SCIENTIFIC_NAME: {
                    rn.add(t.getScientificName());
                }
            }
        }
        for (String s : rn) {
            this.log(s);
        }
        this.log("");
    }

    private final Phylogeny performOrthologInference(Phylogeny gene_tree, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, String outgroup, int i, boolean transfer_taxonomy) throws SDIException, RIOException {
        Phylogeny assigned_tree;
        switch (algorithm) {
            case SDIR: {
                assigned_tree = this.performOrthologInferenceBySDI(gene_tree, species_tree);
                break;
            }
            case GSDIR: {
                assigned_tree = this.performOrthologInferenceByGSDI(gene_tree, species_tree, outgroup, i, transfer_taxonomy);
                break;
            }
            default: {
                throw new IllegalArgumentException("illegal algorithm: " + (Object)((Object)algorithm));
            }
        }
        if (i == 0) {
            this._ext_nodes = assigned_tree.getNumberOfExternalNodes();
            this._int_nodes = assigned_tree.getNumberOfInternalNodes();
        } else if (this._ext_nodes != assigned_tree.getNumberOfExternalNodes()) {
            throw new RIOException("after stripping gene tree #" + i + " has a different number of external nodes (" + assigned_tree.getNumberOfExternalNodes() + ") than the preceding gene tree(s) (" + this._ext_nodes + ")");
        }
        return assigned_tree;
    }

    private final Phylogeny performOrthologInferenceByGSDI(Phylogeny gene_tree, Phylogeny species_tree, String outgroup, int i, boolean transfer_taxonomy) throws SDIException, RIOException {
        int dups;
        Phylogeny assigned_tree;
        if (this._rerooting == REROOTING.BY_ALGORITHM) {
            GSDIR gsdir = new GSDIR(gene_tree, species_tree, true, i == 0, transfer_taxonomy);
            assigned_tree = gsdir.getMinDuplicationsSumGeneTree();
            if (i == 0) {
                this._removed_gene_tree_nodes = gsdir.getStrippedExternalGeneTreeNodes();
                for (PhylogenyNode r : this._removed_gene_tree_nodes) {
                    if (r.getNodeData().isHasTaxonomy()) continue;
                    throw new RIOException("node with no (appropriate) taxonomic information found in gene tree #" + i + ": " + r.toString());
                }
            }
            if (i == 0) {
                this._gsdir_tax_comp_base = gsdir.getTaxCompBase();
            }
            dups = gsdir.getMinDuplicationsSum();
        } else {
            if (this._rerooting == REROOTING.MIDPOINT) {
                PhylogenyMethods.midpointRoot(gene_tree);
            } else if (this._rerooting == REROOTING.OUTGROUP) {
                PhylogenyNode n = gene_tree.getNode(outgroup);
                gene_tree.reRoot(n);
            }
            GSDI gsdi2 = new GSDI(gene_tree, species_tree, true, true, true, transfer_taxonomy);
            this._removed_gene_tree_nodes = gsdi2.getStrippedExternalGeneTreeNodes();
            for (PhylogenyNode r : this._removed_gene_tree_nodes) {
                if (r.getNodeData().isHasTaxonomy()) continue;
                throw new RIOException("node with no (appropriate) taxonomic information found in gene tree #" + i + ": " + r.toString());
            }
            assigned_tree = gene_tree;
            if (i == 0) {
                this._gsdir_tax_comp_base = gsdi2.getTaxCompBase();
            }
            dups = gsdi2.getDuplicationsSum();
        }
        if (i == 0 || (double)dups < this._duplications_stats.getMin()) {
            this._min_dub_gene_tree = assigned_tree;
        }
        this._duplications_stats.addValue(dups);
        return assigned_tree;
    }

    private final Phylogeny performOrthologInferenceBySDI(Phylogeny gene_tree, Phylogeny species_tree) throws SDIException {
        SDIR sdir = new SDIR();
        return sdir.infer(gene_tree, species_tree, false, true, true, true, 1)[0];
    }

    private final void postLog(Phylogeny species_tree, int first, int last) {
        this.log("");
        if (this.getRemovedGeneTreeNodes() != null && this.getRemovedGeneTreeNodes().size() > 0) {
            this.logRemovedGeneTreeNodes();
        }
        this.log("Species tree external nodes (after stripping)   : " + species_tree.getNumberOfExternalNodes());
        this.log("Species tree polytomies (after stripping)       : " + PhylogenyMethods.countNumberOfPolytomies(species_tree));
        this.log("Taxonomy linking based on                       : " + (Object)((Object)this.getGSDIRtaxCompBase()));
        DecimalFormat df = new DecimalFormat("0.#");
        if (first >= 0 && last >= 0) {
            this.log("Gene trees analyzed range                       : " + first + "-" + last);
        }
        this.log("Gene trees analyzed                             : " + this._duplications_stats.getN());
        this.log("Mean number of duplications                     : " + df.format(this._duplications_stats.arithmeticMean()) + " (sd: " + df.format(this._duplications_stats.sampleStandardDeviation()) + ") (" + df.format(100.0 * this._duplications_stats.arithmeticMean() / (double)this.getIntNodesOfAnalyzedGeneTrees()) + "%)");
        if (this._duplications_stats.getN() > 3) {
            this.log("Median number of duplications                   : " + df.format(this._duplications_stats.median()) + " (" + df.format(100.0 * this._duplications_stats.median() / (double)this.getIntNodesOfAnalyzedGeneTrees()) + "%)");
        }
        this.log("Minimum duplications                            : " + (int)this._duplications_stats.getMin() + " (" + df.format(100.0 * this._duplications_stats.getMin() / (double)this.getIntNodesOfAnalyzedGeneTrees()) + "%)");
        this.log("Maximum duplications                            : " + (int)this._duplications_stats.getMax() + " (" + df.format(100.0 * this._duplications_stats.getMax() / (double)this.getIntNodesOfAnalyzedGeneTrees()) + "%)");
        this.log("Gene tree internal nodes                        : " + this.getIntNodesOfAnalyzedGeneTrees());
        this.log("Gene tree external nodes                        : " + this.getExtNodesOfAnalyzedGeneTrees());
    }

    private final void preLog(int gene_trees, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, String outgroup) {
        if (gene_trees > 0) {
            this.log("Number of gene trees (total)                    : " + gene_trees);
        }
        this.log("Algorithm                                       : " + (Object)((Object)algorithm));
        this.log("Species tree external nodes (prior to stripping): " + species_tree.getNumberOfExternalNodes());
        this.log("Species tree polytomies (prior to stripping)    : " + PhylogenyMethods.countNumberOfPolytomies(species_tree));
        String rs = "";
        switch (this._rerooting) {
            case BY_ALGORITHM: {
                rs = "minimizing duplications";
                break;
            }
            case MIDPOINT: {
                rs = "midpoint";
                break;
            }
            case OUTGROUP: {
                rs = "outgroup: " + outgroup;
                break;
            }
            case NONE: {
                rs = "none";
            }
        }
        this.log("Re-rooting                                      : " + rs);
    }

    public static final IntMatrix calculateOrthologTable(Phylogeny[] analyzed_gene_trees, boolean sort) throws RIOException {
        ArrayList<String> labels = new ArrayList<String>();
        HashSet<String> labels_set = new HashSet<String>();
        for (PhylogenyNode n : analyzed_gene_trees[0].getExternalNodes()) {
            String label = RIO.obtainLabel(labels_set, n);
            labels_set.add(label);
            labels.add(label);
        }
        if (sort) {
            Collections.sort(labels);
        }
        IntMatrix m = new IntMatrix(labels);
        int counter = 0;
        for (Phylogeny gt : analyzed_gene_trees) {
            RIO.updateCounts(m, ++counter, gt);
        }
        return m;
    }

    public static final RIO executeAnalysis(File gene_trees_file, File species_tree_file, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, int first, int last, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        Phylogeny[] gene_trees = RIO.parseGeneTrees(gene_trees_file);
        if (gene_trees.length < 1) {
            throw new RIOException("\"" + gene_trees_file + "\" is devoid of appropriate gene trees");
        }
        Phylogeny species_tree = SDIutil.parseSpeciesTree(gene_trees[0], species_tree_file, false, true, NHXParser.TAXONOMY_EXTRACTION.NO);
        return new RIO(gene_trees, species_tree, algorithm, rerooting, outgroup, first, last, produce_log, verbose, transfer_taxonomy);
    }

    public static final RIO executeAnalysis(File gene_trees_file, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        return new RIO(RIO.parseGeneTrees(gene_trees_file), species_tree, algorithm, rerooting, outgroup, -1, -1, produce_log, verbose, transfer_taxonomy);
    }

    public static final RIO executeAnalysis(File gene_trees_file, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, int first, int last, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        return new RIO(RIO.parseGeneTrees(gene_trees_file), species_tree, algorithm, rerooting, outgroup, first, last, produce_log, verbose, transfer_taxonomy);
    }

    public static final RIO executeAnalysis(IteratingPhylogenyParser p, File species_tree_file, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, int first, int last, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        Phylogeny g0 = p.next();
        if (g0 == null || g0.isEmpty() || g0.getNumberOfExternalNodes() < 2) {
            throw new RIOException("input file does not seem to contain any gene trees");
        }
        Phylogeny species_tree = SDIutil.parseSpeciesTree(g0, species_tree_file, false, true, NHXParser.TAXONOMY_EXTRACTION.NO);
        p.reset();
        return new RIO(p, species_tree, algorithm, rerooting, outgroup, first, last, produce_log, verbose, transfer_taxonomy);
    }

    public static final RIO executeAnalysis(IteratingPhylogenyParser p, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        return new RIO(p, species_tree, algorithm, rerooting, outgroup, -1, -1, produce_log, verbose, transfer_taxonomy);
    }

    public static final RIO executeAnalysis(IteratingPhylogenyParser p, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, int first, int last, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        return new RIO(p, species_tree, algorithm, rerooting, outgroup, first, last, produce_log, verbose, transfer_taxonomy);
    }

    public static final RIO executeAnalysis(Phylogeny[] gene_trees, Phylogeny species_tree) throws IOException, SDIException, RIOException {
        return new RIO(gene_trees, species_tree, SDIutil.ALGORITHM.GSDIR, REROOTING.BY_ALGORITHM, null, -1, -1, false, false, false);
    }

    public static final RIO executeAnalysis(Phylogeny[] gene_trees, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        return new RIO(gene_trees, species_tree, algorithm, rerooting, outgroup, -1, -1, produce_log, verbose, transfer_taxonomy);
    }

    public static final RIO executeAnalysis(Phylogeny[] gene_trees, Phylogeny species_tree, SDIutil.ALGORITHM algorithm, REROOTING rerooting, String outgroup, int first, int last, boolean produce_log, boolean verbose, boolean transfer_taxonomy) throws IOException, SDIException, RIOException {
        return new RIO(gene_trees, species_tree, algorithm, rerooting, outgroup, first, last, produce_log, verbose, transfer_taxonomy);
    }

    private static final void calculateOrthologTable(Phylogeny g, boolean sort, int counter) throws RIOException {
        if (counter == 0) {
            ArrayList<String> labels = new ArrayList<String>();
            HashSet<String> labels_set = new HashSet<String>();
            for (PhylogenyNode n : g.getExternalNodes()) {
                String label = RIO.obtainLabel(labels_set, n);
                labels_set.add(label);
                labels.add(label);
            }
            if (sort) {
                Collections.sort(labels);
            }
            _m = new IntMatrix(labels);
        }
        RIO.updateCounts(_m, counter, g);
    }

    private static final void checkPreconditions(IteratingPhylogenyParser p, Phylogeny species_tree, REROOTING rerooting, String outgroup, int first, int last) throws RIOException, IOException {
        Phylogeny g0 = p.next();
        if (g0 == null || g0.isEmpty()) {
            throw new RIOException("input file does not seem to contain any gene trees");
        }
        if (g0.getNumberOfExternalNodes() < 2) {
            throw new RIOException("input file does not seem to contain any useable gene trees");
        }
        if (!species_tree.isRooted()) {
            throw new RIOException("species tree is not rooted");
        }
        if (!(last == -1 && first == -1 || last >= first && last >= 0 && first >= 0)) {
            throw new RIOException("attempt to set range (0-based) of gene to analyze to: from " + first + " to " + last);
        }
        if (rerooting == REROOTING.OUTGROUP && ForesterUtil.isEmpty(outgroup)) {
            throw new RIOException("outgroup not set for midpoint rooting");
        }
        if (rerooting != REROOTING.OUTGROUP && !ForesterUtil.isEmpty(outgroup)) {
            throw new RIOException("outgroup only used for midpoint rooting");
        }
        if (rerooting == REROOTING.MIDPOINT && PhylogenyMethods.calculateMaxDistanceToRoot(g0) <= 0.0) {
            throw new RIOException("attempt to use midpoint rooting on gene trees which seem to have no (positive) branch lengths (cladograms)");
        }
        if (rerooting == REROOTING.OUTGROUP) {
            try {
                g0.getNode(outgroup);
            }
            catch (IllegalArgumentException e) {
                throw new RIOException("cannot perform re-rooting by outgroup: " + e.getLocalizedMessage());
            }
        }
    }

    private static final void checkPreconditions(Phylogeny[] gene_trees, Phylogeny species_tree, REROOTING rerooting, String outgroup, int first, int last) throws RIOException {
        if (!species_tree.isRooted()) {
            throw new RIOException("species tree is not rooted");
        }
        if (!(last == -1 && first == -1 || last >= first && last < gene_trees.length && last >= 0 && first >= 0)) {
            throw new RIOException("attempt to set range (0-based) of gene to analyze to: from " + first + " to " + last + " (out of " + gene_trees.length + ")");
        }
        if (rerooting == REROOTING.OUTGROUP && ForesterUtil.isEmpty(outgroup)) {
            throw new RIOException("outgroup not set for midpoint rooting");
        }
        if (rerooting != REROOTING.OUTGROUP && !ForesterUtil.isEmpty(outgroup)) {
            throw new RIOException("outgroup only used for midpoint rooting");
        }
        if (rerooting == REROOTING.MIDPOINT && PhylogenyMethods.calculateMaxDistanceToRoot(gene_trees[0]) <= 0.0) {
            throw new RIOException("attempt to use midpoint rooting on gene trees which seem to have no (positive) branch lengths (cladograms)");
        }
        if (rerooting == REROOTING.OUTGROUP) {
            try {
                gene_trees[0].getNode(outgroup);
            }
            catch (IllegalArgumentException e) {
                throw new RIOException("cannot perform re-rooting by outgroup: " + e.getLocalizedMessage());
            }
        }
    }

    private static final String obtainLabel(Set<String> labels_set, PhylogenyNode n) throws RIOException {
        String label;
        if (n.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(n.getNodeData().getSequence().getName())) {
            label = n.getNodeData().getSequence().getName();
        } else if (n.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(n.getNodeData().getSequence().getSymbol())) {
            label = n.getNodeData().getSequence().getSymbol();
        } else if (n.getNodeData().isHasSequence() && !ForesterUtil.isEmpty(n.getNodeData().getSequence().getGeneName())) {
            label = n.getNodeData().getSequence().getGeneName();
        } else if (!ForesterUtil.isEmpty(n.getName())) {
            label = n.getName();
        } else {
            throw new RIOException("node " + n + " has no appropriate label");
        }
        if (labels_set.contains(label)) {
            throw new RIOException("label " + label + " is not unique");
        }
        return label;
    }

    private static final Phylogeny[] parseGeneTrees(File gene_trees_file) throws FileNotFoundException, IOException {
        PhylogenyFactory factory = ParserBasedPhylogenyFactory.getInstance();
        PhylogenyParser p = ParserUtils.createParserDependingOnFileType(gene_trees_file, true);
        if (p instanceof NHXParser) {
            NHXParser nhx = (NHXParser)p;
            nhx.setReplaceUnderscores(false);
            nhx.setIgnoreQuotes(true);
            nhx.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        } else if (p instanceof NexusPhylogeniesParser) {
            NexusPhylogeniesParser nex = (NexusPhylogeniesParser)p;
            nex.setReplaceUnderscores(false);
            nex.setIgnoreQuotes(true);
            nex.setTaxonomyExtraction(NHXParser.TAXONOMY_EXTRACTION.AGGRESSIVE);
        }
        return factory.create(gene_trees_file, p);
    }

    private static final void removeSingleDescendentsNodes(Phylogeny species_tree, boolean verbose) {
        int o = PhylogenyMethods.countNumberOfOneDescendantNodes(species_tree);
        if (o > 0) {
            if (verbose) {
                System.out.println("warning: species tree has " + o + " internal nodes with only one descendent which are therefore going to be removed");
            }
            PhylogenyMethods.deleteInternalNodesWithOnlyOneDescendent(species_tree);
        }
    }

    private static final void updateCounts(IntMatrix m, int counter, Phylogeny g) throws RIOException {
        PhylogenyMethods.preOrderReId(g);
        HashMap<String, PhylogenyNode> map = PhylogenyMethods.createNameToExtNodeMap(g);
        for (int x = 0; x < m.size(); ++x) {
            String mx = m.getLabel(x);
            PhylogenyNode nx = map.get(mx);
            if (nx == null) {
                throw new RIOException("node \"" + mx + "\" not present in gene tree #" + counter);
            }
            for (int y = 0; y < m.size(); ++y) {
                String my = m.getLabel(y);
                PhylogenyNode ny = map.get(my);
                if (ny == null) {
                    throw new RIOException("node \"" + my + "\" not present in gene tree #" + counter);
                }
                if (PhylogenyMethods.calculateLCAonTreeWithIdsInPreOrder(nx, ny).isDuplication()) continue;
                m.inreaseByOne(x, y);
            }
        }
    }

    public static enum REROOTING {
        NONE,
        BY_ALGORITHM,
        MIDPOINT,
        OUTGROUP;

    }
}

