/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.util.HashMap;
import java.util.Map;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.PhyloXmlHandler;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.ConfidenceParser;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.Phylogeny;
import org.forester.phylogeny.data.Confidence;
import org.forester.phylogeny.data.Sequence;
import org.forester.phylogeny.data.SequenceRelation;

public class SequenceRelationParser
implements PhylogenyDataPhyloXmlParser {
    private static final Map<Phylogeny, SequenceRelationParser> _instances = new HashMap<Phylogeny, SequenceRelationParser>();
    private Phylogeny _phylogeny;

    private SequenceRelationParser() {
    }

    @Override
    public SequenceRelation parse(XmlElement element) throws PhyloXmlDataFormatException {
        Sequence ref;
        SequenceRelation seqRelation = new SequenceRelation();
        if (element.isHasAttribute("type")) {
            String sType = element.getAttribute("type");
            seqRelation.setType(SequenceRelation.SEQUENCE_RELATION_TYPE.valueOf(sType));
        }
        if (element.isHasAttribute("id_ref_0") && this._phylogeny != null && (ref = PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this._phylogeny).get(element.getAttribute("id_ref_0"))) != null) {
            seqRelation.setRef0(ref);
        }
        if (element.isHasAttribute("id_ref_1") && this._phylogeny != null && (ref = PhyloXmlHandler.getSequenceMapByIdForPhylogeny(this._phylogeny).get(element.getAttribute("id_ref_1"))) != null) {
            seqRelation.setRef1(ref);
        }
        if (element.isHasAttribute("distance")) {
            seqRelation.setDistance(Double.valueOf(element.getAttribute("distance")));
        }
        for (int i = 0; i < element.getNumberOfChildElements(); ++i) {
            XmlElement child_element = element.getChildElement(i);
            if (!child_element.getQualifiedName().equals("confidence")) continue;
            seqRelation.setConfidence((Confidence)ConfidenceParser.getInstance().parse(child_element));
        }
        return seqRelation;
    }

    public static PhylogenyDataPhyloXmlParser getInstance(Phylogeny phylogeny) {
        SequenceRelationParser instance = _instances.get(phylogeny);
        if (instance == null) {
            instance = new SequenceRelationParser();
            instance._phylogeny = phylogeny;
            _instances.put(phylogeny, instance);
        }
        return instance;
    }
}

