/*
 * Decompiled with CFR 0.152.
 */
package org.forester.io.parsers.phyloxml.data;

import java.util.SortedSet;
import java.util.TreeSet;
import org.forester.io.parsers.phyloxml.PhyloXmlDataFormatException;
import org.forester.io.parsers.phyloxml.XmlElement;
import org.forester.io.parsers.phyloxml.data.PhylogenyDataPhyloXmlParser;
import org.forester.phylogeny.data.BinaryCharacters;
import org.forester.phylogeny.data.PhylogenyData;

public class BinaryCharactersParser
implements PhylogenyDataPhyloXmlParser {
    private static final BinaryCharactersParser _instance;

    private BinaryCharactersParser() {
    }

    @Override
    public PhylogenyData parse(XmlElement element) throws PhyloXmlDataFormatException {
        TreeSet<String> present = new TreeSet<String>();
        TreeSet<String> gained = new TreeSet<String>();
        TreeSet<String> lost = new TreeSet<String>();
        String type = "";
        int present_count = -1;
        int gained_count = -1;
        int lost_count = -1;
        if (element.isHasAttribute("type")) {
            type = element.getAttribute("type");
        }
        try {
            if (element.isHasAttribute("present_count")) {
                present_count = Integer.parseInt(element.getAttribute("present_count"));
            }
            if (element.isHasAttribute("gained_count")) {
                gained_count = Integer.parseInt(element.getAttribute("gained_count"));
            }
            if (element.isHasAttribute("lost_count")) {
                lost_count = Integer.parseInt(element.getAttribute("lost_count"));
            }
        }
        catch (NumberFormatException e) {
            throw new PhyloXmlDataFormatException("failed to parse integer from element " + element.getQualifiedName());
        }
        for (int i = 0; i < element.getNumberOfChildElements(); ++i) {
            XmlElement child_element = element.getChildElement(i);
            if (child_element.getQualifiedName().equals("present")) {
                this.parseCharacters(present, child_element);
                continue;
            }
            if (child_element.getQualifiedName().equals("gained")) {
                this.parseCharacters(gained, child_element);
                continue;
            }
            if (!child_element.getQualifiedName().equals("lost")) continue;
            this.parseCharacters(lost, child_element);
        }
        BinaryCharacters bc = null;
        bc = present_count != -1 ? new BinaryCharacters(present, gained, lost, type, present_count, gained_count, lost_count) : new BinaryCharacters(present, gained, lost, type);
        return bc;
    }

    private void parseCharacters(SortedSet<String> present, XmlElement child_element) {
        for (int j = 0; j < child_element.getNumberOfChildElements(); ++j) {
            XmlElement child_child_element = child_element.getChildElement(j);
            if (!child_child_element.getQualifiedName().equals("bc")) continue;
            present.add(child_child_element.getValueAsString());
        }
    }

    public static PhylogenyDataPhyloXmlParser getInstance() {
        return _instance;
    }

    static {
        try {
            _instance = new BinaryCharactersParser();
        }
        catch (Throwable e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

