/*
 * Decompiled with CFR 0.152.
 */
package org.forester.go;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.forester.go.BasicGoRelationship;
import org.forester.go.BasicGoSubset;
import org.forester.go.BasicGoTerm;
import org.forester.go.BasicGoXRef;
import org.forester.go.GoId;
import org.forester.go.GoRelationship;
import org.forester.go.GoSubset;
import org.forester.go.GoTerm;
import org.forester.go.GoXRef;
import org.forester.util.ForesterUtil;

public class OBOparser {
    private final File _input_file;
    private final ReturnType _return_type;
    private int _go_term_count;

    public OBOparser(File input_file, ReturnType return_type) {
        switch (return_type) {
            case BASIC_GO_TERM: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown return type: " + (Object)((Object)return_type));
            }
        }
        this._input_file = input_file;
        this._return_type = return_type;
        this.init();
    }

    private GoTerm createNewBasicGoTerm(String id, String name, String namespace, String is_obsolete, String comment, String definition, Set<String> alt_ids, List<GoXRef> go_xrefs, List<GoId> super_go_ids, List<GoRelationship> go_relationships, List<GoSubset> go_subsets) {
        BasicGoTerm gt = new BasicGoTerm(id, name, namespace, is_obsolete.trim().toLowerCase().equals("true"));
        gt.setComment(comment);
        gt.setDefinition(definition);
        for (GoXRef x : go_xrefs) {
            gt.getGoXRefs().add(x);
        }
        for (GoId s : super_go_ids) {
            gt.getSuperGoIds().add(s);
        }
        for (GoRelationship r : go_relationships) {
            gt.getGoRelationships().add(r);
        }
        for (GoSubset sub : go_subsets) {
            gt.getGoSubsets().add(sub);
        }
        for (String alt_id : alt_ids) {
            gt.getAltIds().add(new GoId(alt_id));
        }
        ++this._go_term_count;
        return gt;
    }

    private void createNewGoTerm(List<GoTerm> go_terms, String id, String name, String namespace, String is_obsolete, String comment, String definition, Set<String> alt_ids, List<GoXRef> go_xrefs, List<GoId> super_go_ids, List<GoRelationship> go_relationships, List<GoSubset> go_subsets) {
        GoTerm gt;
        switch (this.getReturnType()) {
            case BASIC_GO_TERM: {
                gt = this.createNewBasicGoTerm(id, name, namespace, is_obsolete, comment, definition, alt_ids, go_xrefs, super_go_ids, go_relationships, go_subsets);
                break;
            }
            default: {
                throw new AssertionError((Object)("unknown return type: " + (Object)((Object)this.getReturnType())));
            }
        }
        go_terms.add(gt);
    }

    public int getGoTermCount() {
        return this._go_term_count;
    }

    private File getInputFile() {
        return this._input_file;
    }

    private ReturnType getReturnType() {
        return this._return_type;
    }

    private void init() {
        this.setGoTermCount(0);
    }

    public List<GoTerm> parse() throws IOException {
        String error = ForesterUtil.isReadableFile(this.getInputFile());
        if (!ForesterUtil.isEmpty(error)) {
            throw new IOException(error);
        }
        BufferedReader br = new BufferedReader(new FileReader(this.getInputFile()));
        ArrayList<GoTerm> go_terms = new ArrayList<GoTerm>();
        int line_number = 0;
        boolean in_term = false;
        String id = "";
        String name = "";
        String namespace = "";
        String def = "";
        String comment = "";
        String is_obsolete = "";
        HashSet<String> alt_ids = new HashSet<String>();
        ArrayList<GoId> super_go_ids = new ArrayList<GoId>();
        ArrayList<GoXRef> go_xrefs = new ArrayList<GoXRef>();
        ArrayList<GoRelationship> go_relationships = new ArrayList<GoRelationship>();
        ArrayList<GoSubset> go_subsets = new ArrayList<GoSubset>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                String s;
                ++line_number;
                if ((line = line.trim()).length() < 1) {
                    if (!in_term) continue;
                    in_term = false;
                    continue;
                }
                if (line.startsWith("[Term]")) {
                    in_term = true;
                    if (id.length() > 0) {
                        this.createNewGoTerm(go_terms, id, name, namespace, is_obsolete, comment, def, alt_ids, go_xrefs, super_go_ids, go_relationships, go_subsets);
                    }
                    id = "";
                    name = "";
                    namespace = "";
                    alt_ids = new HashSet();
                    def = "";
                    comment = "";
                    is_obsolete = "";
                    super_go_ids = new ArrayList();
                    go_xrefs = new ArrayList();
                    go_relationships = new ArrayList();
                    go_subsets = new ArrayList();
                    continue;
                }
                if (in_term && line.startsWith("id:")) {
                    id = line.substring(3).trim();
                    continue;
                }
                if (in_term && line.startsWith("name:")) {
                    name = line.substring(5).trim();
                    continue;
                }
                if (in_term && line.startsWith("namespace:")) {
                    namespace = line.substring(10).trim();
                    continue;
                }
                if (in_term && line.startsWith("alt_id:")) {
                    alt_ids.add(line.substring(7).trim());
                    continue;
                }
                if (in_term && line.startsWith("def:")) {
                    def = line.substring(4).trim();
                    continue;
                }
                if (in_term && line.startsWith("is_obsolete:")) {
                    is_obsolete = line.substring(12).trim();
                    continue;
                }
                if (in_term && line.startsWith("comment:")) {
                    comment = line.substring(8).trim();
                    continue;
                }
                if (in_term && line.startsWith("xref:")) {
                    s = this.trimOffComment(line.substring(5).trim());
                    go_xrefs.add(new BasicGoXRef(s));
                    continue;
                }
                if (in_term && line.startsWith("is_a:")) {
                    s = this.trimOffComment(line.substring(5).trim());
                    super_go_ids.add(new GoId(s));
                    continue;
                }
                if (in_term && line.startsWith("relationship:")) {
                    s = this.trimOffComment(line.substring(13).trim());
                    go_relationships.add(new BasicGoRelationship(s));
                    continue;
                }
                if (!in_term || !line.startsWith("subset:")) continue;
                s = line.substring(8).trim();
                go_subsets.add(new BasicGoSubset(s));
            }
        }
        catch (Exception e) {
            throw new IOException("parsing problem: " + e.getMessage() + " [at line " + line_number + "]");
        }
        if (id.length() > 0) {
            this.createNewGoTerm(go_terms, id, name, namespace, is_obsolete, comment, def, alt_ids, go_xrefs, super_go_ids, go_relationships, go_subsets);
        }
        return go_terms;
    }

    private void setGoTermCount(int go_term_count) {
        this._go_term_count = go_term_count;
    }

    private String trimOffComment(String xref) {
        int i = xref.indexOf(33);
        if (i > 0) {
            xref = xref.substring(0, xref.indexOf(33)).trim();
        }
        return xref;
    }

    public static enum ReturnType {
        BASIC_GO_TERM;

    }
}

