/*
 * Decompiled with CFR 0.152.
 */
package org.forester.development;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import org.forester.development.AbstractRenderer;
import org.forester.development.MsaRenderer;

public class ResidueRenderer
extends AbstractRenderer {
    static final Color EMPTY_COLOR = new Color(250, 0, 250);
    static final Color POSITIVE_COLOR = new Color(250, 0, 250);
    static final Color NEGATIVE_COLOR = new Color(250, 0, 250);
    static final Color NULL_COLOR = new Color(50, 50, 50);
    static final int DISTANCE_OVAL_BORDER = 1;
    static final int SIZE_LIMIT = 7;
    private static final long serialVersionUID = -2331160296913478874L;
    private final char _value;
    private Color _wellColor;
    private boolean _isMarked;
    private boolean _isSelected;
    private final MsaRenderer _parentPlateRenderer;

    public ResidueRenderer(char value, MsaRenderer parentPlateRenderer) {
        this._value = value;
        this._parentPlateRenderer = parentPlateRenderer;
        this.setIsSelected(false);
        this.setIsMarked(false);
        this.setStatus((byte)0);
    }

    private double calcFactor(double min, double max) {
        return (max - min) / 255.0;
    }

    private Color calcWellColor(double value, double min, double max, Color minColor, Color maxColor) {
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        double x = 255.0 * (value - min) / (max - min);
        int red = (int)((double)minColor.getRed() + x * this.calcFactor(minColor.getRed(), maxColor.getRed()));
        int green = (int)((double)minColor.getGreen() + x * this.calcFactor(minColor.getGreen(), maxColor.getGreen()));
        int blue = (int)((double)minColor.getBlue() + x * this.calcFactor(minColor.getBlue(), maxColor.getBlue()));
        return new Color(red, green, blue);
    }

    private Color calcWellColor(double value, double min, double max, double mean, Color minColor, Color maxColor, Color meanColor) {
        if (meanColor == null) {
            return this.calcWellColor(value, min, max, minColor, maxColor);
        }
        if (value < min) {
            value = min;
        }
        if (value > max) {
            value = max;
        }
        if (value < mean) {
            double x = 255.0 * (value - min) / (mean - min);
            int red = (int)((double)minColor.getRed() + x * this.calcFactor(minColor.getRed(), meanColor.getRed()));
            int green = (int)((double)minColor.getGreen() + x * this.calcFactor(minColor.getGreen(), meanColor.getGreen()));
            int blue = (int)((double)minColor.getBlue() + x * this.calcFactor(minColor.getBlue(), meanColor.getBlue()));
            return new Color(red, green, blue);
        }
        if (value > mean) {
            double x = 255.0 * (value - mean) / (max - mean);
            int red = (int)((double)meanColor.getRed() + x * this.calcFactor(meanColor.getRed(), maxColor.getRed()));
            int green = (int)((double)meanColor.getGreen() + x * this.calcFactor(meanColor.getGreen(), maxColor.getGreen()));
            int blue = (int)((double)meanColor.getBlue() + x * this.calcFactor(meanColor.getBlue(), maxColor.getBlue()));
            return new Color(red, green, blue);
        }
        return meanColor;
    }

    public double getDataValue() {
        return this._value;
    }

    @Override
    public MsaRenderer getParentPlateRenderer() {
        return this._parentPlateRenderer;
    }

    public Color getWellColor() {
        return this._wellColor;
    }

    public boolean isMarked() {
        return this._isMarked;
    }

    @Override
    public boolean isSelected() {
        return this._isSelected;
    }

    @Override
    public void paint(Graphics g) {
        int width = this.getWellSize() - 1;
        int width_ = width - 1;
        int width__ = width_ - 1 + 1;
        int width__s = width__ - 2;
        int x_ = this.getX() + 1;
        int y_ = this.getY() + 1;
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        if (this.isMarked()) {
            g2.setColor(AbstractRenderer.MARKED_COLOR);
        } else {
            g2.setColor(AbstractRenderer.DEFAULT_COLOR);
        }
        g2.drawRect(this.getX(), this.getY(), width, width);
        g2.setColor(this.getWellColor());
        if (this.isMarked() || this.isSelected()) {
            g2.fillRect(this.getX() + 1, this.getY() + 1, width_, width_);
        } else {
            g2.fillRect(this.getX() + 1 - 1, this.getY() + 1 - 1, width_ + 2, width_ + 2);
        }
    }

    public void resetWellColor(double min, double max, Color minColor, Color maxColor) {
        this.setWellColor(this.calcWellColor(this.getDataValue(), min, max, minColor, maxColor));
    }

    public void resetWellColor(double min, double max, double mean, Color minColor, Color maxColor, Color meanColor) {
        this.setWellColor(this.calcWellColor(this.getDataValue(), min, max, mean, minColor, maxColor, meanColor));
    }

    public void setIsMarked(boolean isMarked) {
        this._isMarked = isMarked;
    }

    @Override
    public void setIsSelected(boolean isSelected) {
        this._isSelected = isSelected;
    }

    private void setWellColor(Color wellColor) {
        this._wellColor = wellColor;
    }
}

